/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCacheSubnetGroupResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<ModifyCacheSubnetGroupResponse.Builder, ModifyCacheSubnetGroupResponse> {
    private static final SdkField<CacheSubnetGroup> CACHE_SUBNET_GROUP_FIELD = SdkField
            .<CacheSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("CacheSubnetGroup")
            .getter(getter(ModifyCacheSubnetGroupResponse::cacheSubnetGroup)).setter(setter(Builder::cacheSubnetGroup))
            .constructor(CacheSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SUBNET_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CacheSubnetGroup cacheSubnetGroup;

    private ModifyCacheSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.cacheSubnetGroup = builder.cacheSubnetGroup;
    }

    /**
     * Returns the value of the CacheSubnetGroup property for this object.
     * 
     * @return The value of the CacheSubnetGroup property for this object.
     */
    public final CacheSubnetGroup cacheSubnetGroup() {
        return cacheSubnetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheSubnetGroupResponse)) {
            return false;
        }
        ModifyCacheSubnetGroupResponse other = (ModifyCacheSubnetGroupResponse) obj;
        return Objects.equals(cacheSubnetGroup(), other.cacheSubnetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCacheSubnetGroupResponse").add("CacheSubnetGroup", cacheSubnetGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSubnetGroup":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheSubnetGroup", CACHE_SUBNET_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCacheSubnetGroupResponse, T> g) {
        return obj -> g.apply((ModifyCacheSubnetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCacheSubnetGroupResponse> {
        /**
         * Sets the value of the CacheSubnetGroup property for this object.
         *
         * @param cacheSubnetGroup
         *        The new value for the CacheSubnetGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroup(CacheSubnetGroup cacheSubnetGroup);

        /**
         * Sets the value of the CacheSubnetGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CacheSubnetGroup.Builder} avoiding the
         * need to create one manually via {@link CacheSubnetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheSubnetGroup(CacheSubnetGroup)}.
         * 
         * @param cacheSubnetGroup
         *        a consumer that will call methods on {@link CacheSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheSubnetGroup(CacheSubnetGroup)
         */
        default Builder cacheSubnetGroup(Consumer<CacheSubnetGroup.Builder> cacheSubnetGroup) {
            return cacheSubnetGroup(CacheSubnetGroup.builder().applyMutation(cacheSubnetGroup).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private CacheSubnetGroup cacheSubnetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheSubnetGroupResponse model) {
            super(model);
            cacheSubnetGroup(model.cacheSubnetGroup);
        }

        public final CacheSubnetGroup.Builder getCacheSubnetGroup() {
            return cacheSubnetGroup != null ? cacheSubnetGroup.toBuilder() : null;
        }

        public final void setCacheSubnetGroup(CacheSubnetGroup.BuilderImpl cacheSubnetGroup) {
            this.cacheSubnetGroup = cacheSubnetGroup != null ? cacheSubnetGroup.build() : null;
        }

        @Override
        public final Builder cacheSubnetGroup(CacheSubnetGroup cacheSubnetGroup) {
            this.cacheSubnetGroup = cacheSubnetGroup;
            return this;
        }

        @Override
        public ModifyCacheSubnetGroupResponse build() {
            return new ModifyCacheSubnetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
