/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationGroupShardConfigurationRequest extends ElastiCacheRequest
        implements
        ToCopyableBuilder<ModifyReplicationGroupShardConfigurationRequest.Builder, ModifyReplicationGroupShardConfigurationRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(ModifyReplicationGroupShardConfigurationRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NodeGroupCount").getter(getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupCount))
            .setter(setter(Builder::nodeGroupCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyReplicationGroupShardConfigurationRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<List<ReshardingConfiguration>> RESHARDING_CONFIGURATION_FIELD = SdkField
            .<List<ReshardingConfiguration>> builder(MarshallingType.LIST)
            .memberName("ReshardingConfiguration")
            .getter(getter(ModifyReplicationGroupShardConfigurationRequest::reshardingConfiguration))
            .setter(setter(Builder::reshardingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReshardingConfiguration")
                            .memberFieldInfo(
                                    SdkField.<ReshardingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReshardingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReshardingConfiguration").build()).build()).build()).build();

    private static final SdkField<List<String>> NODE_GROUPS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeGroupsToRemove")
            .getter(getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupsToRemove))
            .setter(setter(Builder::nodeGroupsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroupToRemove")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroupToRemove").build()).build()).build()).build();

    private static final SdkField<List<String>> NODE_GROUPS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeGroupsToRetain")
            .getter(getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupsToRetain))
            .setter(setter(Builder::nodeGroupsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroupToRetain")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroupToRetain").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            NODE_GROUP_COUNT_FIELD, APPLY_IMMEDIATELY_FIELD, RESHARDING_CONFIGURATION_FIELD, NODE_GROUPS_TO_REMOVE_FIELD,
            NODE_GROUPS_TO_RETAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationGroupId;

    private final Integer nodeGroupCount;

    private final Boolean applyImmediately;

    private final List<ReshardingConfiguration> reshardingConfiguration;

    private final List<String> nodeGroupsToRemove;

    private final List<String> nodeGroupsToRetain;

    private ModifyReplicationGroupShardConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.applyImmediately = builder.applyImmediately;
        this.reshardingConfiguration = builder.reshardingConfiguration;
        this.nodeGroupsToRemove = builder.nodeGroupsToRemove;
        this.nodeGroupsToRetain = builder.nodeGroupsToRetain;
    }

    /**
     * <p>
     * The name of the Valkey or Redis OSS (cluster mode enabled) cluster (replication group) on which the shards are to
     * be configured.
     * </p>
     * 
     * @return The name of the Valkey or Redis OSS (cluster mode enabled) cluster (replication group) on which the
     *         shards are to be configured.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The number of node groups (shards) that results from the modification of the shard configuration.
     * </p>
     * 
     * @return The number of node groups (shards) that results from the modification of the shard configuration.
     */
    public final Integer nodeGroupCount() {
        return nodeGroupCount;
    }

    /**
     * <p>
     * Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for
     * this parameter is <code>true</code>.
     * </p>
     * <p>
     * Value: true
     * </p>
     * 
     * @return Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value
     *         for this parameter is <code>true</code>.</p>
     *         <p>
     *         Value: true
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReshardingConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReshardingConfiguration() {
        return reshardingConfiguration != null && !(reshardingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the preferred availability zones for each node group in the cluster. If the value of
     * <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this
     * parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter
     * ElastiCache selects availability zones for you.
     * </p>
     * <p>
     * You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current
     * number of node groups (shards).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReshardingConfiguration} method.
     * </p>
     * 
     * @return Specifies the preferred availability zones for each node group in the cluster. If the value of
     *         <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this
     *         parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter
     *         ElastiCache selects availability zones for you.</p>
     *         <p>
     *         You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the
     *         current number of node groups (shards).
     */
    public final List<ReshardingConfiguration> reshardingConfiguration() {
        return reshardingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeGroupsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeGroupsToRemove() {
        return nodeGroupsToRemove != null && !(nodeGroupsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either
     * <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code>
     * is a list of <code>NodeGroupId</code>s to remove from the cluster.
     * </p>
     * <p>
     * ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeGroupsToRemove} method.
     * </p>
     * 
     * @return If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
     *         either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
     *         <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
     *         <p>
     *         ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the
     *         cluster.
     */
    public final List<String> nodeGroupsToRemove() {
        return nodeGroupsToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeGroupsToRetain property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeGroupsToRetain() {
        return nodeGroupsToRetain != null && !(nodeGroupsToRetain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either
     * <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code>
     * is a list of <code>NodeGroupId</code>s to retain in the cluster.
     * </p>
     * <p>
     * ElastiCache will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from
     * the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeGroupsToRetain} method.
     * </p>
     * 
     * @return If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
     *         either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
     *         <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
     *         <p>
     *         ElastiCache will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code>
     *         from the cluster.
     */
    public final List<String> nodeGroupsToRetain() {
        return nodeGroupsToRetain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(hasReshardingConfiguration() ? reshardingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeGroupsToRemove() ? nodeGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeGroupsToRetain() ? nodeGroupsToRetain() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupShardConfigurationRequest)) {
            return false;
        }
        ModifyReplicationGroupShardConfigurationRequest other = (ModifyReplicationGroupShardConfigurationRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(nodeGroupCount(), other.nodeGroupCount())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && hasReshardingConfiguration() == other.hasReshardingConfiguration()
                && Objects.equals(reshardingConfiguration(), other.reshardingConfiguration())
                && hasNodeGroupsToRemove() == other.hasNodeGroupsToRemove()
                && Objects.equals(nodeGroupsToRemove(), other.nodeGroupsToRemove())
                && hasNodeGroupsToRetain() == other.hasNodeGroupsToRetain()
                && Objects.equals(nodeGroupsToRetain(), other.nodeGroupsToRetain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReplicationGroupShardConfigurationRequest")
                .add("ReplicationGroupId", replicationGroupId()).add("NodeGroupCount", nodeGroupCount())
                .add("ApplyImmediately", applyImmediately())
                .add("ReshardingConfiguration", hasReshardingConfiguration() ? reshardingConfiguration() : null)
                .add("NodeGroupsToRemove", hasNodeGroupsToRemove() ? nodeGroupsToRemove() : null)
                .add("NodeGroupsToRetain", hasNodeGroupsToRetain() ? nodeGroupsToRetain() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "NodeGroupCount":
            return Optional.ofNullable(clazz.cast(nodeGroupCount()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "ReshardingConfiguration":
            return Optional.ofNullable(clazz.cast(reshardingConfiguration()));
        case "NodeGroupsToRemove":
            return Optional.ofNullable(clazz.cast(nodeGroupsToRemove()));
        case "NodeGroupsToRetain":
            return Optional.ofNullable(clazz.cast(nodeGroupsToRetain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("NodeGroupCount", NODE_GROUP_COUNT_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        map.put("ReshardingConfiguration", RESHARDING_CONFIGURATION_FIELD);
        map.put("NodeGroupsToRemove", NODE_GROUPS_TO_REMOVE_FIELD);
        map.put("NodeGroupsToRetain", NODE_GROUPS_TO_RETAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationGroupShardConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyReplicationGroupShardConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationGroupShardConfigurationRequest> {
        /**
         * <p>
         * The name of the Valkey or Redis OSS (cluster mode enabled) cluster (replication group) on which the shards
         * are to be configured.
         * </p>
         * 
         * @param replicationGroupId
         *        The name of the Valkey or Redis OSS (cluster mode enabled) cluster (replication group) on which the
         *        shards are to be configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The number of node groups (shards) that results from the modification of the shard configuration.
         * </p>
         * 
         * @param nodeGroupCount
         *        The number of node groups (shards) that results from the modification of the shard configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupCount(Integer nodeGroupCount);

        /**
         * <p>
         * Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for
         * this parameter is <code>true</code>.
         * </p>
         * <p>
         * Value: true
         * </p>
         * 
         * @param applyImmediately
         *        Indicates that the shard reconfiguration process begins immediately. At present, the only permitted
         *        value for this parameter is <code>true</code>.</p>
         *        <p>
         *        Value: true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * Specifies the preferred availability zones for each node group in the cluster. If the value of
         * <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this
         * parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter
         * ElastiCache selects availability zones for you.
         * </p>
         * <p>
         * You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current
         * number of node groups (shards).
         * </p>
         * 
         * @param reshardingConfiguration
         *        Specifies the preferred availability zones for each node group in the cluster. If the value of
         *        <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use
         *        this parameter to specify the preferred availability zones of the cluster's shards. If you omit this
         *        parameter ElastiCache selects availability zones for you.</p>
         *        <p>
         *        You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the
         *        current number of node groups (shards).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration);

        /**
         * <p>
         * Specifies the preferred availability zones for each node group in the cluster. If the value of
         * <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this
         * parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter
         * ElastiCache selects availability zones for you.
         * </p>
         * <p>
         * You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current
         * number of node groups (shards).
         * </p>
         * 
         * @param reshardingConfiguration
         *        Specifies the preferred availability zones for each node group in the cluster. If the value of
         *        <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use
         *        this parameter to specify the preferred availability zones of the cluster's shards. If you omit this
         *        parameter ElastiCache selects availability zones for you.</p>
         *        <p>
         *        You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the
         *        current number of node groups (shards).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reshardingConfiguration(ReshardingConfiguration... reshardingConfiguration);

        /**
         * <p>
         * Specifies the preferred availability zones for each node group in the cluster. If the value of
         * <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this
         * parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter
         * ElastiCache selects availability zones for you.
         * </p>
         * <p>
         * You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current
         * number of node groups (shards).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #reshardingConfiguration(List<ReshardingConfiguration>)}.
         * 
         * @param reshardingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reshardingConfiguration(java.util.Collection<ReshardingConfiguration>)
         */
        Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder>... reshardingConfiguration);

        /**
         * <p>
         * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
         * either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         * <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.
         * </p>
         * <p>
         * ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the
         * cluster.
         * </p>
         * 
         * @param nodeGroupsToRemove
         *        If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards),
         *        then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         *        <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
         *        <p>
         *        ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupsToRemove(Collection<String> nodeGroupsToRemove);

        /**
         * <p>
         * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
         * either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         * <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.
         * </p>
         * <p>
         * ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the
         * cluster.
         * </p>
         * 
         * @param nodeGroupsToRemove
         *        If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards),
         *        then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         *        <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
         *        <p>
         *        ElastiCache will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupsToRemove(String... nodeGroupsToRemove);

        /**
         * <p>
         * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
         * either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         * <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.
         * </p>
         * <p>
         * ElastiCache will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code>
         * from the cluster.
         * </p>
         * 
         * @param nodeGroupsToRetain
         *        If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards),
         *        then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         *        <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
         *        <p>
         *        ElastiCache will attempt to remove all node groups except those listed by
         *        <code>NodeGroupsToRetain</code> from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupsToRetain(Collection<String> nodeGroupsToRetain);

        /**
         * <p>
         * If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then
         * either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         * <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.
         * </p>
         * <p>
         * ElastiCache will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code>
         * from the cluster.
         * </p>
         * 
         * @param nodeGroupsToRetain
         *        If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards),
         *        then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required.
         *        <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
         *        <p>
         *        ElastiCache will attempt to remove all node groups except those listed by
         *        <code>NodeGroupsToRetain</code> from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupsToRetain(String... nodeGroupsToRetain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private Integer nodeGroupCount;

        private Boolean applyImmediately;

        private List<ReshardingConfiguration> reshardingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodeGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodeGroupsToRetain = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupShardConfigurationRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            nodeGroupCount(model.nodeGroupCount);
            applyImmediately(model.applyImmediately);
            reshardingConfiguration(model.reshardingConfiguration);
            nodeGroupsToRemove(model.nodeGroupsToRemove);
            nodeGroupsToRetain(model.nodeGroupsToRetain);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final Integer getNodeGroupCount() {
            return nodeGroupCount;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final List<ReshardingConfiguration.Builder> getReshardingConfiguration() {
            List<ReshardingConfiguration.Builder> result = ReshardingConfigurationListCopier
                    .copyToBuilder(this.reshardingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReshardingConfiguration(Collection<ReshardingConfiguration.BuilderImpl> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copyFromBuilder(reshardingConfiguration);
        }

        @Override
        public final Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copy(reshardingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reshardingConfiguration(ReshardingConfiguration... reshardingConfiguration) {
            reshardingConfiguration(Arrays.asList(reshardingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder>... reshardingConfiguration) {
            reshardingConfiguration(Stream.of(reshardingConfiguration)
                    .map(c -> ReshardingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNodeGroupsToRemove() {
            if (nodeGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeGroupsToRemove;
        }

        public final void setNodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
        }

        @Override
        public final Builder nodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupsToRemove(String... nodeGroupsToRemove) {
            nodeGroupsToRemove(Arrays.asList(nodeGroupsToRemove));
            return this;
        }

        public final Collection<String> getNodeGroupsToRetain() {
            if (nodeGroupsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeGroupsToRetain;
        }

        public final void setNodeGroupsToRetain(Collection<String> nodeGroupsToRetain) {
            this.nodeGroupsToRetain = NodeGroupsToRetainListCopier.copy(nodeGroupsToRetain);
        }

        @Override
        public final Builder nodeGroupsToRetain(Collection<String> nodeGroupsToRetain) {
            this.nodeGroupsToRetain = NodeGroupsToRetainListCopier.copy(nodeGroupsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupsToRetain(String... nodeGroupsToRetain) {
            nodeGroupsToRetain(Arrays.asList(nodeGroupsToRetain));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupShardConfigurationRequest build() {
            return new ModifyReplicationGroupShardConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
