/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an individual cache node in a snapshot of a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeSnapshot implements SdkPojo, Serializable, ToCopyableBuilder<NodeSnapshot.Builder, NodeSnapshot> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(NodeSnapshot::cacheClusterId)).setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeGroupId").getter(getter(NodeSnapshot::nodeGroupId)).setter(setter(Builder::nodeGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()).build();

    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeId").getter(getter(NodeSnapshot::cacheNodeId)).setter(setter(Builder::cacheNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()).build();

    private static final SdkField<NodeGroupConfiguration> NODE_GROUP_CONFIGURATION_FIELD = SdkField
            .<NodeGroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("NodeGroupConfiguration")
            .getter(getter(NodeSnapshot::nodeGroupConfiguration)).setter(setter(Builder::nodeGroupConfiguration))
            .constructor(NodeGroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build())
            .build();

    private static final SdkField<String> CACHE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSize").getter(getter(NodeSnapshot::cacheSize)).setter(setter(Builder::cacheSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSize").build()).build();

    private static final SdkField<Instant> CACHE_NODE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CacheNodeCreateTime").getter(getter(NodeSnapshot::cacheNodeCreateTime))
            .setter(setter(Builder::cacheNodeCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCreateTime").build())
            .build();

    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SnapshotCreateTime").getter(getter(NodeSnapshot::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            NODE_GROUP_ID_FIELD, CACHE_NODE_ID_FIELD, NODE_GROUP_CONFIGURATION_FIELD, CACHE_SIZE_FIELD,
            CACHE_NODE_CREATE_TIME_FIELD, SNAPSHOT_CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cacheClusterId;

    private final String nodeGroupId;

    private final String cacheNodeId;

    private final NodeGroupConfiguration nodeGroupConfiguration;

    private final String cacheSize;

    private final Instant cacheNodeCreateTime;

    private final Instant snapshotCreateTime;

    private NodeSnapshot(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheSize = builder.cacheSize;
        this.cacheNodeCreateTime = builder.cacheNodeCreateTime;
        this.snapshotCreateTime = builder.snapshotCreateTime;
    }

    /**
     * <p>
     * A unique identifier for the source cluster.
     * </p>
     * 
     * @return A unique identifier for the source cluster.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * A unique identifier for the source node group (shard).
     * </p>
     * 
     * @return A unique identifier for the source node group (shard).
     */
    public final String nodeGroupId() {
        return nodeGroupId;
    }

    /**
     * <p>
     * The cache node identifier for the node in the source cluster.
     * </p>
     * 
     * @return The cache node identifier for the node in the source cluster.
     */
    public final String cacheNodeId() {
        return cacheNodeId;
    }

    /**
     * <p>
     * The configuration for the source node group (shard).
     * </p>
     * 
     * @return The configuration for the source node group (shard).
     */
    public final NodeGroupConfiguration nodeGroupConfiguration() {
        return nodeGroupConfiguration;
    }

    /**
     * <p>
     * The size of the cache on the source cache node.
     * </p>
     * 
     * @return The size of the cache on the source cache node.
     */
    public final String cacheSize() {
        return cacheSize;
    }

    /**
     * <p>
     * The date and time when the cache node was created in the source cluster.
     * </p>
     * 
     * @return The date and time when the cache node was created in the source cluster.
     */
    public final Instant cacheNodeCreateTime() {
        return cacheNodeCreateTime;
    }

    /**
     * <p>
     * The date and time when the source node's metadata and cache data set was obtained for the snapshot.
     * </p>
     * 
     * @return The date and time when the source node's metadata and cache data set was obtained for the snapshot.
     */
    public final Instant snapshotCreateTime() {
        return snapshotCreateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeSnapshot)) {
            return false;
        }
        NodeSnapshot other = (NodeSnapshot) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId()) && Objects.equals(nodeGroupId(), other.nodeGroupId())
                && Objects.equals(cacheNodeId(), other.cacheNodeId())
                && Objects.equals(nodeGroupConfiguration(), other.nodeGroupConfiguration())
                && Objects.equals(cacheSize(), other.cacheSize())
                && Objects.equals(cacheNodeCreateTime(), other.cacheNodeCreateTime())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeSnapshot").add("CacheClusterId", cacheClusterId()).add("NodeGroupId", nodeGroupId())
                .add("CacheNodeId", cacheNodeId()).add("NodeGroupConfiguration", nodeGroupConfiguration())
                .add("CacheSize", cacheSize()).add("CacheNodeCreateTime", cacheNodeCreateTime())
                .add("SnapshotCreateTime", snapshotCreateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "NodeGroupId":
            return Optional.ofNullable(clazz.cast(nodeGroupId()));
        case "CacheNodeId":
            return Optional.ofNullable(clazz.cast(cacheNodeId()));
        case "NodeGroupConfiguration":
            return Optional.ofNullable(clazz.cast(nodeGroupConfiguration()));
        case "CacheSize":
            return Optional.ofNullable(clazz.cast(cacheSize()));
        case "CacheNodeCreateTime":
            return Optional.ofNullable(clazz.cast(cacheNodeCreateTime()));
        case "SnapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
        map.put("NodeGroupId", NODE_GROUP_ID_FIELD);
        map.put("CacheNodeId", CACHE_NODE_ID_FIELD);
        map.put("NodeGroupConfiguration", NODE_GROUP_CONFIGURATION_FIELD);
        map.put("CacheSize", CACHE_SIZE_FIELD);
        map.put("CacheNodeCreateTime", CACHE_NODE_CREATE_TIME_FIELD);
        map.put("SnapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeSnapshot, T> g) {
        return obj -> g.apply((NodeSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeSnapshot> {
        /**
         * <p>
         * A unique identifier for the source cluster.
         * </p>
         * 
         * @param cacheClusterId
         *        A unique identifier for the source cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * A unique identifier for the source node group (shard).
         * </p>
         * 
         * @param nodeGroupId
         *        A unique identifier for the source node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupId(String nodeGroupId);

        /**
         * <p>
         * The cache node identifier for the node in the source cluster.
         * </p>
         * 
         * @param cacheNodeId
         *        The cache node identifier for the node in the source cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeId(String cacheNodeId);

        /**
         * <p>
         * The configuration for the source node group (shard).
         * </p>
         * 
         * @param nodeGroupConfiguration
         *        The configuration for the source node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupConfiguration(NodeGroupConfiguration nodeGroupConfiguration);

        /**
         * <p>
         * The configuration for the source node group (shard).
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeGroupConfiguration.Builder} avoiding
         * the need to create one manually via {@link NodeGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeGroupConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #nodeGroupConfiguration(NodeGroupConfiguration)}.
         * 
         * @param nodeGroupConfiguration
         *        a consumer that will call methods on {@link NodeGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroupConfiguration(NodeGroupConfiguration)
         */
        default Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> nodeGroupConfiguration) {
            return nodeGroupConfiguration(NodeGroupConfiguration.builder().applyMutation(nodeGroupConfiguration).build());
        }

        /**
         * <p>
         * The size of the cache on the source cache node.
         * </p>
         * 
         * @param cacheSize
         *        The size of the cache on the source cache node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSize(String cacheSize);

        /**
         * <p>
         * The date and time when the cache node was created in the source cluster.
         * </p>
         * 
         * @param cacheNodeCreateTime
         *        The date and time when the cache node was created in the source cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeCreateTime(Instant cacheNodeCreateTime);

        /**
         * <p>
         * The date and time when the source node's metadata and cache data set was obtained for the snapshot.
         * </p>
         * 
         * @param snapshotCreateTime
         *        The date and time when the source node's metadata and cache data set was obtained for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(Instant snapshotCreateTime);
    }

    static final class BuilderImpl implements Builder {
        private String cacheClusterId;

        private String nodeGroupId;

        private String cacheNodeId;

        private NodeGroupConfiguration nodeGroupConfiguration;

        private String cacheSize;

        private Instant cacheNodeCreateTime;

        private Instant snapshotCreateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeSnapshot model) {
            cacheClusterId(model.cacheClusterId);
            nodeGroupId(model.nodeGroupId);
            cacheNodeId(model.cacheNodeId);
            nodeGroupConfiguration(model.nodeGroupConfiguration);
            cacheSize(model.cacheSize);
            cacheNodeCreateTime(model.cacheNodeCreateTime);
            snapshotCreateTime(model.snapshotCreateTime);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getNodeGroupId() {
            return nodeGroupId;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final String getCacheNodeId() {
            return cacheNodeId;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final NodeGroupConfiguration.Builder getNodeGroupConfiguration() {
            return nodeGroupConfiguration != null ? nodeGroupConfiguration.toBuilder() : null;
        }

        public final void setNodeGroupConfiguration(NodeGroupConfiguration.BuilderImpl nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration != null ? nodeGroupConfiguration.build() : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration;
            return this;
        }

        public final String getCacheSize() {
            return cacheSize;
        }

        public final void setCacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
        }

        @Override
        public final Builder cacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public final Instant getCacheNodeCreateTime() {
            return cacheNodeCreateTime;
        }

        public final void setCacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
        }

        @Override
        public final Builder cacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        @Override
        public NodeSnapshot build() {
            return new NodeSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
