/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedCacheNodesOfferingResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<PurchaseReservedCacheNodesOfferingResponse.Builder, PurchaseReservedCacheNodesOfferingResponse> {
    private static final SdkField<ReservedCacheNode> RESERVED_CACHE_NODE_FIELD = SdkField
            .<ReservedCacheNode> builder(MarshallingType.SDK_POJO).memberName("ReservedCacheNode")
            .getter(getter(PurchaseReservedCacheNodesOfferingResponse::reservedCacheNode))
            .setter(setter(Builder::reservedCacheNode)).constructor(ReservedCacheNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CACHE_NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ReservedCacheNode reservedCacheNode;

    private PurchaseReservedCacheNodesOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedCacheNode = builder.reservedCacheNode;
    }

    /**
     * Returns the value of the ReservedCacheNode property for this object.
     * 
     * @return The value of the ReservedCacheNode property for this object.
     */
    public final ReservedCacheNode reservedCacheNode() {
        return reservedCacheNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedCacheNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedCacheNodesOfferingResponse)) {
            return false;
        }
        PurchaseReservedCacheNodesOfferingResponse other = (PurchaseReservedCacheNodesOfferingResponse) obj;
        return Objects.equals(reservedCacheNode(), other.reservedCacheNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedCacheNodesOfferingResponse").add("ReservedCacheNode", reservedCacheNode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCacheNode":
            return Optional.ofNullable(clazz.cast(reservedCacheNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedCacheNode", RESERVED_CACHE_NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedCacheNodesOfferingResponse, T> g) {
        return obj -> g.apply((PurchaseReservedCacheNodesOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedCacheNodesOfferingResponse> {
        /**
         * Sets the value of the ReservedCacheNode property for this object.
         *
         * @param reservedCacheNode
         *        The new value for the ReservedCacheNode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNode(ReservedCacheNode reservedCacheNode);

        /**
         * Sets the value of the ReservedCacheNode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ReservedCacheNode.Builder} avoiding the
         * need to create one manually via {@link ReservedCacheNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedCacheNode.Builder#build()} is called immediately and its
         * result is passed to {@link #reservedCacheNode(ReservedCacheNode)}.
         * 
         * @param reservedCacheNode
         *        a consumer that will call methods on {@link ReservedCacheNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedCacheNode(ReservedCacheNode)
         */
        default Builder reservedCacheNode(Consumer<ReservedCacheNode.Builder> reservedCacheNode) {
            return reservedCacheNode(ReservedCacheNode.builder().applyMutation(reservedCacheNode).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private ReservedCacheNode reservedCacheNode;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedCacheNodesOfferingResponse model) {
            super(model);
            reservedCacheNode(model.reservedCacheNode);
        }

        public final ReservedCacheNode.Builder getReservedCacheNode() {
            return reservedCacheNode != null ? reservedCacheNode.toBuilder() : null;
        }

        public final void setReservedCacheNode(ReservedCacheNode.BuilderImpl reservedCacheNode) {
            this.reservedCacheNode = reservedCacheNode != null ? reservedCacheNode.build() : null;
        }

        @Override
        public final Builder reservedCacheNode(ReservedCacheNode reservedCacheNode) {
            this.reservedCacheNode = reservedCacheNode;
            return this;
        }

        @Override
        public PurchaseReservedCacheNodesOfferingResponse build() {
            return new PurchaseReservedCacheNodesOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
