/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the user group update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserGroupsUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<UserGroupsUpdateStatus.Builder, UserGroupsUpdateStatus> {
    private static final SdkField<List<String>> USER_GROUP_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIdsToAdd")
            .getter(getter(UserGroupsUpdateStatus::userGroupIdsToAdd))
            .setter(setter(Builder::userGroupIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIdsToRemove")
            .getter(getter(UserGroupsUpdateStatus::userGroupIdsToRemove))
            .setter(setter(Builder::userGroupIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_IDS_TO_ADD_FIELD,
            USER_GROUP_IDS_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> userGroupIdsToAdd;

    private final List<String> userGroupIdsToRemove;

    private UserGroupsUpdateStatus(BuilderImpl builder) {
        this.userGroupIdsToAdd = builder.userGroupIdsToAdd;
        this.userGroupIdsToRemove = builder.userGroupIdsToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIdsToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIdsToAdd() {
        return userGroupIdsToAdd != null && !(userGroupIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the user group to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIdsToAdd} method.
     * </p>
     * 
     * @return The ID of the user group to add.
     */
    public final List<String> userGroupIdsToAdd() {
        return userGroupIdsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIdsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIdsToRemove() {
        return userGroupIdsToRemove != null && !(userGroupIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the user group to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIdsToRemove} method.
     * </p>
     * 
     * @return The ID of the user group to remove.
     */
    public final List<String> userGroupIdsToRemove() {
        return userGroupIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIdsToAdd() ? userGroupIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIdsToRemove() ? userGroupIdsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupsUpdateStatus)) {
            return false;
        }
        UserGroupsUpdateStatus other = (UserGroupsUpdateStatus) obj;
        return hasUserGroupIdsToAdd() == other.hasUserGroupIdsToAdd()
                && Objects.equals(userGroupIdsToAdd(), other.userGroupIdsToAdd())
                && hasUserGroupIdsToRemove() == other.hasUserGroupIdsToRemove()
                && Objects.equals(userGroupIdsToRemove(), other.userGroupIdsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserGroupsUpdateStatus")
                .add("UserGroupIdsToAdd", hasUserGroupIdsToAdd() ? userGroupIdsToAdd() : null)
                .add("UserGroupIdsToRemove", hasUserGroupIdsToRemove() ? userGroupIdsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupIdsToAdd":
            return Optional.ofNullable(clazz.cast(userGroupIdsToAdd()));
        case "UserGroupIdsToRemove":
            return Optional.ofNullable(clazz.cast(userGroupIdsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserGroupIdsToAdd", USER_GROUP_IDS_TO_ADD_FIELD);
        map.put("UserGroupIdsToRemove", USER_GROUP_IDS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserGroupsUpdateStatus, T> g) {
        return obj -> g.apply((UserGroupsUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserGroupsUpdateStatus> {
        /**
         * <p>
         * The ID of the user group to add.
         * </p>
         * 
         * @param userGroupIdsToAdd
         *        The ID of the user group to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToAdd(Collection<String> userGroupIdsToAdd);

        /**
         * <p>
         * The ID of the user group to add.
         * </p>
         * 
         * @param userGroupIdsToAdd
         *        The ID of the user group to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToAdd(String... userGroupIdsToAdd);

        /**
         * <p>
         * The ID of the user group to remove.
         * </p>
         * 
         * @param userGroupIdsToRemove
         *        The ID of the user group to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToRemove(Collection<String> userGroupIdsToRemove);

        /**
         * <p>
         * The ID of the user group to remove.
         * </p>
         * 
         * @param userGroupIdsToRemove
         *        The ID of the user group to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToRemove(String... userGroupIdsToRemove);
    }

    static final class BuilderImpl implements Builder {
        private List<String> userGroupIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroupIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupsUpdateStatus model) {
            userGroupIdsToAdd(model.userGroupIdsToAdd);
            userGroupIdsToRemove(model.userGroupIdsToRemove);
        }

        public final Collection<String> getUserGroupIdsToAdd() {
            if (userGroupIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIdsToAdd;
        }

        public final void setUserGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
        }

        @Override
        public final Builder userGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToAdd(String... userGroupIdsToAdd) {
            userGroupIdsToAdd(Arrays.asList(userGroupIdsToAdd));
            return this;
        }

        public final Collection<String> getUserGroupIdsToRemove() {
            if (userGroupIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIdsToRemove;
        }

        public final void setUserGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
        }

        @Override
        public final Builder userGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToRemove(String... userGroupIdsToRemove) {
            userGroupIdsToRemove(Arrays.asList(userGroupIdsToRemove));
            return this;
        }

        @Override
        public UserGroupsUpdateStatus build() {
            return new UserGroupsUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
