/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScaleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScaleConfig> {
    private static final SdkField<Integer> SCALE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalePercentage").getter(ScaleConfig.getter(ScaleConfig::scalePercentage)).setter(ScaleConfig.setter(Builder::scalePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalePercentage").build()}).build();
    private static final SdkField<Integer> SCALE_INTERVAL_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScaleIntervalMinutes").getter(ScaleConfig.getter(ScaleConfig::scaleIntervalMinutes)).setter(ScaleConfig.setter(Builder::scaleIntervalMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleIntervalMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_PERCENTAGE_FIELD, SCALE_INTERVAL_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScaleConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer scalePercentage;
    private final Integer scaleIntervalMinutes;

    private ScaleConfig(BuilderImpl builder) {
        this.scalePercentage = builder.scalePercentage;
        this.scaleIntervalMinutes = builder.scaleIntervalMinutes;
    }

    public final Integer scalePercentage() {
        return this.scalePercentage;
    }

    public final Integer scaleIntervalMinutes() {
        return this.scaleIntervalMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleIntervalMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScaleConfig)) {
            return false;
        }
        ScaleConfig other = (ScaleConfig)obj;
        return Objects.equals(this.scalePercentage(), other.scalePercentage()) && Objects.equals(this.scaleIntervalMinutes(), other.scaleIntervalMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"ScaleConfig").add("ScalePercentage", (Object)this.scalePercentage()).add("ScaleIntervalMinutes", (Object)this.scaleIntervalMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalePercentage": {
                return Optional.ofNullable(clazz.cast(this.scalePercentage()));
            }
            case "ScaleIntervalMinutes": {
                return Optional.ofNullable(clazz.cast(this.scaleIntervalMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("ScalePercentage", SCALE_PERCENTAGE_FIELD);
        map.put("ScaleIntervalMinutes", SCALE_INTERVAL_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScaleConfig, T> g) {
        return obj -> g.apply((ScaleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer scalePercentage;
        private Integer scaleIntervalMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ScaleConfig model) {
            this.scalePercentage(model.scalePercentage);
            this.scaleIntervalMinutes(model.scaleIntervalMinutes);
        }

        public final Integer getScalePercentage() {
            return this.scalePercentage;
        }

        public final void setScalePercentage(Integer scalePercentage) {
            this.scalePercentage = scalePercentage;
        }

        @Override
        public final Builder scalePercentage(Integer scalePercentage) {
            this.scalePercentage = scalePercentage;
            return this;
        }

        public final Integer getScaleIntervalMinutes() {
            return this.scaleIntervalMinutes;
        }

        public final void setScaleIntervalMinutes(Integer scaleIntervalMinutes) {
            this.scaleIntervalMinutes = scaleIntervalMinutes;
        }

        @Override
        public final Builder scaleIntervalMinutes(Integer scaleIntervalMinutes) {
            this.scaleIntervalMinutes = scaleIntervalMinutes;
            return this;
        }

        public ScaleConfig build() {
            return new ScaleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScaleConfig> {
        public Builder scalePercentage(Integer var1);

        public Builder scaleIntervalMinutes(Integer var1);
    }
}

