/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyGlobalReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyGlobalReplicationGroupRequest.Builder, ModifyGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId").getter(getter(ModifyGlobalReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyGlobalReplicationGroupRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(ModifyGlobalReplicationGroupRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyGlobalReplicationGroupRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyGlobalReplicationGroupRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(ModifyGlobalReplicationGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupDescription")
            .getter(getter(ModifyGlobalReplicationGroupRequest::globalReplicationGroupDescription))
            .setter(setter(Builder::globalReplicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFailoverEnabled").getter(getter(ModifyGlobalReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, APPLY_IMMEDIATELY_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD,
            AUTOMATIC_FAILOVER_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalReplicationGroupId;

    private final Boolean applyImmediately;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupName;

    private final String globalReplicationGroupDescription;

    private final Boolean automaticFailoverEnabled;

    private ModifyGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.applyImmediately = builder.applyImmediately;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * This parameter causes the modifications in this request and any pending modifications to be applied,
     * asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be
     * applied in PreferredMaintenceWindow.
     * </p>
     * 
     * @return This parameter causes the modifications in this request and any pending modifications to be applied,
     *         asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to
     *         be applied in PreferredMaintenceWindow.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * A valid cache node type that you want to scale this Global datastore to.
     * </p>
     * 
     * @return A valid cache node type that you want to scale this Global datastore to.
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * Modifies the engine listed in a global replication group message. The options are redis, memcached or valkey.
     * </p>
     * 
     * @return Modifies the engine listed in a global replication group message. The options are redis, memcached or
     *         valkey.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The upgraded version of the cache engine to be run on the clusters in the Global datastore.
     * </p>
     * 
     * @return The upgraded version of the cache engine to be run on the clusters in the Global datastore.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the cache parameter group to use with the Global datastore. It must be compatible with the major
     * engine version used by the Global datastore.
     * </p>
     * 
     * @return The name of the cache parameter group to use with the Global datastore. It must be compatible with the
     *         major engine version used by the Global datastore.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * A description of the Global datastore
     * </p>
     * 
     * @return A description of the Global datastore
     */
    public final String globalReplicationGroupDescription() {
        return globalReplicationGroupDescription;
    }

    /**
     * <p>
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     * encounters a failure.
     * </p>
     * 
     * @return Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     *         encounters a failure.
     */
    public final Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyGlobalReplicationGroupRequest)) {
            return false;
        }
        ModifyGlobalReplicationGroupRequest other = (ModifyGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(globalReplicationGroupDescription(), other.globalReplicationGroupDescription())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("ApplyImmediately", applyImmediately())
                .add("CacheNodeType", cacheNodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("CacheParameterGroupName", cacheParameterGroupName())
                .add("GlobalReplicationGroupDescription", globalReplicationGroupDescription())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "GlobalReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupDescription()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("CacheParameterGroupName", CACHE_PARAMETER_GROUP_NAME_FIELD);
        map.put("GlobalReplicationGroupDescription", GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD);
        map.put("AutomaticFailoverEnabled", AUTOMATIC_FAILOVER_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((ModifyGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * This parameter causes the modifications in this request and any pending modifications to be applied,
         * asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be
         * applied in PreferredMaintenceWindow.
         * </p>
         * 
         * @param applyImmediately
         *        This parameter causes the modifications in this request and any pending modifications to be applied,
         *        asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested
         *        to be applied in PreferredMaintenceWindow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * A valid cache node type that you want to scale this Global datastore to.
         * </p>
         * 
         * @param cacheNodeType
         *        A valid cache node type that you want to scale this Global datastore to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * Modifies the engine listed in a global replication group message. The options are redis, memcached or valkey.
         * </p>
         * 
         * @param engine
         *        Modifies the engine listed in a global replication group message. The options are redis, memcached or
         *        valkey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The upgraded version of the cache engine to be run on the clusters in the Global datastore.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the cache engine to be run on the clusters in the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the cache parameter group to use with the Global datastore. It must be compatible with the major
         * engine version used by the Global datastore.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to use with the Global datastore. It must be compatible with the
         *        major engine version used by the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * A description of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupDescription
         *        A description of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupDescription(String globalReplicationGroupDescription);

        /**
         * <p>
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
         * encounters a failure.
         * </p>
         * 
         * @param automaticFailoverEnabled
         *        Determines whether a read replica is automatically promoted to read/write primary if the existing
         *        primary encounters a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Boolean applyImmediately;

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheParameterGroupName;

        private String globalReplicationGroupDescription;

        private Boolean automaticFailoverEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            applyImmediately(model.applyImmediately);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupName(model.cacheParameterGroupName);
            globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getGlobalReplicationGroupDescription() {
            return globalReplicationGroupDescription;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyGlobalReplicationGroupRequest build() {
            return new ModifyGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
