/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyUserResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<ModifyUserResponse.Builder, ModifyUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(ModifyUserResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(ModifyUserResponse::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyUserResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyUserResponse::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumEngineVersion").getter(getter(ModifyUserResponse::minimumEngineVersion))
            .setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(ModifyUserResponse::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIds")
            .getter(getter(ModifyUserResponse::userGroupIds))
            .setter(setter(Builder::userGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Authentication> AUTHENTICATION_FIELD = SdkField
            .<Authentication> builder(MarshallingType.SDK_POJO).memberName("Authentication")
            .getter(getter(ModifyUserResponse::authentication)).setter(setter(Builder::authentication))
            .constructor(Authentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ModifyUserResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_NAME_FIELD, STATUS_FIELD, ENGINE_FIELD, MINIMUM_ENGINE_VERSION_FIELD, ACCESS_STRING_FIELD, USER_GROUP_IDS_FIELD,
            AUTHENTICATION_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userId;

    private final String userName;

    private final String status;

    private final String engine;

    private final String minimumEngineVersion;

    private final String accessString;

    private final List<String> userGroupIds;

    private final Authentication authentication;

    private final String arn;

    private ModifyUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.status = builder.status;
        this.engine = builder.engine;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.accessString = builder.accessString;
        this.userGroupIds = builder.userGroupIds;
        this.authentication = builder.authentication;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The username of the user.
     * </p>
     * 
     * @return The username of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Indicates the user status. Can be "active", "modifying" or "deleting".
     * </p>
     * 
     * @return Indicates the user status. Can be "active", "modifying" or "deleting".
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The options are valkey or redis.
     * </p>
     * 
     * @return The options are valkey or redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The minimum engine version required, which is Redis OSS 6.0
     * </p>
     * 
     * @return The minimum engine version required, which is Redis OSS 6.0
     */
    public final String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIds() {
        return userGroupIds != null && !(userGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of the user group IDs the user belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIds} method.
     * </p>
     * 
     * @return Returns a list of the user group IDs the user belongs to.
     */
    public final List<String> userGroupIds() {
        return userGroupIds;
    }

    /**
     * <p>
     * Denotes whether the user requires a password to authenticate.
     * </p>
     * 
     * @return Denotes whether the user requires a password to authenticate.
     */
    public final Authentication authentication() {
        return authentication;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIds() ? userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserResponse)) {
            return false;
        }
        ModifyUserResponse other = (ModifyUserResponse) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(status(), other.status()) && Objects.equals(engine(), other.engine())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion())
                && Objects.equals(accessString(), other.accessString()) && hasUserGroupIds() == other.hasUserGroupIds()
                && Objects.equals(userGroupIds(), other.userGroupIds())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyUserResponse").add("UserId", userId()).add("UserName", userName()).add("Status", status())
                .add("Engine", engine()).add("MinimumEngineVersion", minimumEngineVersion()).add("AccessString", accessString())
                .add("UserGroupIds", hasUserGroupIds() ? userGroupIds() : null).add("Authentication", authentication())
                .add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        case "UserGroupIds":
            return Optional.ofNullable(clazz.cast(userGroupIds()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserId", USER_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        map.put("AccessString", ACCESS_STRING_FIELD);
        map.put("UserGroupIds", USER_GROUP_IDS_FIELD);
        map.put("Authentication", AUTHENTICATION_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserResponse, T> g) {
        return obj -> g.apply((ModifyUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyUserResponse> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The username of the user.
         * </p>
         * 
         * @param userName
         *        The username of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Indicates the user status. Can be "active", "modifying" or "deleting".
         * </p>
         * 
         * @param status
         *        Indicates the user status. Can be "active", "modifying" or "deleting".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The options are valkey or redis.
         * </p>
         * 
         * @param engine
         *        The options are valkey or redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The minimum engine version required, which is Redis OSS 6.0
         * </p>
         * 
         * @param minimumEngineVersion
         *        The minimum engine version required, which is Redis OSS 6.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        /**
         * <p>
         * Returns a list of the user group IDs the user belongs to.
         * </p>
         * 
         * @param userGroupIds
         *        Returns a list of the user group IDs the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(Collection<String> userGroupIds);

        /**
         * <p>
         * Returns a list of the user group IDs the user belongs to.
         * </p>
         * 
         * @param userGroupIds
         *        Returns a list of the user group IDs the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(String... userGroupIds);

        /**
         * <p>
         * Denotes whether the user requires a password to authenticate.
         * </p>
         * 
         * @param authentication
         *        Denotes whether the user requires a password to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(Authentication authentication);

        /**
         * <p>
         * Denotes whether the user requires a password to authenticate.
         * </p>
         * This is a convenience method that creates an instance of the {@link Authentication.Builder} avoiding the need
         * to create one manually via {@link Authentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Authentication.Builder#build()} is called immediately and its
         * result is passed to {@link #authentication(Authentication)}.
         * 
         * @param authentication
         *        a consumer that will call methods on {@link Authentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authentication(Authentication)
         */
        default Builder authentication(Consumer<Authentication.Builder> authentication) {
            return authentication(Authentication.builder().applyMutation(authentication).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String userId;

        private String userName;

        private String status;

        private String engine;

        private String minimumEngineVersion;

        private String accessString;

        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Authentication authentication;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserResponse model) {
            super(model);
            userId(model.userId);
            userName(model.userName);
            status(model.status);
            engine(model.engine);
            minimumEngineVersion(model.minimumEngineVersion);
            accessString(model.accessString);
            userGroupIds(model.userGroupIds);
            authentication(model.authentication);
            arn(model.arn);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final String getAccessString() {
            return accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final Collection<String> getUserGroupIds() {
            if (userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIds;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String... userGroupIds) {
            userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final Authentication.Builder getAuthentication() {
            return authentication != null ? authentication.toBuilder() : null;
        }

        public final void setAuthentication(Authentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ModifyUserResponse build() {
            return new ModifyUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
