/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the service update on the node group member
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeGroupMemberUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeGroupMemberUpdateStatus.Builder, NodeGroupMemberUpdateStatus> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(NodeGroupMemberUpdateStatus::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeId").getter(getter(NodeGroupMemberUpdateStatus::cacheNodeId))
            .setter(setter(Builder::cacheNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()).build();

    private static final SdkField<String> NODE_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeUpdateStatus").getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateStatusAsString))
            .setter(setter(Builder::nodeUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatus").build()).build();

    private static final SdkField<Instant> NODE_DELETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeDeletionDate").getter(getter(NodeGroupMemberUpdateStatus::nodeDeletionDate))
            .setter(setter(Builder::nodeDeletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDeletionDate").build()).build();

    private static final SdkField<Instant> NODE_UPDATE_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateStartDate").getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateStartDate))
            .setter(setter(Builder::nodeUpdateStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStartDate").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateEndDate").getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateEndDate))
            .setter(setter(Builder::nodeUpdateEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateEndDate").build()).build();

    private static final SdkField<String> NODE_UPDATE_INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeUpdateInitiatedBy").getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateInitiatedByAsString))
            .setter(setter(Builder::nodeUpdateInitiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedBy").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_INITIATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateInitiatedDate").getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateInitiatedDate))
            .setter(setter(Builder::nodeUpdateInitiatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedDate").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateStatusModifiedDate")
            .getter(getter(NodeGroupMemberUpdateStatus::nodeUpdateStatusModifiedDate))
            .setter(setter(Builder::nodeUpdateStatusModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatusModifiedDate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            CACHE_NODE_ID_FIELD, NODE_UPDATE_STATUS_FIELD, NODE_DELETION_DATE_FIELD, NODE_UPDATE_START_DATE_FIELD,
            NODE_UPDATE_END_DATE_FIELD, NODE_UPDATE_INITIATED_BY_FIELD, NODE_UPDATE_INITIATED_DATE_FIELD,
            NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cacheClusterId;

    private final String cacheNodeId;

    private final String nodeUpdateStatus;

    private final Instant nodeDeletionDate;

    private final Instant nodeUpdateStartDate;

    private final Instant nodeUpdateEndDate;

    private final String nodeUpdateInitiatedBy;

    private final Instant nodeUpdateInitiatedDate;

    private final Instant nodeUpdateStatusModifiedDate;

    private NodeGroupMemberUpdateStatus(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeUpdateStatus = builder.nodeUpdateStatus;
        this.nodeDeletionDate = builder.nodeDeletionDate;
        this.nodeUpdateStartDate = builder.nodeUpdateStartDate;
        this.nodeUpdateEndDate = builder.nodeUpdateEndDate;
        this.nodeUpdateInitiatedBy = builder.nodeUpdateInitiatedBy;
        this.nodeUpdateInitiatedDate = builder.nodeUpdateInitiatedDate;
        this.nodeUpdateStatusModifiedDate = builder.nodeUpdateStatusModifiedDate;
    }

    /**
     * <p>
     * The cache cluster ID
     * </p>
     * 
     * @return The cache cluster ID
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The node ID of the cache cluster
     * </p>
     * 
     * @return The node ID of the cache cluster
     */
    public final String cacheNodeId() {
        return cacheNodeId;
    }

    /**
     * <p>
     * The update status of the node
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeUpdateStatus}
     * will return {@link NodeUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeUpdateStatusAsString}.
     * </p>
     * 
     * @return The update status of the node
     * @see NodeUpdateStatus
     */
    public final NodeUpdateStatus nodeUpdateStatus() {
        return NodeUpdateStatus.fromValue(nodeUpdateStatus);
    }

    /**
     * <p>
     * The update status of the node
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeUpdateStatus}
     * will return {@link NodeUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeUpdateStatusAsString}.
     * </p>
     * 
     * @return The update status of the node
     * @see NodeUpdateStatus
     */
    public final String nodeUpdateStatusAsString() {
        return nodeUpdateStatus;
    }

    /**
     * <p>
     * The deletion date of the node
     * </p>
     * 
     * @return The deletion date of the node
     */
    public final Instant nodeDeletionDate() {
        return nodeDeletionDate;
    }

    /**
     * <p>
     * The start date of the update for a node
     * </p>
     * 
     * @return The start date of the update for a node
     */
    public final Instant nodeUpdateStartDate() {
        return nodeUpdateStartDate;
    }

    /**
     * <p>
     * The end date of the update for a node
     * </p>
     * 
     * @return The end date of the update for a node
     */
    public final Instant nodeUpdateEndDate() {
        return nodeUpdateEndDate;
    }

    /**
     * <p>
     * Reflects whether the update was initiated by the customer or automatically applied
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeUpdateInitiatedBy} will return {@link NodeUpdateInitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeUpdateInitiatedByAsString}.
     * </p>
     * 
     * @return Reflects whether the update was initiated by the customer or automatically applied
     * @see NodeUpdateInitiatedBy
     */
    public final NodeUpdateInitiatedBy nodeUpdateInitiatedBy() {
        return NodeUpdateInitiatedBy.fromValue(nodeUpdateInitiatedBy);
    }

    /**
     * <p>
     * Reflects whether the update was initiated by the customer or automatically applied
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeUpdateInitiatedBy} will return {@link NodeUpdateInitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeUpdateInitiatedByAsString}.
     * </p>
     * 
     * @return Reflects whether the update was initiated by the customer or automatically applied
     * @see NodeUpdateInitiatedBy
     */
    public final String nodeUpdateInitiatedByAsString() {
        return nodeUpdateInitiatedBy;
    }

    /**
     * <p>
     * The date when the update is triggered
     * </p>
     * 
     * @return The date when the update is triggered
     */
    public final Instant nodeUpdateInitiatedDate() {
        return nodeUpdateInitiatedDate;
    }

    /**
     * <p>
     * The date when the NodeUpdateStatus was last modified
     * </p>
     * 
     * @return The date when the NodeUpdateStatus was last modified
     */
    public final Instant nodeUpdateStatusModifiedDate() {
        return nodeUpdateStatusModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDeletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateInitiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateInitiatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStatusModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMemberUpdateStatus)) {
            return false;
        }
        NodeGroupMemberUpdateStatus other = (NodeGroupMemberUpdateStatus) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId()) && Objects.equals(cacheNodeId(), other.cacheNodeId())
                && Objects.equals(nodeUpdateStatusAsString(), other.nodeUpdateStatusAsString())
                && Objects.equals(nodeDeletionDate(), other.nodeDeletionDate())
                && Objects.equals(nodeUpdateStartDate(), other.nodeUpdateStartDate())
                && Objects.equals(nodeUpdateEndDate(), other.nodeUpdateEndDate())
                && Objects.equals(nodeUpdateInitiatedByAsString(), other.nodeUpdateInitiatedByAsString())
                && Objects.equals(nodeUpdateInitiatedDate(), other.nodeUpdateInitiatedDate())
                && Objects.equals(nodeUpdateStatusModifiedDate(), other.nodeUpdateStatusModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeGroupMemberUpdateStatus").add("CacheClusterId", cacheClusterId())
                .add("CacheNodeId", cacheNodeId()).add("NodeUpdateStatus", nodeUpdateStatusAsString())
                .add("NodeDeletionDate", nodeDeletionDate()).add("NodeUpdateStartDate", nodeUpdateStartDate())
                .add("NodeUpdateEndDate", nodeUpdateEndDate()).add("NodeUpdateInitiatedBy", nodeUpdateInitiatedByAsString())
                .add("NodeUpdateInitiatedDate", nodeUpdateInitiatedDate())
                .add("NodeUpdateStatusModifiedDate", nodeUpdateStatusModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "CacheNodeId":
            return Optional.ofNullable(clazz.cast(cacheNodeId()));
        case "NodeUpdateStatus":
            return Optional.ofNullable(clazz.cast(nodeUpdateStatusAsString()));
        case "NodeDeletionDate":
            return Optional.ofNullable(clazz.cast(nodeDeletionDate()));
        case "NodeUpdateStartDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateStartDate()));
        case "NodeUpdateEndDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateEndDate()));
        case "NodeUpdateInitiatedBy":
            return Optional.ofNullable(clazz.cast(nodeUpdateInitiatedByAsString()));
        case "NodeUpdateInitiatedDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateInitiatedDate()));
        case "NodeUpdateStatusModifiedDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateStatusModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
        map.put("CacheNodeId", CACHE_NODE_ID_FIELD);
        map.put("NodeUpdateStatus", NODE_UPDATE_STATUS_FIELD);
        map.put("NodeDeletionDate", NODE_DELETION_DATE_FIELD);
        map.put("NodeUpdateStartDate", NODE_UPDATE_START_DATE_FIELD);
        map.put("NodeUpdateEndDate", NODE_UPDATE_END_DATE_FIELD);
        map.put("NodeUpdateInitiatedBy", NODE_UPDATE_INITIATED_BY_FIELD);
        map.put("NodeUpdateInitiatedDate", NODE_UPDATE_INITIATED_DATE_FIELD);
        map.put("NodeUpdateStatusModifiedDate", NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupMemberUpdateStatus, T> g) {
        return obj -> g.apply((NodeGroupMemberUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeGroupMemberUpdateStatus> {
        /**
         * <p>
         * The cache cluster ID
         * </p>
         * 
         * @param cacheClusterId
         *        The cache cluster ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The node ID of the cache cluster
         * </p>
         * 
         * @param cacheNodeId
         *        The node ID of the cache cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeId(String cacheNodeId);

        /**
         * <p>
         * The update status of the node
         * </p>
         * 
         * @param nodeUpdateStatus
         *        The update status of the node
         * @see NodeUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateStatus
         */
        Builder nodeUpdateStatus(String nodeUpdateStatus);

        /**
         * <p>
         * The update status of the node
         * </p>
         * 
         * @param nodeUpdateStatus
         *        The update status of the node
         * @see NodeUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateStatus
         */
        Builder nodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus);

        /**
         * <p>
         * The deletion date of the node
         * </p>
         * 
         * @param nodeDeletionDate
         *        The deletion date of the node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDeletionDate(Instant nodeDeletionDate);

        /**
         * <p>
         * The start date of the update for a node
         * </p>
         * 
         * @param nodeUpdateStartDate
         *        The start date of the update for a node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateStartDate(Instant nodeUpdateStartDate);

        /**
         * <p>
         * The end date of the update for a node
         * </p>
         * 
         * @param nodeUpdateEndDate
         *        The end date of the update for a node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateEndDate(Instant nodeUpdateEndDate);

        /**
         * <p>
         * Reflects whether the update was initiated by the customer or automatically applied
         * </p>
         * 
         * @param nodeUpdateInitiatedBy
         *        Reflects whether the update was initiated by the customer or automatically applied
         * @see NodeUpdateInitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateInitiatedBy
         */
        Builder nodeUpdateInitiatedBy(String nodeUpdateInitiatedBy);

        /**
         * <p>
         * Reflects whether the update was initiated by the customer or automatically applied
         * </p>
         * 
         * @param nodeUpdateInitiatedBy
         *        Reflects whether the update was initiated by the customer or automatically applied
         * @see NodeUpdateInitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateInitiatedBy
         */
        Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy nodeUpdateInitiatedBy);

        /**
         * <p>
         * The date when the update is triggered
         * </p>
         * 
         * @param nodeUpdateInitiatedDate
         *        The date when the update is triggered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate);

        /**
         * <p>
         * The date when the NodeUpdateStatus was last modified
         * </p>
         * 
         * @param nodeUpdateStatusModifiedDate
         *        The date when the NodeUpdateStatus was last modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String cacheClusterId;

        private String cacheNodeId;

        private String nodeUpdateStatus;

        private Instant nodeDeletionDate;

        private Instant nodeUpdateStartDate;

        private Instant nodeUpdateEndDate;

        private String nodeUpdateInitiatedBy;

        private Instant nodeUpdateInitiatedDate;

        private Instant nodeUpdateStatusModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMemberUpdateStatus model) {
            cacheClusterId(model.cacheClusterId);
            cacheNodeId(model.cacheNodeId);
            nodeUpdateStatus(model.nodeUpdateStatus);
            nodeDeletionDate(model.nodeDeletionDate);
            nodeUpdateStartDate(model.nodeUpdateStartDate);
            nodeUpdateEndDate(model.nodeUpdateEndDate);
            nodeUpdateInitiatedBy(model.nodeUpdateInitiatedBy);
            nodeUpdateInitiatedDate(model.nodeUpdateInitiatedDate);
            nodeUpdateStatusModifiedDate(model.nodeUpdateStatusModifiedDate);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getCacheNodeId() {
            return cacheNodeId;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final String getNodeUpdateStatus() {
            return nodeUpdateStatus;
        }

        public final void setNodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
        }

        @Override
        public final Builder nodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
            return this;
        }

        @Override
        public final Builder nodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus) {
            this.nodeUpdateStatus(nodeUpdateStatus == null ? null : nodeUpdateStatus.toString());
            return this;
        }

        public final Instant getNodeDeletionDate() {
            return nodeDeletionDate;
        }

        public final void setNodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
        }

        @Override
        public final Builder nodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
            return this;
        }

        public final Instant getNodeUpdateStartDate() {
            return nodeUpdateStartDate;
        }

        public final void setNodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
        }

        @Override
        public final Builder nodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
            return this;
        }

        public final Instant getNodeUpdateEndDate() {
            return nodeUpdateEndDate;
        }

        public final void setNodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
        }

        @Override
        public final Builder nodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
            return this;
        }

        public final String getNodeUpdateInitiatedBy() {
            return nodeUpdateInitiatedBy;
        }

        public final void setNodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
            return this;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy(nodeUpdateInitiatedBy == null ? null : nodeUpdateInitiatedBy.toString());
            return this;
        }

        public final Instant getNodeUpdateInitiatedDate() {
            return nodeUpdateInitiatedDate;
        }

        public final void setNodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
        }

        @Override
        public final Builder nodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
            return this;
        }

        public final Instant getNodeUpdateStatusModifiedDate() {
            return nodeUpdateStatusModifiedDate;
        }

        public final void setNodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
        }

        @Override
        public final Builder nodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
            return this;
        }

        @Override
        public NodeGroupMemberUpdateStatus build() {
            return new NodeGroupMemberUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
