/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeCacheSecurityGroupIngressRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<RevokeCacheSecurityGroupIngressRequest.Builder, RevokeCacheSecurityGroupIngressRequest> {
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSecurityGroupName").getter(getter(RevokeCacheSecurityGroupIngressRequest::cacheSecurityGroupName))
            .setter(setter(Builder::cacheSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupName").getter(getter(RevokeCacheSecurityGroupIngressRequest::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupOwnerId")
            .getter(getter(RevokeCacheSecurityGroupIngressRequest::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cacheSecurityGroupName;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupOwnerId;

    private RevokeCacheSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * The name of the cache security group to revoke ingress from.
     * </p>
     * 
     * @return The name of the cache security group to revoke ingress from.
     */
    public final String cacheSecurityGroupName() {
        return cacheSecurityGroupName;
    }

    /**
     * <p>
     * The name of the Amazon EC2 security group to revoke access from.
     * </p>
     * 
     * @return The name of the Amazon EC2 security group to revoke access from.
     */
    public final String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an
     * Amazon access key ID - you must provide a valid Amazon account number for this parameter.
     * </p>
     * 
     * @return The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as
     *         an Amazon access key ID - you must provide a valid Amazon account number for this parameter.
     */
    public final String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCacheSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeCacheSecurityGroupIngressRequest other = (RevokeCacheSecurityGroupIngressRequest) obj;
        return Objects.equals(cacheSecurityGroupName(), other.cacheSecurityGroupName())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeCacheSecurityGroupIngressRequest").add("CacheSecurityGroupName", cacheSecurityGroupName())
                .add("EC2SecurityGroupName", ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", ec2SecurityGroupOwnerId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSecurityGroupName":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupName()));
        case "EC2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "EC2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheSecurityGroupName", CACHE_SECURITY_GROUP_NAME_FIELD);
        map.put("EC2SecurityGroupName", EC2_SECURITY_GROUP_NAME_FIELD);
        map.put("EC2SecurityGroupOwnerId", EC2_SECURITY_GROUP_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeCacheSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((RevokeCacheSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokeCacheSecurityGroupIngressRequest> {
        /**
         * <p>
         * The name of the cache security group to revoke ingress from.
         * </p>
         * 
         * @param cacheSecurityGroupName
         *        The name of the cache security group to revoke ingress from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupName(String cacheSecurityGroupName);

        /**
         * <p>
         * The name of the Amazon EC2 security group to revoke access from.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        The name of the Amazon EC2 security group to revoke access from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an
         * Amazon access key ID - you must provide a valid Amazon account number for this parameter.
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing
         *        as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheSecurityGroupName;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCacheSecurityGroupIngressRequest model) {
            super(model);
            cacheSecurityGroupName(model.cacheSecurityGroupName);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getCacheSecurityGroupName() {
            return cacheSecurityGroupName;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCacheSecurityGroupIngressRequest build() {
            return new RevokeCacheSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
