/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for horizontal or vertical scaling operations on Memcached clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScaleConfig implements SdkPojo, Serializable, ToCopyableBuilder<ScaleConfig.Builder, ScaleConfig> {
    private static final SdkField<Integer> SCALE_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScalePercentage").getter(getter(ScaleConfig::scalePercentage)).setter(setter(Builder::scalePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalePercentage").build()).build();

    private static final SdkField<Integer> SCALE_INTERVAL_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScaleIntervalMinutes").getter(getter(ScaleConfig::scaleIntervalMinutes))
            .setter(setter(Builder::scaleIntervalMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleIntervalMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_PERCENTAGE_FIELD,
            SCALE_INTERVAL_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer scalePercentage;

    private final Integer scaleIntervalMinutes;

    private ScaleConfig(BuilderImpl builder) {
        this.scalePercentage = builder.scalePercentage;
        this.scaleIntervalMinutes = builder.scaleIntervalMinutes;
    }

    /**
     * <p>
     * The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or vertically by
     * increasing resources.
     * </p>
     * 
     * @return The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or vertically
     *         by increasing resources.
     */
    public final Integer scalePercentage() {
        return scalePercentage;
    }

    /**
     * <p>
     * The time interval in seconds between scaling operations when performing gradual scaling for a Memcached cluster.
     * </p>
     * 
     * @return The time interval in seconds between scaling operations when performing gradual scaling for a Memcached
     *         cluster.
     */
    public final Integer scaleIntervalMinutes() {
        return scaleIntervalMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scaleIntervalMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScaleConfig)) {
            return false;
        }
        ScaleConfig other = (ScaleConfig) obj;
        return Objects.equals(scalePercentage(), other.scalePercentage())
                && Objects.equals(scaleIntervalMinutes(), other.scaleIntervalMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScaleConfig").add("ScalePercentage", scalePercentage())
                .add("ScaleIntervalMinutes", scaleIntervalMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalePercentage":
            return Optional.ofNullable(clazz.cast(scalePercentage()));
        case "ScaleIntervalMinutes":
            return Optional.ofNullable(clazz.cast(scaleIntervalMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalePercentage", SCALE_PERCENTAGE_FIELD);
        map.put("ScaleIntervalMinutes", SCALE_INTERVAL_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScaleConfig, T> g) {
        return obj -> g.apply((ScaleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScaleConfig> {
        /**
         * <p>
         * The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or vertically by
         * increasing resources.
         * </p>
         * 
         * @param scalePercentage
         *        The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or
         *        vertically by increasing resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalePercentage(Integer scalePercentage);

        /**
         * <p>
         * The time interval in seconds between scaling operations when performing gradual scaling for a Memcached
         * cluster.
         * </p>
         * 
         * @param scaleIntervalMinutes
         *        The time interval in seconds between scaling operations when performing gradual scaling for a
         *        Memcached cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleIntervalMinutes(Integer scaleIntervalMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer scalePercentage;

        private Integer scaleIntervalMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ScaleConfig model) {
            scalePercentage(model.scalePercentage);
            scaleIntervalMinutes(model.scaleIntervalMinutes);
        }

        public final Integer getScalePercentage() {
            return scalePercentage;
        }

        public final void setScalePercentage(Integer scalePercentage) {
            this.scalePercentage = scalePercentage;
        }

        @Override
        public final Builder scalePercentage(Integer scalePercentage) {
            this.scalePercentage = scalePercentage;
            return this;
        }

        public final Integer getScaleIntervalMinutes() {
            return scaleIntervalMinutes;
        }

        public final void setScaleIntervalMinutes(Integer scaleIntervalMinutes) {
            this.scaleIntervalMinutes = scaleIntervalMinutes;
        }

        @Override
        public final Builder scaleIntervalMinutes(Integer scaleIntervalMinutes) {
            this.scaleIntervalMinutes = scaleIntervalMinutes;
            return this;
        }

        @Override
        public ScaleConfig build() {
            return new ScaleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
