/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGlobalReplicationGroupsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeGlobalReplicationGroupsRequest.Builder, DescribeGlobalReplicationGroupsRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId")
            .getter(getter(DescribeGlobalReplicationGroupsRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeGlobalReplicationGroupsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeGlobalReplicationGroupsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Boolean> SHOW_MEMBER_INFO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowMemberInfo").getter(getter(DescribeGlobalReplicationGroupsRequest::showMemberInfo))
            .setter(setter(Builder::showMemberInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowMemberInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, SHOW_MEMBER_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalReplicationGroupId;

    private final Integer maxRecords;

    private final String marker;

    private final Boolean showMemberInfo;

    private DescribeGlobalReplicationGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.showMemberInfo = builder.showMemberInfo;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified MaxRecords
     * value, a marker is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns the list of members that comprise the Global datastore.
     * </p>
     * 
     * @return Returns the list of members that comprise the Global datastore.
     */
    public final Boolean showMemberInfo() {
        return showMemberInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(showMemberInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalReplicationGroupsRequest)) {
            return false;
        }
        DescribeGlobalReplicationGroupsRequest other = (DescribeGlobalReplicationGroupsRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker())
                && Objects.equals(showMemberInfo(), other.showMemberInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGlobalReplicationGroupsRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("MaxRecords", maxRecords())
                .add("Marker", marker()).add("ShowMemberInfo", showMemberInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ShowMemberInfo":
            return Optional.ofNullable(clazz.cast(showMemberInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("ShowMemberInfo", SHOW_MEMBER_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalReplicationGroupsRequest, T> g) {
        return obj -> g.apply((DescribeGlobalReplicationGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGlobalReplicationGroupsRequest> {
        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords
         * value, a marker is included in the response so that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns the list of members that comprise the Global datastore.
         * </p>
         * 
         * @param showMemberInfo
         *        Returns the list of members that comprise the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showMemberInfo(Boolean showMemberInfo);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Integer maxRecords;

        private String marker;

        private Boolean showMemberInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalReplicationGroupsRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            maxRecords(model.maxRecords);
            marker(model.marker);
            showMemberInfo(model.showMemberInfo);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getShowMemberInfo() {
            return showMemberInfo;
        }

        public final void setShowMemberInfo(Boolean showMemberInfo) {
            this.showMemberInfo = showMemberInfo;
        }

        @Override
        public final Builder showMemberInfo(Boolean showMemberInfo) {
            this.showMemberInfo = showMemberInfo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGlobalReplicationGroupsRequest build() {
            return new DescribeGlobalReplicationGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
