/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationDetails.Builder, DestinationDetails> {
    private static final SdkField<CloudWatchLogsDestinationDetails> CLOUD_WATCH_LOGS_DETAILS_FIELD = SdkField
            .<CloudWatchLogsDestinationDetails> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogsDetails")
            .getter(getter(DestinationDetails::cloudWatchLogsDetails)).setter(setter(Builder::cloudWatchLogsDetails))
            .constructor(CloudWatchLogsDestinationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDetails").build())
            .build();

    private static final SdkField<KinesisFirehoseDestinationDetails> KINESIS_FIREHOSE_DETAILS_FIELD = SdkField
            .<KinesisFirehoseDestinationDetails> builder(MarshallingType.SDK_POJO).memberName("KinesisFirehoseDetails")
            .getter(getter(DestinationDetails::kinesisFirehoseDetails)).setter(setter(Builder::kinesisFirehoseDetails))
            .constructor(KinesisFirehoseDestinationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_DETAILS_FIELD, KINESIS_FIREHOSE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsDestinationDetails cloudWatchLogsDetails;

    private final KinesisFirehoseDestinationDetails kinesisFirehoseDetails;

    private DestinationDetails(BuilderImpl builder) {
        this.cloudWatchLogsDetails = builder.cloudWatchLogsDetails;
        this.kinesisFirehoseDetails = builder.kinesisFirehoseDetails;
    }

    /**
     * <p>
     * The configuration details of the CloudWatch Logs destination.
     * </p>
     * 
     * @return The configuration details of the CloudWatch Logs destination.
     */
    public final CloudWatchLogsDestinationDetails cloudWatchLogsDetails() {
        return cloudWatchLogsDetails;
    }

    /**
     * <p>
     * The configuration details of the Kinesis Data Firehose destination.
     * </p>
     * 
     * @return The configuration details of the Kinesis Data Firehose destination.
     */
    public final KinesisFirehoseDestinationDetails kinesisFirehoseDetails() {
        return kinesisFirehoseDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDetails)) {
            return false;
        }
        DestinationDetails other = (DestinationDetails) obj;
        return Objects.equals(cloudWatchLogsDetails(), other.cloudWatchLogsDetails())
                && Objects.equals(kinesisFirehoseDetails(), other.kinesisFirehoseDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationDetails").add("CloudWatchLogsDetails", cloudWatchLogsDetails())
                .add("KinesisFirehoseDetails", kinesisFirehoseDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsDetails":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsDetails()));
        case "KinesisFirehoseDetails":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLogsDetails", CLOUD_WATCH_LOGS_DETAILS_FIELD);
        map.put("KinesisFirehoseDetails", KINESIS_FIREHOSE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationDetails, T> g) {
        return obj -> g.apply((DestinationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationDetails> {
        /**
         * <p>
         * The configuration details of the CloudWatch Logs destination.
         * </p>
         * 
         * @param cloudWatchLogsDetails
         *        The configuration details of the CloudWatch Logs destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsDetails(CloudWatchLogsDestinationDetails cloudWatchLogsDetails);

        /**
         * <p>
         * The configuration details of the CloudWatch Logs destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsDestinationDetails.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsDestinationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestinationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsDetails(CloudWatchLogsDestinationDetails)}.
         * 
         * @param cloudWatchLogsDetails
         *        a consumer that will call methods on {@link CloudWatchLogsDestinationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsDetails(CloudWatchLogsDestinationDetails)
         */
        default Builder cloudWatchLogsDetails(Consumer<CloudWatchLogsDestinationDetails.Builder> cloudWatchLogsDetails) {
            return cloudWatchLogsDetails(CloudWatchLogsDestinationDetails.builder().applyMutation(cloudWatchLogsDetails).build());
        }

        /**
         * <p>
         * The configuration details of the Kinesis Data Firehose destination.
         * </p>
         * 
         * @param kinesisFirehoseDetails
         *        The configuration details of the Kinesis Data Firehose destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseDetails(KinesisFirehoseDestinationDetails kinesisFirehoseDetails);

        /**
         * <p>
         * The configuration details of the Kinesis Data Firehose destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisFirehoseDestinationDetails.Builder} avoiding the need to create one manually via
         * {@link KinesisFirehoseDestinationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisFirehoseDestinationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #kinesisFirehoseDetails(KinesisFirehoseDestinationDetails)}.
         * 
         * @param kinesisFirehoseDetails
         *        a consumer that will call methods on {@link KinesisFirehoseDestinationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseDetails(KinesisFirehoseDestinationDetails)
         */
        default Builder kinesisFirehoseDetails(Consumer<KinesisFirehoseDestinationDetails.Builder> kinesisFirehoseDetails) {
            return kinesisFirehoseDetails(KinesisFirehoseDestinationDetails.builder().applyMutation(kinesisFirehoseDetails)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsDestinationDetails cloudWatchLogsDetails;

        private KinesisFirehoseDestinationDetails kinesisFirehoseDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDetails model) {
            cloudWatchLogsDetails(model.cloudWatchLogsDetails);
            kinesisFirehoseDetails(model.kinesisFirehoseDetails);
        }

        public final CloudWatchLogsDestinationDetails.Builder getCloudWatchLogsDetails() {
            return cloudWatchLogsDetails != null ? cloudWatchLogsDetails.toBuilder() : null;
        }

        public final void setCloudWatchLogsDetails(CloudWatchLogsDestinationDetails.BuilderImpl cloudWatchLogsDetails) {
            this.cloudWatchLogsDetails = cloudWatchLogsDetails != null ? cloudWatchLogsDetails.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsDetails(CloudWatchLogsDestinationDetails cloudWatchLogsDetails) {
            this.cloudWatchLogsDetails = cloudWatchLogsDetails;
            return this;
        }

        public final KinesisFirehoseDestinationDetails.Builder getKinesisFirehoseDetails() {
            return kinesisFirehoseDetails != null ? kinesisFirehoseDetails.toBuilder() : null;
        }

        public final void setKinesisFirehoseDetails(KinesisFirehoseDestinationDetails.BuilderImpl kinesisFirehoseDetails) {
            this.kinesisFirehoseDetails = kinesisFirehoseDetails != null ? kinesisFirehoseDetails.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseDetails(KinesisFirehoseDestinationDetails kinesisFirehoseDetails) {
            this.kinesisFirehoseDetails = kinesisFirehoseDetails;
            return this;
        }

        @Override
        public DestinationDetails build() {
            return new DestinationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
