/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportServerlessCacheSnapshotRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ExportServerlessCacheSnapshotRequest.Builder, ExportServerlessCacheSnapshotRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheSnapshotName")
            .getter(getter(ExportServerlessCacheSnapshotRequest::serverlessCacheSnapshotName))
            .setter(setter(Builder::serverlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName")
                    .build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(ExportServerlessCacheSnapshotRequest::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, S3_BUCKET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serverlessCacheSnapshotName;

    private final String s3BucketName;

    private ExportServerlessCacheSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
        this.s3BucketName = builder.s3BucketName;
    }

    /**
     * <p>
     * The identifier of the serverless cache snapshot to be exported to S3. Available for Valkey and Redis OSS only.
     * </p>
     * 
     * @return The identifier of the serverless cache snapshot to be exported to S3. Available for Valkey and Redis OSS
     *         only.
     */
    public final String serverlessCacheSnapshotName() {
        return serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3 bucket must also be in same region as the
     * snapshot. Available for Valkey and Redis OSS only.
     * </p>
     * 
     * @return Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3 bucket must also be in same region
     *         as the snapshot. Available for Valkey and Redis OSS only.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportServerlessCacheSnapshotRequest)) {
            return false;
        }
        ExportServerlessCacheSnapshotRequest other = (ExportServerlessCacheSnapshotRequest) obj;
        return Objects.equals(serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName())
                && Objects.equals(s3BucketName(), other.s3BucketName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportServerlessCacheSnapshotRequest")
                .add("ServerlessCacheSnapshotName", serverlessCacheSnapshotName()).add("S3BucketName", s3BucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshotName()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessCacheSnapshotName", SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportServerlessCacheSnapshotRequest, T> g) {
        return obj -> g.apply((ExportServerlessCacheSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportServerlessCacheSnapshotRequest> {
        /**
         * <p>
         * The identifier of the serverless cache snapshot to be exported to S3. Available for Valkey and Redis OSS
         * only.
         * </p>
         * 
         * @param serverlessCacheSnapshotName
         *        The identifier of the serverless cache snapshot to be exported to S3. Available for Valkey and Redis
         *        OSS only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName);

        /**
         * <p>
         * Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3 bucket must also be in same region as
         * the snapshot. Available for Valkey and Redis OSS only.
         * </p>
         * 
         * @param s3BucketName
         *        Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3 bucket must also be in same
         *        region as the snapshot. Available for Valkey and Redis OSS only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheSnapshotName;

        private String s3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportServerlessCacheSnapshotRequest model) {
            super(model);
            serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
            s3BucketName(model.s3BucketName);
        }

        public final String getServerlessCacheSnapshotName() {
            return serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportServerlessCacheSnapshotRequest build() {
            return new ExportServerlessCacheSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
