/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A member of a Global datastore. It contains the Replication Group Id, the Amazon region and the role of the
 * replication group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalReplicationGroupMember implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalReplicationGroupMember.Builder, GlobalReplicationGroupMember> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(GlobalReplicationGroupMember::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupRegion").getter(getter(GlobalReplicationGroupMember::replicationGroupRegion))
            .setter(setter(Builder::replicationGroupRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupRegion").build())
            .build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GlobalReplicationGroupMember::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomaticFailover").getter(getter(GlobalReplicationGroupMember::automaticFailoverAsString))
            .setter(setter(Builder::automaticFailover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GlobalReplicationGroupMember::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_REGION_FIELD, ROLE_FIELD, AUTOMATIC_FAILOVER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicationGroupId;

    private final String replicationGroupRegion;

    private final String role;

    private final String automaticFailover;

    private final String status;

    private GlobalReplicationGroupMember(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupRegion = builder.replicationGroupRegion;
        this.role = builder.role;
        this.automaticFailover = builder.automaticFailover;
        this.status = builder.status;
    }

    /**
     * <p>
     * The replication group id of the Global datastore member.
     * </p>
     * 
     * @return The replication group id of the Global datastore member.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The Amazon region of the Global datastore member.
     * </p>
     * 
     * @return The Amazon region of the Global datastore member.
     */
    public final String replicationGroupRegion() {
        return replicationGroupRegion;
    }

    /**
     * <p>
     * Indicates the role of the replication group, primary or secondary.
     * </p>
     * 
     * @return Indicates the role of the replication group, primary or secondary.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Indicates whether automatic failover is enabled for the replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates whether automatic failover is enabled for the replication group.
     * @see AutomaticFailoverStatus
     */
    public final AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(automaticFailover);
    }

    /**
     * <p>
     * Indicates whether automatic failover is enabled for the replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates whether automatic failover is enabled for the replication group.
     * @see AutomaticFailoverStatus
     */
    public final String automaticFailoverAsString() {
        return automaticFailover;
    }

    /**
     * <p>
     * The status of the membership of the replication group.
     * </p>
     * 
     * @return The status of the membership of the replication group.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalReplicationGroupMember)) {
            return false;
        }
        GlobalReplicationGroupMember other = (GlobalReplicationGroupMember) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupRegion(), other.replicationGroupRegion())
                && Objects.equals(role(), other.role())
                && Objects.equals(automaticFailoverAsString(), other.automaticFailoverAsString())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalReplicationGroupMember").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupRegion", replicationGroupRegion()).add("Role", role())
                .add("AutomaticFailover", automaticFailoverAsString()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupRegion":
            return Optional.ofNullable(clazz.cast(replicationGroupRegion()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "AutomaticFailover":
            return Optional.ofNullable(clazz.cast(automaticFailoverAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("ReplicationGroupRegion", REPLICATION_GROUP_REGION_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("AutomaticFailover", AUTOMATIC_FAILOVER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalReplicationGroupMember, T> g) {
        return obj -> g.apply((GlobalReplicationGroupMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalReplicationGroupMember> {
        /**
         * <p>
         * The replication group id of the Global datastore member.
         * </p>
         * 
         * @param replicationGroupId
         *        The replication group id of the Global datastore member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The Amazon region of the Global datastore member.
         * </p>
         * 
         * @param replicationGroupRegion
         *        The Amazon region of the Global datastore member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupRegion(String replicationGroupRegion);

        /**
         * <p>
         * Indicates the role of the replication group, primary or secondary.
         * </p>
         * 
         * @param role
         *        Indicates the role of the replication group, primary or secondary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Indicates whether automatic failover is enabled for the replication group.
         * </p>
         * 
         * @param automaticFailover
         *        Indicates whether automatic failover is enabled for the replication group.
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(String automaticFailover);

        /**
         * <p>
         * Indicates whether automatic failover is enabled for the replication group.
         * </p>
         * 
         * @param automaticFailover
         *        Indicates whether automatic failover is enabled for the replication group.
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(AutomaticFailoverStatus automaticFailover);

        /**
         * <p>
         * The status of the membership of the replication group.
         * </p>
         * 
         * @param status
         *        The status of the membership of the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupRegion;

        private String role;

        private String automaticFailover;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalReplicationGroupMember model) {
            replicationGroupId(model.replicationGroupId);
            replicationGroupRegion(model.replicationGroupRegion);
            role(model.role);
            automaticFailover(model.automaticFailover);
            status(model.status);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupRegion() {
            return replicationGroupRegion;
        }

        public final void setReplicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
        }

        @Override
        public final Builder replicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getAutomaticFailover() {
            return automaticFailover;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public GlobalReplicationGroupMember build() {
            return new GlobalReplicationGroupMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
