/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopUpdateActionRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<BatchStopUpdateActionRequest.Builder, BatchStopUpdateActionRequest> {
    private static final SdkField<List<String>> REPLICATION_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroupIds")
            .getter(getter(BatchStopUpdateActionRequest::replicationGroupIds))
            .setter(setter(Builder::replicationGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CACHE_CLUSTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheClusterIds")
            .getter(getter(BatchStopUpdateActionRequest::cacheClusterIds))
            .setter(setter(Builder::cacheClusterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(BatchStopUpdateActionRequest::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_IDS_FIELD,
            CACHE_CLUSTER_IDS_FIELD, SERVICE_UPDATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> replicationGroupIds;

    private final List<String> cacheClusterIds;

    private final String serviceUpdateName;

    private BatchStopUpdateActionRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupIds = builder.replicationGroupIds;
        this.cacheClusterIds = builder.cacheClusterIds;
        this.serviceUpdateName = builder.serviceUpdateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationGroupIds() {
        return replicationGroupIds != null && !(replicationGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication group IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroupIds} method.
     * </p>
     * 
     * @return The replication group IDs
     */
    public final List<String> replicationGroupIds() {
        return replicationGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheClusterIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheClusterIds() {
        return cacheClusterIds != null && !(cacheClusterIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cache cluster IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheClusterIds} method.
     * </p>
     * 
     * @return The cache cluster IDs
     */
    public final List<String> cacheClusterIds() {
        return cacheClusterIds;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroupIds() ? replicationGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheClusterIds() ? cacheClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopUpdateActionRequest)) {
            return false;
        }
        BatchStopUpdateActionRequest other = (BatchStopUpdateActionRequest) obj;
        return hasReplicationGroupIds() == other.hasReplicationGroupIds()
                && Objects.equals(replicationGroupIds(), other.replicationGroupIds())
                && hasCacheClusterIds() == other.hasCacheClusterIds()
                && Objects.equals(cacheClusterIds(), other.cacheClusterIds())
                && Objects.equals(serviceUpdateName(), other.serviceUpdateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStopUpdateActionRequest")
                .add("ReplicationGroupIds", hasReplicationGroupIds() ? replicationGroupIds() : null)
                .add("CacheClusterIds", hasCacheClusterIds() ? cacheClusterIds() : null)
                .add("ServiceUpdateName", serviceUpdateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupIds":
            return Optional.ofNullable(clazz.cast(replicationGroupIds()));
        case "CacheClusterIds":
            return Optional.ofNullable(clazz.cast(cacheClusterIds()));
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationGroupIds", REPLICATION_GROUP_IDS_FIELD);
        map.put("CacheClusterIds", CACHE_CLUSTER_IDS_FIELD);
        map.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStopUpdateActionRequest, T> g) {
        return obj -> g.apply((BatchStopUpdateActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchStopUpdateActionRequest> {
        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(Collection<String> replicationGroupIds);

        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(String... replicationGroupIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(Collection<String> cacheClusterIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(String... cacheClusterIds);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private List<String> replicationGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> cacheClusterIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceUpdateName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopUpdateActionRequest model) {
            super(model);
            replicationGroupIds(model.replicationGroupIds);
            cacheClusterIds(model.cacheClusterIds);
            serviceUpdateName(model.serviceUpdateName);
        }

        public final Collection<String> getReplicationGroupIds() {
            if (replicationGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationGroupIds;
        }

        public final void setReplicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
        }

        @Override
        public final Builder replicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupIds(String... replicationGroupIds) {
            replicationGroupIds(Arrays.asList(replicationGroupIds));
            return this;
        }

        public final Collection<String> getCacheClusterIds() {
            if (cacheClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheClusterIds;
        }

        public final void setCacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
        }

        @Override
        public final Builder cacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusterIds(String... cacheClusterIds) {
            cacheClusterIds(Arrays.asList(cacheClusterIds));
            return this;
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStopUpdateActionRequest build() {
            return new BatchStopUpdateActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
