/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyServerlessCacheSnapshotRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CopyServerlessCacheSnapshotRequest.Builder, CopyServerlessCacheSnapshotRequest> {
    private static final SdkField<String> SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceServerlessCacheSnapshotName")
            .getter(getter(CopyServerlessCacheSnapshotRequest::sourceServerlessCacheSnapshotName))
            .setter(setter(Builder::sourceServerlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceServerlessCacheSnapshotName")
                    .build()).build();

    private static final SdkField<String> TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetServerlessCacheSnapshotName")
            .getter(getter(CopyServerlessCacheSnapshotRequest::targetServerlessCacheSnapshotName))
            .setter(setter(Builder::targetServerlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetServerlessCacheSnapshotName")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CopyServerlessCacheSnapshotRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CopyServerlessCacheSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, KMS_KEY_ID_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceServerlessCacheSnapshotName;

    private final String targetServerlessCacheSnapshotName;

    private final String kmsKeyId;

    private final List<Tag> tags;

    private CopyServerlessCacheSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceServerlessCacheSnapshotName = builder.sourceServerlessCacheSnapshotName;
        this.targetServerlessCacheSnapshotName = builder.targetServerlessCacheSnapshotName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the existing serverless cache’s snapshot to be copied. Available for Valkey, Redis OSS and
     * Serverless Memcached only.
     * </p>
     * 
     * @return The identifier of the existing serverless cache’s snapshot to be copied. Available for Valkey, Redis OSS
     *         and Serverless Memcached only.
     */
    public final String sourceServerlessCacheSnapshotName() {
        return sourceServerlessCacheSnapshotName;
    }

    /**
     * <p>
     * The identifier for the snapshot to be created. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The identifier for the snapshot to be created. Available for Valkey, Redis OSS and Serverless Memcached
     *         only.
     */
    public final String targetServerlessCacheSnapshotName() {
        return targetServerlessCacheSnapshotName;
    }

    /**
     * <p>
     * The identifier of the KMS key used to encrypt the target snapshot. Available for Valkey, Redis OSS and Serverless
     * Memcached only.
     * </p>
     * 
     * @return The identifier of the KMS key used to encrypt the target snapshot. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for Valkey,
     * Redis OSS and Serverless Memcached only. Default: NULL
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for
     *         Valkey, Redis OSS and Serverless Memcached only. Default: NULL
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(targetServerlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyServerlessCacheSnapshotRequest)) {
            return false;
        }
        CopyServerlessCacheSnapshotRequest other = (CopyServerlessCacheSnapshotRequest) obj;
        return Objects.equals(sourceServerlessCacheSnapshotName(), other.sourceServerlessCacheSnapshotName())
                && Objects.equals(targetServerlessCacheSnapshotName(), other.targetServerlessCacheSnapshotName())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyServerlessCacheSnapshotRequest")
                .add("SourceServerlessCacheSnapshotName", sourceServerlessCacheSnapshotName())
                .add("TargetServerlessCacheSnapshotName", targetServerlessCacheSnapshotName()).add("KmsKeyId", kmsKeyId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(sourceServerlessCacheSnapshotName()));
        case "TargetServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(targetServerlessCacheSnapshotName()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceServerlessCacheSnapshotName", SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("TargetServerlessCacheSnapshotName", TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyServerlessCacheSnapshotRequest, T> g) {
        return obj -> g.apply((CopyServerlessCacheSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CopyServerlessCacheSnapshotRequest> {
        /**
         * <p>
         * The identifier of the existing serverless cache’s snapshot to be copied. Available for Valkey, Redis OSS and
         * Serverless Memcached only.
         * </p>
         * 
         * @param sourceServerlessCacheSnapshotName
         *        The identifier of the existing serverless cache’s snapshot to be copied. Available for Valkey, Redis
         *        OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerlessCacheSnapshotName(String sourceServerlessCacheSnapshotName);

        /**
         * <p>
         * The identifier for the snapshot to be created. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param targetServerlessCacheSnapshotName
         *        The identifier for the snapshot to be created. Available for Valkey, Redis OSS and Serverless
         *        Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetServerlessCacheSnapshotName(String targetServerlessCacheSnapshotName);

        /**
         * <p>
         * The identifier of the KMS key used to encrypt the target snapshot. Available for Valkey, Redis OSS and
         * Serverless Memcached only.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the KMS key used to encrypt the target snapshot. Available for Valkey, Redis OSS and
         *        Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for Valkey,
         * Redis OSS and Serverless Memcached only. Default: NULL
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for
         *        Valkey, Redis OSS and Serverless Memcached only. Default: NULL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for Valkey,
         * Redis OSS and Serverless Memcached only. Default: NULL
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for
         *        Valkey, Redis OSS and Serverless Memcached only. Default: NULL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for Valkey,
         * Redis OSS and Serverless Memcached only. Default: NULL
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String sourceServerlessCacheSnapshotName;

        private String targetServerlessCacheSnapshotName;

        private String kmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyServerlessCacheSnapshotRequest model) {
            super(model);
            sourceServerlessCacheSnapshotName(model.sourceServerlessCacheSnapshotName);
            targetServerlessCacheSnapshotName(model.targetServerlessCacheSnapshotName);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
        }

        public final String getSourceServerlessCacheSnapshotName() {
            return sourceServerlessCacheSnapshotName;
        }

        public final void setSourceServerlessCacheSnapshotName(String sourceServerlessCacheSnapshotName) {
            this.sourceServerlessCacheSnapshotName = sourceServerlessCacheSnapshotName;
        }

        @Override
        public final Builder sourceServerlessCacheSnapshotName(String sourceServerlessCacheSnapshotName) {
            this.sourceServerlessCacheSnapshotName = sourceServerlessCacheSnapshotName;
            return this;
        }

        public final String getTargetServerlessCacheSnapshotName() {
            return targetServerlessCacheSnapshotName;
        }

        public final void setTargetServerlessCacheSnapshotName(String targetServerlessCacheSnapshotName) {
            this.targetServerlessCacheSnapshotName = targetServerlessCacheSnapshotName;
        }

        @Override
        public final Builder targetServerlessCacheSnapshotName(String targetServerlessCacheSnapshotName) {
            this.targetServerlessCacheSnapshotName = targetServerlessCacheSnapshotName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyServerlessCacheSnapshotRequest build() {
            return new CopyServerlessCacheSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
