/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateGlobalReplicationGroupRequest.Builder, CreateGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupIdSuffix")
            .getter(getter(CreateGlobalReplicationGroupRequest::globalReplicationGroupIdSuffix))
            .setter(setter(Builder::globalReplicationGroupIdSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupIdSuffix")
                    .build()).build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupDescription")
            .getter(getter(CreateGlobalReplicationGroupRequest::globalReplicationGroupDescription))
            .setter(setter(Builder::globalReplicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> PRIMARY_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryReplicationGroupId")
            .getter(getter(CreateGlobalReplicationGroupRequest::primaryReplicationGroupId))
            .setter(setter(Builder::primaryReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryReplicationGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD, GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD,
            PRIMARY_REPLICATION_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalReplicationGroupIdSuffix;

    private final String globalReplicationGroupDescription;

    private final String primaryReplicationGroupId;

    private CreateGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupIdSuffix = builder.globalReplicationGroupIdSuffix;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.primaryReplicationGroupId = builder.primaryReplicationGroupId;
    }

    /**
     * <p>
     * The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore
     * ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the
     * US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the
     * auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions.
     * </p>
     * <p>
     * For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Redis-Global-Datastores-CLI.html">Using the Amazon
     * CLI with Global datastores </a>.
     * </p>
     * 
     * @return The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global
     *         datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore
     *         ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The
     *         suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name
     *         across multiple regions. </p>
     *         <p>
     *         For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Redis-Global-Datastores-CLI.html">Using the
     *         Amazon CLI with Global datastores </a>.
     */
    public final String globalReplicationGroupIdSuffix() {
        return globalReplicationGroupIdSuffix;
    }

    /**
     * <p>
     * Provides details of the Global datastore
     * </p>
     * 
     * @return Provides details of the Global datastore
     */
    public final String globalReplicationGroupDescription() {
        return globalReplicationGroupDescription;
    }

    /**
     * <p>
     * The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     * </p>
     * 
     * @return The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    public final String primaryReplicationGroupId() {
        return primaryReplicationGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupIdSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(primaryReplicationGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalReplicationGroupRequest)) {
            return false;
        }
        CreateGlobalReplicationGroupRequest other = (CreateGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupIdSuffix(), other.globalReplicationGroupIdSuffix())
                && Objects.equals(globalReplicationGroupDescription(), other.globalReplicationGroupDescription())
                && Objects.equals(primaryReplicationGroupId(), other.primaryReplicationGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupIdSuffix", globalReplicationGroupIdSuffix())
                .add("GlobalReplicationGroupDescription", globalReplicationGroupDescription())
                .add("PrimaryReplicationGroupId", primaryReplicationGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupIdSuffix":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupIdSuffix()));
        case "GlobalReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupDescription()));
        case "PrimaryReplicationGroupId":
            return Optional.ofNullable(clazz.cast(primaryReplicationGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalReplicationGroupIdSuffix", GLOBAL_REPLICATION_GROUP_ID_SUFFIX_FIELD);
        map.put("GlobalReplicationGroupDescription", GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD);
        map.put("PrimaryReplicationGroupId", PRIMARY_REPLICATION_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global
         * datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID
         * created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix,
         * combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple
         * regions.
         * </p>
         * <p>
         * For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Redis-Global-Datastores-CLI.html">Using the
         * Amazon CLI with Global datastores </a>.
         * </p>
         * 
         * @param globalReplicationGroupIdSuffix
         *        The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global
         *        datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global
         *        datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you
         *        provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global
         *        datastore name across multiple regions. </p>
         *        <p>
         *        For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a
         *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/Redis-Global-Datastores-CLI.html">Using
         *        the Amazon CLI with Global datastores </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupIdSuffix(String globalReplicationGroupIdSuffix);

        /**
         * <p>
         * Provides details of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupDescription
         *        Provides details of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupDescription(String globalReplicationGroupDescription);

        /**
         * <p>
         * The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
         * </p>
         * 
         * @param primaryReplicationGroupId
         *        The name of the primary cluster that accepts writes and will replicate updates to the secondary
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryReplicationGroupId(String primaryReplicationGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupIdSuffix;

        private String globalReplicationGroupDescription;

        private String primaryReplicationGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupIdSuffix(model.globalReplicationGroupIdSuffix);
            globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            primaryReplicationGroupId(model.primaryReplicationGroupId);
        }

        public final String getGlobalReplicationGroupIdSuffix() {
            return globalReplicationGroupIdSuffix;
        }

        public final void setGlobalReplicationGroupIdSuffix(String globalReplicationGroupIdSuffix) {
            this.globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix;
        }

        @Override
        public final Builder globalReplicationGroupIdSuffix(String globalReplicationGroupIdSuffix) {
            this.globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix;
            return this;
        }

        public final String getGlobalReplicationGroupDescription() {
            return globalReplicationGroupDescription;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final String getPrimaryReplicationGroupId() {
            return primaryReplicationGroupId;
        }

        public final void setPrimaryReplicationGroupId(String primaryReplicationGroupId) {
            this.primaryReplicationGroupId = primaryReplicationGroupId;
        }

        @Override
        public final Builder primaryReplicationGroupId(String primaryReplicationGroupId) {
            this.primaryReplicationGroupId = primaryReplicationGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalReplicationGroupRequest build() {
            return new CreateGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
