/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGlobalReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DeleteGlobalReplicationGroupRequest.Builder, DeleteGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId").getter(getter(DeleteGlobalReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Boolean> RETAIN_PRIMARY_REPLICATION_GROUP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainPrimaryReplicationGroup")
            .getter(getter(DeleteGlobalReplicationGroupRequest::retainPrimaryReplicationGroup))
            .setter(setter(Builder::retainPrimaryReplicationGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainPrimaryReplicationGroup")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, RETAIN_PRIMARY_REPLICATION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalReplicationGroupId;

    private final Boolean retainPrimaryReplicationGroup;

    private DeleteGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.retainPrimaryReplicationGroup = builder.retainPrimaryReplicationGroup;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The primary replication group is retained as a standalone replication group.
     * </p>
     * 
     * @return The primary replication group is retained as a standalone replication group.
     */
    public final Boolean retainPrimaryReplicationGroup() {
        return retainPrimaryReplicationGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(retainPrimaryReplicationGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGlobalReplicationGroupRequest)) {
            return false;
        }
        DeleteGlobalReplicationGroupRequest other = (DeleteGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(retainPrimaryReplicationGroup(), other.retainPrimaryReplicationGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId())
                .add("RetainPrimaryReplicationGroup", retainPrimaryReplicationGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "RetainPrimaryReplicationGroup":
            return Optional.ofNullable(clazz.cast(retainPrimaryReplicationGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("RetainPrimaryReplicationGroup", RETAIN_PRIMARY_REPLICATION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((DeleteGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The primary replication group is retained as a standalone replication group.
         * </p>
         * 
         * @param retainPrimaryReplicationGroup
         *        The primary replication group is retained as a standalone replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainPrimaryReplicationGroup(Boolean retainPrimaryReplicationGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Boolean retainPrimaryReplicationGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            retainPrimaryReplicationGroup(model.retainPrimaryReplicationGroup);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final Boolean getRetainPrimaryReplicationGroup() {
            return retainPrimaryReplicationGroup;
        }

        public final void setRetainPrimaryReplicationGroup(Boolean retainPrimaryReplicationGroup) {
            this.retainPrimaryReplicationGroup = retainPrimaryReplicationGroup;
        }

        @Override
        public final Builder retainPrimaryReplicationGroup(Boolean retainPrimaryReplicationGroup) {
            this.retainPrimaryReplicationGroup = retainPrimaryReplicationGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGlobalReplicationGroupRequest build() {
            return new DeleteGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
