/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(DescribeSnapshotsRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(DescribeSnapshotsRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(DescribeSnapshotsRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> SNAPSHOT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotSource").getter(getter(DescribeSnapshotsRequest::snapshotSource))
            .setter(setter(Builder::snapshotSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSource").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeSnapshotsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeSnapshotsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<Boolean> SHOW_NODE_GROUP_CONFIG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowNodeGroupConfig").getter(getter(DescribeSnapshotsRequest::showNodeGroupConfig))
            .setter(setter(Builder::showNodeGroupConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowNodeGroupConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            CACHE_CLUSTER_ID_FIELD, SNAPSHOT_NAME_FIELD, SNAPSHOT_SOURCE_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD,
            SHOW_NODE_GROUP_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationGroupId;

    private final String cacheClusterId;

    private final String snapshotName;

    private final String snapshotSource;

    private final String marker;

    private final Integer maxRecords;

    private final Boolean showNodeGroupConfig;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotName = builder.snapshotName;
        this.snapshotSource = builder.snapshotSource;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.showNodeGroupConfig = builder.showNodeGroupConfig;
    }

    /**
     * <p>
     * A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that
     * specific replication group are described.
     * </p>
     * 
     * @return A user-supplied replication group identifier. If this parameter is specified, only snapshots associated
     *         with that specific replication group are described.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific
     * cluster are described.
     * </p>
     * 
     * @return A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that
     *         specific cluster are described.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.
     * </p>
     * 
     * @return A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set
     * to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both
     * automatically and manually created snapshots.
     * </p>
     * 
     * @return If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache.
     *         If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output
     *         shows both automatically and manually created snapshots.
     */
    public final String snapshotSource() {
        return snapshotSource;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * <p>
     * Default: 50
     * </p>
     * <p>
     * Constraints: minimum 20; maximum 50.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     *         retrieved.</p>
     *         <p>
     *         Default: 50
     *         </p>
     *         <p>
     *         Constraints: minimum 20; maximum 50.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.
     * </p>
     * 
     * @return A Boolean value which if true, the node group (shard) configuration is included in the snapshot
     *         description.
     */
    public final Boolean showNodeGroupConfig() {
        return showNodeGroupConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotSource());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(showNodeGroupConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(snapshotSource(), other.snapshotSource()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(showNodeGroupConfig(), other.showNodeGroupConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("ReplicationGroupId", replicationGroupId())
                .add("CacheClusterId", cacheClusterId()).add("SnapshotName", snapshotName())
                .add("SnapshotSource", snapshotSource()).add("Marker", marker()).add("MaxRecords", maxRecords())
                .add("ShowNodeGroupConfig", showNodeGroupConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "SnapshotSource":
            return Optional.ofNullable(clazz.cast(snapshotSource()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "ShowNodeGroupConfig":
            return Optional.ofNullable(clazz.cast(showNodeGroupConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
        map.put("SnapshotName", SNAPSHOT_NAME_FIELD);
        map.put("SnapshotSource", SNAPSHOT_SOURCE_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("ShowNodeGroupConfig", SHOW_NODE_GROUP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with
         * that specific replication group are described.
         * </p>
         * 
         * @param replicationGroupId
         *        A user-supplied replication group identifier. If this parameter is specified, only snapshots
         *        associated with that specific replication group are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that
         * specific cluster are described.
         * </p>
         * 
         * @param cacheClusterId
         *        A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with
         *        that specific cluster are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.
         * </p>
         * 
         * @param snapshotName
         *        A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If
         * set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows
         * both automatically and manually created snapshots.
         * </p>
         * 
         * @param snapshotSource
         *        If set to <code>system</code>, the output shows snapshots that were automatically created by
         *        ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If
         *        omitted, the output shows both automatically and manually created snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSource(String snapshotSource);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * <p>
         * Default: 50
         * </p>
         * <p>
         * Constraints: minimum 20; maximum 50.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can
         *        be retrieved.</p>
         *        <p>
         *        Default: 50
         *        </p>
         *        <p>
         *        Constraints: minimum 20; maximum 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.
         * </p>
         * 
         * @param showNodeGroupConfig
         *        A Boolean value which if true, the node group (shard) configuration is included in the snapshot
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showNodeGroupConfig(Boolean showNodeGroupConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private String cacheClusterId;

        private String snapshotName;

        private String snapshotSource;

        private String marker;

        private Integer maxRecords;

        private Boolean showNodeGroupConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            cacheClusterId(model.cacheClusterId);
            snapshotName(model.snapshotName);
            snapshotSource(model.snapshotSource);
            marker(model.marker);
            maxRecords(model.maxRecords);
            showNodeGroupConfig(model.showNodeGroupConfig);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSnapshotSource() {
            return snapshotSource;
        }

        public final void setSnapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
        }

        @Override
        public final Builder snapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final Boolean getShowNodeGroupConfig() {
            return showNodeGroupConfig;
        }

        public final void setShowNodeGroupConfig(Boolean showNodeGroupConfig) {
            this.showNodeGroupConfig = showNodeGroupConfig;
        }

        @Override
        public final Builder showNodeGroupConfig(Boolean showNodeGroupConfig) {
            this.showNodeGroupConfig = showNodeGroupConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
