/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different
 * Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the
 * secondary cluster.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to
 * associate a secondary cluster.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalReplicationGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalReplicationGroup.Builder, GlobalReplicationGroup> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId").getter(getter(GlobalReplicationGroup::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupDescription")
            .getter(getter(GlobalReplicationGroup::globalReplicationGroupDescription))
            .setter(setter(Builder::globalReplicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GlobalReplicationGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(GlobalReplicationGroup::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(GlobalReplicationGroup::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(GlobalReplicationGroup::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<List<GlobalReplicationGroupMember>> MEMBERS_FIELD = SdkField
            .<List<GlobalReplicationGroupMember>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(GlobalReplicationGroup::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalReplicationGroupMember")
                            .memberFieldInfo(
                                    SdkField.<GlobalReplicationGroupMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalReplicationGroupMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalReplicationGroupMember").build()).build()).build())
            .build();

    private static final SdkField<Boolean> CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClusterEnabled").getter(getter(GlobalReplicationGroup::clusterEnabled))
            .setter(setter(Builder::clusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEnabled").build()).build();

    private static final SdkField<List<GlobalNodeGroup>> GLOBAL_NODE_GROUPS_FIELD = SdkField
            .<List<GlobalNodeGroup>> builder(MarshallingType.LIST)
            .memberName("GlobalNodeGroups")
            .getter(getter(GlobalReplicationGroup::globalNodeGroups))
            .setter(setter(Builder::globalNodeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalNodeGroup")
                            .memberFieldInfo(
                                    SdkField.<GlobalNodeGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalNodeGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalNodeGroup").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuthTokenEnabled").getter(getter(GlobalReplicationGroup::authTokenEnabled))
            .setter(setter(Builder::authTokenEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(GlobalReplicationGroup::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AtRestEncryptionEnabled").getter(getter(GlobalReplicationGroup::atRestEncryptionEnabled))
            .setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(GlobalReplicationGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD, STATUS_FIELD, CACHE_NODE_TYPE_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, MEMBERS_FIELD, CLUSTER_ENABLED_FIELD, GLOBAL_NODE_GROUPS_FIELD,
            AUTH_TOKEN_ENABLED_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String globalReplicationGroupId;

    private final String globalReplicationGroupDescription;

    private final String status;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final List<GlobalReplicationGroupMember> members;

    private final Boolean clusterEnabled;

    private final List<GlobalNodeGroup> globalNodeGroups;

    private final Boolean authTokenEnabled;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String arn;

    private GlobalReplicationGroup(BuilderImpl builder) {
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.status = builder.status;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.members = builder.members;
        this.clusterEnabled = builder.clusterEnabled;
        this.globalNodeGroups = builder.globalNodeGroups;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The optional description of the Global datastore
     * </p>
     * 
     * @return The optional description of the Global datastore
     */
    public final String globalReplicationGroupDescription() {
        return globalReplicationGroupDescription;
    }

    /**
     * <p>
     * The status of the Global datastore
     * </p>
     * 
     * @return The status of the Global datastore
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The cache node type of the Global datastore
     * </p>
     * 
     * @return The cache node type of the Global datastore
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The ElastiCache engine. For Valkey or Redis OSS only.
     * </p>
     * 
     * @return The ElastiCache engine. For Valkey or Redis OSS only.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The ElastiCache engine version.
     * </p>
     * 
     * @return The ElastiCache engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication groups that comprise the Global datastore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return The replication groups that comprise the Global datastore.
     */
    public final List<GlobalReplicationGroupMember> members() {
        return members;
    }

    /**
     * <p>
     * A flag that indicates whether the Global datastore is cluster enabled.
     * </p>
     * 
     * @return A flag that indicates whether the Global datastore is cluster enabled.
     */
    public final Boolean clusterEnabled() {
        return clusterEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalNodeGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlobalNodeGroups() {
        return globalNodeGroups != null && !(globalNodeGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the slot configuration and global identifier for each slice group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalNodeGroups} method.
     * </p>
     * 
     * @return Indicates the slot configuration and global identifier for each slice group.
     */
    public final List<GlobalNodeGroup> globalNodeGroups() {
        return globalNodeGroups;
    }

    /**
     * <p>
     * A flag that enables using an <code>AuthToken</code> (password) when issuing Valkey or Redis OSS commands.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables using an <code>AuthToken</code> (password) when issuing Valkey or Redis OSS
     *         commands.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean authTokenEnabled() {
        return authTokenEnabled;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to true.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to true.</p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * 
     * @return A flag that enables encryption at rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *         created. To enable encryption at rest on a replication group you must set
     *         <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     */
    public final Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the global replication group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the global replication group.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalNodeGroups() ? globalNodeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalReplicationGroup)) {
            return false;
        }
        GlobalReplicationGroup other = (GlobalReplicationGroup) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(globalReplicationGroupDescription(), other.globalReplicationGroupDescription())
                && Objects.equals(status(), other.status()) && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && Objects.equals(clusterEnabled(), other.clusterEnabled())
                && hasGlobalNodeGroups() == other.hasGlobalNodeGroups()
                && Objects.equals(globalNodeGroups(), other.globalNodeGroups())
                && Objects.equals(authTokenEnabled(), other.authTokenEnabled())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalReplicationGroup").add("GlobalReplicationGroupId", globalReplicationGroupId())
                .add("GlobalReplicationGroupDescription", globalReplicationGroupDescription()).add("Status", status())
                .add("CacheNodeType", cacheNodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("Members", hasMembers() ? members() : null).add("ClusterEnabled", clusterEnabled())
                .add("GlobalNodeGroups", hasGlobalNodeGroups() ? globalNodeGroups() : null)
                .add("AuthTokenEnabled", authTokenEnabled()).add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "GlobalReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupDescription()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "ClusterEnabled":
            return Optional.ofNullable(clazz.cast(clusterEnabled()));
        case "GlobalNodeGroups":
            return Optional.ofNullable(clazz.cast(globalNodeGroups()));
        case "AuthTokenEnabled":
            return Optional.ofNullable(clazz.cast(authTokenEnabled()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("GlobalReplicationGroupDescription", GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("Members", MEMBERS_FIELD);
        map.put("ClusterEnabled", CLUSTER_ENABLED_FIELD);
        map.put("GlobalNodeGroups", GLOBAL_NODE_GROUPS_FIELD);
        map.put("AuthTokenEnabled", AUTH_TOKEN_ENABLED_FIELD);
        map.put("TransitEncryptionEnabled", TRANSIT_ENCRYPTION_ENABLED_FIELD);
        map.put("AtRestEncryptionEnabled", AT_REST_ENCRYPTION_ENABLED_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalReplicationGroup, T> g) {
        return obj -> g.apply((GlobalReplicationGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalReplicationGroup> {
        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The optional description of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupDescription
         *        The optional description of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupDescription(String globalReplicationGroupDescription);

        /**
         * <p>
         * The status of the Global datastore
         * </p>
         * 
         * @param status
         *        The status of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The cache node type of the Global datastore
         * </p>
         * 
         * @param cacheNodeType
         *        The cache node type of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The ElastiCache engine. For Valkey or Redis OSS only.
         * </p>
         * 
         * @param engine
         *        The ElastiCache engine. For Valkey or Redis OSS only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The ElastiCache engine version.
         * </p>
         * 
         * @param engineVersion
         *        The ElastiCache engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The replication groups that comprise the Global datastore.
         * </p>
         * 
         * @param members
         *        The replication groups that comprise the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<GlobalReplicationGroupMember> members);

        /**
         * <p>
         * The replication groups that comprise the Global datastore.
         * </p>
         * 
         * @param members
         *        The replication groups that comprise the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(GlobalReplicationGroupMember... members);

        /**
         * <p>
         * The replication groups that comprise the Global datastore.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember.Builder#build()} is
         * called immediately and its result is passed to {@link #members(List<GlobalReplicationGroupMember>)}.
         * 
         * @param members
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(java.util.Collection<GlobalReplicationGroupMember>)
         */
        Builder members(Consumer<GlobalReplicationGroupMember.Builder>... members);

        /**
         * <p>
         * A flag that indicates whether the Global datastore is cluster enabled.
         * </p>
         * 
         * @param clusterEnabled
         *        A flag that indicates whether the Global datastore is cluster enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEnabled(Boolean clusterEnabled);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * 
         * @param globalNodeGroups
         *        Indicates the slot configuration and global identifier for each slice group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroups(Collection<GlobalNodeGroup> globalNodeGroups);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * 
         * @param globalNodeGroups
         *        Indicates the slot configuration and global identifier for each slice group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroups(GlobalNodeGroup... globalNodeGroups);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #globalNodeGroups(List<GlobalNodeGroup>)}.
         * 
         * @param globalNodeGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalNodeGroups(java.util.Collection<GlobalNodeGroup>)
         */
        Builder globalNodeGroups(Consumer<GlobalNodeGroup.Builder>... globalNodeGroups);

        /**
         * <p>
         * A flag that enables using an <code>AuthToken</code> (password) when issuing Valkey or Redis OSS commands.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param authTokenEnabled
         *        A flag that enables using an <code>AuthToken</code> (password) when issuing Valkey or Redis OSS
         *        commands.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenEnabled(Boolean authTokenEnabled);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to true.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to true.</p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created.
         * To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
         * <code>true</code> when you create the replication group.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
         *        created. To enable encryption at rest on a replication group you must set
         *        <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the global replication group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the global replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private String globalReplicationGroupDescription;

        private String status;

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private List<GlobalReplicationGroupMember> members = DefaultSdkAutoConstructList.getInstance();

        private Boolean clusterEnabled;

        private List<GlobalNodeGroup> globalNodeGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean authTokenEnabled;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalReplicationGroup model) {
            globalReplicationGroupId(model.globalReplicationGroupId);
            globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            status(model.status);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            members(model.members);
            clusterEnabled(model.clusterEnabled);
            globalNodeGroups(model.globalNodeGroups);
            authTokenEnabled(model.authTokenEnabled);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            arn(model.arn);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final String getGlobalReplicationGroupDescription() {
            return globalReplicationGroupDescription;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final List<GlobalReplicationGroupMember.Builder> getMembers() {
            List<GlobalReplicationGroupMember.Builder> result = GlobalReplicationGroupMemberListCopier
                    .copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<GlobalReplicationGroupMember.BuilderImpl> members) {
            this.members = GlobalReplicationGroupMemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<GlobalReplicationGroupMember> members) {
            this.members = GlobalReplicationGroupMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(GlobalReplicationGroupMember... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<GlobalReplicationGroupMember.Builder>... members) {
            members(Stream.of(members).map(c -> GlobalReplicationGroupMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getClusterEnabled() {
            return clusterEnabled;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final List<GlobalNodeGroup.Builder> getGlobalNodeGroups() {
            List<GlobalNodeGroup.Builder> result = GlobalNodeGroupListCopier.copyToBuilder(this.globalNodeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalNodeGroups(Collection<GlobalNodeGroup.BuilderImpl> globalNodeGroups) {
            this.globalNodeGroups = GlobalNodeGroupListCopier.copyFromBuilder(globalNodeGroups);
        }

        @Override
        public final Builder globalNodeGroups(Collection<GlobalNodeGroup> globalNodeGroups) {
            this.globalNodeGroups = GlobalNodeGroupListCopier.copy(globalNodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroups(GlobalNodeGroup... globalNodeGroups) {
            globalNodeGroups(Arrays.asList(globalNodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroups(Consumer<GlobalNodeGroup.Builder>... globalNodeGroups) {
            globalNodeGroups(Stream.of(globalNodeGroups).map(c -> GlobalNodeGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAuthTokenEnabled() {
            return authTokenEnabled;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GlobalReplicationGroup build() {
            return new GlobalReplicationGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
