/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of settings that are applied to the cluster in the future, or that are currently being applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedValues.Builder, PendingModifiedValues> {
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumCacheNodes").getter(getter(PendingModifiedValues::numCacheNodes))
            .setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheNodeIdsToRemove")
            .getter(getter(PendingModifiedValues::cacheNodeIdsToRemove))
            .setter(setter(Builder::cacheNodeIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeId").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(PendingModifiedValues::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(PendingModifiedValues::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthTokenStatus").getter(getter(PendingModifiedValues::authTokenStatusAsString))
            .setter(setter(Builder::authTokenStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()).build();

    private static final SdkField<List<PendingLogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<PendingLogDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(PendingModifiedValues::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingLogDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingLogDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(PendingModifiedValues::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryptionMode").getter(getter(PendingModifiedValues::transitEncryptionModeAsString))
            .setter(setter(Builder::transitEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build())
            .build();

    private static final SdkField<ScaleConfig> SCALE_CONFIG_FIELD = SdkField.<ScaleConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ScaleConfig").getter(getter(PendingModifiedValues::scaleConfig)).setter(setter(Builder::scaleConfig))
            .constructor(ScaleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_CACHE_NODES_FIELD,
            CACHE_NODE_IDS_TO_REMOVE_FIELD, ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_STATUS_FIELD,
            LOG_DELIVERY_CONFIGURATIONS_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD,
            SCALE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numCacheNodes;

    private final List<String> cacheNodeIdsToRemove;

    private final String engineVersion;

    private final String cacheNodeType;

    private final String authTokenStatus;

    private final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations;

    private final Boolean transitEncryptionEnabled;

    private final String transitEncryptionMode;

    private final ScaleConfig scaleConfig;

    private PendingModifiedValues(BuilderImpl builder) {
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.engineVersion = builder.engineVersion;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenStatus = builder.authTokenStatus;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.scaleConfig = builder.scaleConfig;
    }

    /**
     * <p>
     * The new number of cache nodes for the cluster.
     * </p>
     * <p>
     * For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this value must
     * be between 1 and 40.
     * </p>
     * 
     * @return The new number of cache nodes for the cluster.</p>
     *         <p>
     *         For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this
     *         value must be between 1 and 40.
     */
    public final Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheNodeIdsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove != null && !(cacheNodeIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
     * numeric identifier (0001, 0002, etc.).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheNodeIdsToRemove} method.
     * </p>
     * 
     * @return A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
     *         4-digit numeric identifier (0001, 0002, etc.).
     */
    public final List<String> cacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove;
    }

    /**
     * <p>
     * The new cache engine version that the cluster runs.
     * </p>
     * 
     * @return The new cache engine version that the cluster runs.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The cache node type that this cluster or replication group is scaled to.
     * </p>
     * 
     * @return The cache node type that this cluster or replication group is scaled to.
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public final AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(authTokenStatus);
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public final String authTokenStatusAsString() {
        return authTokenStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log delivery configurations being modified
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return The log delivery configurations being modified
     */
    public final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to true.
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to true.
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(transitEncryptionMode);
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final String transitEncryptionModeAsString() {
        return transitEncryptionMode;
    }

    /**
     * <p>
     * The scaling configuration changes that are pending for the Memcached cluster.
     * </p>
     * 
     * @return The scaling configuration changes that are pending for the Memcached cluster.
     */
    public final ScaleConfig scaleConfig() {
        return scaleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheNodeIdsToRemove() ? cacheNodeIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scaleConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues) obj;
        return Objects.equals(numCacheNodes(), other.numCacheNodes())
                && hasCacheNodeIdsToRemove() == other.hasCacheNodeIdsToRemove()
                && Objects.equals(cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(authTokenStatusAsString(), other.authTokenStatusAsString())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(transitEncryptionModeAsString(), other.transitEncryptionModeAsString())
                && Objects.equals(scaleConfig(), other.scaleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingModifiedValues").add("NumCacheNodes", numCacheNodes())
                .add("CacheNodeIdsToRemove", hasCacheNodeIdsToRemove() ? cacheNodeIdsToRemove() : null)
                .add("EngineVersion", engineVersion()).add("CacheNodeType", cacheNodeType())
                .add("AuthTokenStatus", authTokenStatusAsString())
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("TransitEncryptionMode", transitEncryptionModeAsString()).add("ScaleConfig", scaleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "CacheNodeIdsToRemove":
            return Optional.ofNullable(clazz.cast(cacheNodeIdsToRemove()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthTokenStatus":
            return Optional.ofNullable(clazz.cast(authTokenStatusAsString()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "TransitEncryptionMode":
            return Optional.ofNullable(clazz.cast(transitEncryptionModeAsString()));
        case "ScaleConfig":
            return Optional.ofNullable(clazz.cast(scaleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumCacheNodes", NUM_CACHE_NODES_FIELD);
        map.put("CacheNodeIdsToRemove", CACHE_NODE_IDS_TO_REMOVE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("AuthTokenStatus", AUTH_TOKEN_STATUS_FIELD);
        map.put("LogDeliveryConfigurations", LOG_DELIVERY_CONFIGURATIONS_FIELD);
        map.put("TransitEncryptionEnabled", TRANSIT_ENCRYPTION_ENABLED_FIELD);
        map.put("TransitEncryptionMode", TRANSIT_ENCRYPTION_MODE_FIELD);
        map.put("ScaleConfig", SCALE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedValues> {
        /**
         * <p>
         * The new number of cache nodes for the cluster.
         * </p>
         * <p>
         * For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this value
         * must be between 1 and 40.
         * </p>
         * 
         * @param numCacheNodes
         *        The new number of cache nodes for the cluster.</p>
         *        <p>
         *        For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this
         *        value must be between 1 and 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
         *        4-digit numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove);

        /**
         * <p>
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
         *        4-digit numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove);

        /**
         * <p>
         * The new cache engine version that the cluster runs.
         * </p>
         * 
         * @param engineVersion
         *        The new cache engine version that the cluster runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The cache node type that this cluster or replication group is scaled to.
         * </p>
         * 
         * @param cacheNodeType
         *        The cache node type that this cluster or replication group is scaled to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(String authTokenStatus);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus);

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        The log delivery configurations being modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations);

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        The log delivery configurations being modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration... logDeliveryConfigurations);

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<PendingLogDeliveryConfiguration>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<PendingLogDeliveryConfiguration>)
         */
        Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to true.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(String transitEncryptionMode);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode);

        /**
         * <p>
         * The scaling configuration changes that are pending for the Memcached cluster.
         * </p>
         * 
         * @param scaleConfig
         *        The scaling configuration changes that are pending for the Memcached cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleConfig(ScaleConfig scaleConfig);

        /**
         * <p>
         * The scaling configuration changes that are pending for the Memcached cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScaleConfig.Builder} avoiding the need to
         * create one manually via {@link ScaleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScaleConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #scaleConfig(ScaleConfig)}.
         * 
         * @param scaleConfig
         *        a consumer that will call methods on {@link ScaleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleConfig(ScaleConfig)
         */
        default Builder scaleConfig(Consumer<ScaleConfig.Builder> scaleConfig) {
            return scaleConfig(ScaleConfig.builder().applyMutation(scaleConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer numCacheNodes;

        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private String engineVersion;

        private String cacheNodeType;

        private String authTokenStatus;

        private List<PendingLogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean transitEncryptionEnabled;

        private String transitEncryptionMode;

        private ScaleConfig scaleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            numCacheNodes(model.numCacheNodes);
            cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            engineVersion(model.engineVersion);
            cacheNodeType(model.cacheNodeType);
            authTokenStatus(model.authTokenStatus);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            transitEncryptionMode(model.transitEncryptionMode);
            scaleConfig(model.scaleConfig);
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            if (cacheNodeIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheNodeIdsToRemove;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove) {
            cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getAuthTokenStatus() {
            return authTokenStatus;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final List<PendingLogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<PendingLogDeliveryConfiguration.Builder> result = PendingLogDeliveryConfigurationListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<PendingLogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<PendingLogDeliveryConfiguration.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> PendingLogDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final String getTransitEncryptionMode() {
            return transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final ScaleConfig.Builder getScaleConfig() {
            return scaleConfig != null ? scaleConfig.toBuilder() : null;
        }

        public final void setScaleConfig(ScaleConfig.BuilderImpl scaleConfig) {
            this.scaleConfig = scaleConfig != null ? scaleConfig.build() : null;
        }

        @Override
        public final Builder scaleConfig(ScaleConfig scaleConfig) {
            this.scaleConfig = scaleConfig;
            return this;
        }

        @Override
        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
