/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the replication groups
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RegionalConfiguration.Builder, RegionalConfiguration> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(RegionalConfiguration::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupRegion").getter(getter(RegionalConfiguration::replicationGroupRegion))
            .setter(setter(Builder::replicationGroupRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupRegion").build())
            .build();

    private static final SdkField<List<ReshardingConfiguration>> RESHARDING_CONFIGURATION_FIELD = SdkField
            .<List<ReshardingConfiguration>> builder(MarshallingType.LIST)
            .memberName("ReshardingConfiguration")
            .getter(getter(RegionalConfiguration::reshardingConfiguration))
            .setter(setter(Builder::reshardingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReshardingConfiguration")
                            .memberFieldInfo(
                                    SdkField.<ReshardingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReshardingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReshardingConfiguration").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_REGION_FIELD, RESHARDING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicationGroupId;

    private final String replicationGroupRegion;

    private final List<ReshardingConfiguration> reshardingConfiguration;

    private RegionalConfiguration(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupRegion = builder.replicationGroupRegion;
        this.reshardingConfiguration = builder.reshardingConfiguration;
    }

    /**
     * <p>
     * The name of the secondary cluster
     * </p>
     * 
     * @return The name of the secondary cluster
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The Amazon region where the cluster is stored
     * </p>
     * 
     * @return The Amazon region where the cluster is stored
     */
    public final String replicationGroupRegion() {
        return replicationGroupRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReshardingConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReshardingConfiguration() {
        return reshardingConfiguration != null && !(reshardingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the
     * resharded cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReshardingConfiguration} method.
     * </p>
     * 
     * @return A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node
     *         group in the resharded cluster.
     */
    public final List<ReshardingConfiguration> reshardingConfiguration() {
        return reshardingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasReshardingConfiguration() ? reshardingConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalConfiguration)) {
            return false;
        }
        RegionalConfiguration other = (RegionalConfiguration) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupRegion(), other.replicationGroupRegion())
                && hasReshardingConfiguration() == other.hasReshardingConfiguration()
                && Objects.equals(reshardingConfiguration(), other.reshardingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionalConfiguration").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupRegion", replicationGroupRegion())
                .add("ReshardingConfiguration", hasReshardingConfiguration() ? reshardingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupRegion":
            return Optional.ofNullable(clazz.cast(replicationGroupRegion()));
        case "ReshardingConfiguration":
            return Optional.ofNullable(clazz.cast(reshardingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("ReplicationGroupRegion", REPLICATION_GROUP_REGION_FIELD);
        map.put("ReshardingConfiguration", RESHARDING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionalConfiguration, T> g) {
        return obj -> g.apply((RegionalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionalConfiguration> {
        /**
         * <p>
         * The name of the secondary cluster
         * </p>
         * 
         * @param replicationGroupId
         *        The name of the secondary cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The Amazon region where the cluster is stored
         * </p>
         * 
         * @param replicationGroupRegion
         *        The Amazon region where the cluster is stored
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupRegion(String replicationGroupRegion);

        /**
         * <p>
         * A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in
         * the resharded cluster.
         * </p>
         * 
         * @param reshardingConfiguration
         *        A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node
         *        group in the resharded cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration);

        /**
         * <p>
         * A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in
         * the resharded cluster.
         * </p>
         * 
         * @param reshardingConfiguration
         *        A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node
         *        group in the resharded cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reshardingConfiguration(ReshardingConfiguration... reshardingConfiguration);

        /**
         * <p>
         * A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in
         * the resharded cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #reshardingConfiguration(List<ReshardingConfiguration>)}.
         * 
         * @param reshardingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reshardingConfiguration(java.util.Collection<ReshardingConfiguration>)
         */
        Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder>... reshardingConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupRegion;

        private List<ReshardingConfiguration> reshardingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalConfiguration model) {
            replicationGroupId(model.replicationGroupId);
            replicationGroupRegion(model.replicationGroupRegion);
            reshardingConfiguration(model.reshardingConfiguration);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupRegion() {
            return replicationGroupRegion;
        }

        public final void setReplicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
        }

        @Override
        public final Builder replicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
            return this;
        }

        public final List<ReshardingConfiguration.Builder> getReshardingConfiguration() {
            List<ReshardingConfiguration.Builder> result = ReshardingConfigurationListCopier
                    .copyToBuilder(this.reshardingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReshardingConfiguration(Collection<ReshardingConfiguration.BuilderImpl> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copyFromBuilder(reshardingConfiguration);
        }

        @Override
        public final Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copy(reshardingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reshardingConfiguration(ReshardingConfiguration... reshardingConfiguration) {
            reshardingConfiguration(Arrays.asList(reshardingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder>... reshardingConfiguration) {
            reshardingConfiguration(Stream.of(reshardingConfiguration)
                    .map(c -> ReshardingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegionalConfiguration build() {
            return new RegionalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
