/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CPU utilization metrics for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CPUUtilization implements SdkPojo, Serializable, ToCopyableBuilder<CPUUtilization.Builder, CPUUtilization> {
    private static final SdkField<Double> USER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<Double> NICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::nice)).setter(setter(Builder::nice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nice").build()).build();

    private static final SdkField<Double> SYSTEM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::system)).setter(setter(Builder::system))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("System").build()).build();

    private static final SdkField<Double> IDLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::idle)).setter(setter(Builder::idle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Idle").build()).build();

    private static final SdkField<Double> IO_WAIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::ioWait)).setter(setter(Builder::ioWait))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOWait").build()).build();

    private static final SdkField<Double> IRQ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::irq)).setter(setter(Builder::irq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IRQ").build()).build();

    private static final SdkField<Double> SOFT_IRQ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::softIRQ)).setter(setter(Builder::softIRQ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftIRQ").build()).build();

    private static final SdkField<Double> PRIVILEGED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CPUUtilization::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, NICE_FIELD,
            SYSTEM_FIELD, IDLE_FIELD, IO_WAIT_FIELD, IRQ_FIELD, SOFT_IRQ_FIELD, PRIVILEGED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double user;

    private final Double nice;

    private final Double system;

    private final Double idle;

    private final Double ioWait;

    private final Double irq;

    private final Double softIRQ;

    private final Double privileged;

    private CPUUtilization(BuilderImpl builder) {
        this.user = builder.user;
        this.nice = builder.nice;
        this.system = builder.system;
        this.idle = builder.idle;
        this.ioWait = builder.ioWait;
        this.irq = builder.irq;
        this.softIRQ = builder.softIRQ;
        this.privileged = builder.privileged;
    }

    /**
     * <p>
     * Percentage of time that the CPU has spent in the <code>User</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Percentage of time that the CPU has spent in the <code>User</code> state over the last 10 seconds.
     */
    public Double user() {
        return user;
    }

    /**
     * <p>
     * Available on Linux environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>Nice</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Linux environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>Nice</code> state over the last 10 seconds.
     */
    public Double nice() {
        return nice;
    }

    /**
     * <p>
     * Available on Linux environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>System</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Linux environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>System</code> state over the last 10 seconds.
     */
    public Double system() {
        return system;
    }

    /**
     * <p>
     * Percentage of time that the CPU has spent in the <code>Idle</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Percentage of time that the CPU has spent in the <code>Idle</code> state over the last 10 seconds.
     */
    public Double idle() {
        return idle;
    }

    /**
     * <p>
     * Available on Linux environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Linux environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the last 10 seconds.
     */
    public Double ioWait() {
        return ioWait;
    }

    /**
     * <p>
     * Available on Linux environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Linux environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last 10 seconds.
     */
    public Double irq() {
        return irq;
    }

    /**
     * <p>
     * Available on Linux environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Linux environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the last 10 seconds.
     */
    public Double softIRQ() {
        return softIRQ;
    }

    /**
     * <p>
     * Available on Windows environments only.
     * </p>
     * <p>
     * Percentage of time that the CPU has spent in the <code>Privileged</code> state over the last 10 seconds.
     * </p>
     * 
     * @return Available on Windows environments only.</p>
     *         <p>
     *         Percentage of time that the CPU has spent in the <code>Privileged</code> state over the last 10 seconds.
     */
    public Double privileged() {
        return privileged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(nice());
        hashCode = 31 * hashCode + Objects.hashCode(system());
        hashCode = 31 * hashCode + Objects.hashCode(idle());
        hashCode = 31 * hashCode + Objects.hashCode(ioWait());
        hashCode = 31 * hashCode + Objects.hashCode(irq());
        hashCode = 31 * hashCode + Objects.hashCode(softIRQ());
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPUUtilization)) {
            return false;
        }
        CPUUtilization other = (CPUUtilization) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(nice(), other.nice())
                && Objects.equals(system(), other.system()) && Objects.equals(idle(), other.idle())
                && Objects.equals(ioWait(), other.ioWait()) && Objects.equals(irq(), other.irq())
                && Objects.equals(softIRQ(), other.softIRQ()) && Objects.equals(privileged(), other.privileged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CPUUtilization").add("User", user()).add("Nice", nice()).add("System", system())
                .add("Idle", idle()).add("IOWait", ioWait()).add("IRQ", irq()).add("SoftIRQ", softIRQ())
                .add("Privileged", privileged()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Nice":
            return Optional.ofNullable(clazz.cast(nice()));
        case "System":
            return Optional.ofNullable(clazz.cast(system()));
        case "Idle":
            return Optional.ofNullable(clazz.cast(idle()));
        case "IOWait":
            return Optional.ofNullable(clazz.cast(ioWait()));
        case "IRQ":
            return Optional.ofNullable(clazz.cast(irq()));
        case "SoftIRQ":
            return Optional.ofNullable(clazz.cast(softIRQ()));
        case "Privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CPUUtilization, T> g) {
        return obj -> g.apply((CPUUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CPUUtilization> {
        /**
         * <p>
         * Percentage of time that the CPU has spent in the <code>User</code> state over the last 10 seconds.
         * </p>
         * 
         * @param user
         *        Percentage of time that the CPU has spent in the <code>User</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(Double user);

        /**
         * <p>
         * Available on Linux environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>Nice</code> state over the last 10 seconds.
         * </p>
         * 
         * @param nice
         *        Available on Linux environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>Nice</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nice(Double nice);

        /**
         * <p>
         * Available on Linux environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>System</code> state over the last 10 seconds.
         * </p>
         * 
         * @param system
         *        Available on Linux environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>System</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(Double system);

        /**
         * <p>
         * Percentage of time that the CPU has spent in the <code>Idle</code> state over the last 10 seconds.
         * </p>
         * 
         * @param idle
         *        Percentage of time that the CPU has spent in the <code>Idle</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idle(Double idle);

        /**
         * <p>
         * Available on Linux environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the last 10 seconds.
         * </p>
         * 
         * @param ioWait
         *        Available on Linux environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>I/O Wait</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ioWait(Double ioWait);

        /**
         * <p>
         * Available on Linux environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last 10 seconds.
         * </p>
         * 
         * @param irq
         *        Available on Linux environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>IRQ</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder irq(Double irq);

        /**
         * <p>
         * Available on Linux environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the last 10 seconds.
         * </p>
         * 
         * @param softIRQ
         *        Available on Linux environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>SoftIRQ</code> state over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softIRQ(Double softIRQ);

        /**
         * <p>
         * Available on Windows environments only.
         * </p>
         * <p>
         * Percentage of time that the CPU has spent in the <code>Privileged</code> state over the last 10 seconds.
         * </p>
         * 
         * @param privileged
         *        Available on Windows environments only.</p>
         *        <p>
         *        Percentage of time that the CPU has spent in the <code>Privileged</code> state over the last 10
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Double privileged);
    }

    static final class BuilderImpl implements Builder {
        private Double user;

        private Double nice;

        private Double system;

        private Double idle;

        private Double ioWait;

        private Double irq;

        private Double softIRQ;

        private Double privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(CPUUtilization model) {
            user(model.user);
            nice(model.nice);
            system(model.system);
            idle(model.idle);
            ioWait(model.ioWait);
            irq(model.irq);
            softIRQ(model.softIRQ);
            privileged(model.privileged);
        }

        public final Double getUser() {
            return user;
        }

        @Override
        public final Builder user(Double user) {
            this.user = user;
            return this;
        }

        public final void setUser(Double user) {
            this.user = user;
        }

        public final Double getNice() {
            return nice;
        }

        @Override
        public final Builder nice(Double nice) {
            this.nice = nice;
            return this;
        }

        public final void setNice(Double nice) {
            this.nice = nice;
        }

        public final Double getSystem() {
            return system;
        }

        @Override
        public final Builder system(Double system) {
            this.system = system;
            return this;
        }

        public final void setSystem(Double system) {
            this.system = system;
        }

        public final Double getIdle() {
            return idle;
        }

        @Override
        public final Builder idle(Double idle) {
            this.idle = idle;
            return this;
        }

        public final void setIdle(Double idle) {
            this.idle = idle;
        }

        public final Double getIoWait() {
            return ioWait;
        }

        @Override
        public final Builder ioWait(Double ioWait) {
            this.ioWait = ioWait;
            return this;
        }

        public final void setIoWait(Double ioWait) {
            this.ioWait = ioWait;
        }

        public final Double getIrq() {
            return irq;
        }

        @Override
        public final Builder irq(Double irq) {
            this.irq = irq;
            return this;
        }

        public final void setIrq(Double irq) {
            this.irq = irq;
        }

        public final Double getSoftIRQ() {
            return softIRQ;
        }

        @Override
        public final Builder softIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
            return this;
        }

        public final void setSoftIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
        }

        public final Double getPrivileged() {
            return privileged;
        }

        @Override
        public final Builder privileged(Double privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Double privileged) {
            this.privileged = privileged;
        }

        @Override
        public CPUUtilization build() {
            return new CPUUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
