/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformVersionsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ListPlatformVersionsResponse.Builder, ListPlatformVersionsResponse> {
    private static final SdkField<List<PlatformSummary>> PLATFORM_SUMMARY_LIST_FIELD = SdkField
            .<List<PlatformSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListPlatformVersionsResponse::platformSummaryList))
            .setter(setter(Builder::platformSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPlatformVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PlatformSummary> platformSummaryList;

    private final String nextToken;

    private ListPlatformVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummaryList = builder.platformSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Detailed information about the platforms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Detailed information about the platforms.
     */
    public List<PlatformSummary> platformSummaryList() {
        return platformSummaryList;
    }

    /**
     * <p>
     * The starting index into the remaining list of platforms. if this value is not <code>null</code>, you can use it
     * in a subsequent <code>ListPlatformVersion</code> call.
     * </p>
     * 
     * @return The starting index into the remaining list of platforms. if this value is not <code>null</code>, you can
     *         use it in a subsequent <code>ListPlatformVersion</code> call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsResponse)) {
            return false;
        }
        ListPlatformVersionsResponse other = (ListPlatformVersionsResponse) obj;
        return Objects.equals(platformSummaryList(), other.platformSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPlatformVersionsResponse").add("PlatformSummaryList", platformSummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformSummaryList":
            return Optional.ofNullable(clazz.cast(platformSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformVersionsResponse, T> g) {
        return obj -> g.apply((ListPlatformVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformVersionsResponse> {
        /**
         * <p>
         * Detailed information about the platforms.
         * </p>
         * 
         * @param platformSummaryList
         *        Detailed information about the platforms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList);

        /**
         * <p>
         * Detailed information about the platforms.
         * </p>
         * 
         * @param platformSummaryList
         *        Detailed information about the platforms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummaryList(PlatformSummary... platformSummaryList);

        /**
         * <p>
         * Detailed information about the platforms.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PlatformSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #platformSummaryList(List<PlatformSummary>)}.
         * 
         * @param platformSummaryList
         *        a consumer that will call methods on {@link List<PlatformSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformSummaryList(List<PlatformSummary>)
         */
        Builder platformSummaryList(Consumer<PlatformSummary.Builder>... platformSummaryList);

        /**
         * <p>
         * The starting index into the remaining list of platforms. if this value is not <code>null</code>, you can use
         * it in a subsequent <code>ListPlatformVersion</code> call.
         * </p>
         * 
         * @param nextToken
         *        The starting index into the remaining list of platforms. if this value is not <code>null</code>, you
         *        can use it in a subsequent <code>ListPlatformVersion</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<PlatformSummary> platformSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsResponse model) {
            super(model);
            platformSummaryList(model.platformSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<PlatformSummary.Builder> getPlatformSummaryList() {
            return platformSummaryList != null ? platformSummaryList.stream().map(PlatformSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(PlatformSummary... platformSummaryList) {
            platformSummaryList(Arrays.asList(platformSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(Consumer<PlatformSummary.Builder>... platformSummaryList) {
            platformSummaryList(Stream.of(platformSummaryList).map(c -> PlatformSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformSummaryList(Collection<PlatformSummary.BuilderImpl> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copyFromBuilder(platformSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformVersionsResponse build() {
            return new ListPlatformVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
