/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationVersionRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreateApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::applicationName)).setter(CreateApplicationVersionRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::versionLabel)).setter(CreateApplicationVersionRequest.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::description)).setter(CreateApplicationVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<SourceBuildInformation> SOURCE_BUILD_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::sourceBuildInformation)).setter(CreateApplicationVersionRequest.setter(Builder::sourceBuildInformation)).constructor(SourceBuildInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBuildInformation").build()}).build();
    private static final SdkField<S3Location> SOURCE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::sourceBundle)).setter(CreateApplicationVersionRequest.setter(Builder::sourceBundle)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBundle").build()}).build();
    private static final SdkField<BuildConfiguration> BUILD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::buildConfiguration)).setter(CreateApplicationVersionRequest.setter(Builder::buildConfiguration)).constructor(BuildConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildConfiguration").build()}).build();
    private static final SdkField<Boolean> AUTO_CREATE_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::autoCreateApplication)).setter(CreateApplicationVersionRequest.setter(Builder::autoCreateApplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreateApplication").build()}).build();
    private static final SdkField<Boolean> PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::process)).setter(CreateApplicationVersionRequest.setter(Builder::process)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Process").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateApplicationVersionRequest.getter(CreateApplicationVersionRequest::tags)).setter(CreateApplicationVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, DESCRIPTION_FIELD, SOURCE_BUILD_INFORMATION_FIELD, SOURCE_BUNDLE_FIELD, BUILD_CONFIGURATION_FIELD, AUTO_CREATE_APPLICATION_FIELD, PROCESS_FIELD, TAGS_FIELD));
    private final String applicationName;
    private final String versionLabel;
    private final String description;
    private final SourceBuildInformation sourceBuildInformation;
    private final S3Location sourceBundle;
    private final BuildConfiguration buildConfiguration;
    private final Boolean autoCreateApplication;
    private final Boolean process;
    private final List<Tag> tags;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.description = builder.description;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.sourceBundle = builder.sourceBundle;
        this.buildConfiguration = builder.buildConfiguration;
        this.autoCreateApplication = builder.autoCreateApplication;
        this.process = builder.process;
        this.tags = builder.tags;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String description() {
        return this.description;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public BuildConfiguration buildConfiguration() {
        return this.buildConfiguration;
    }

    public Boolean autoCreateApplication() {
        return this.autoCreateApplication;
    }

    public Boolean process() {
        return this.process;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreateApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.process());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceBuildInformation(), other.sourceBuildInformation()) && Objects.equals(this.sourceBundle(), other.sourceBundle()) && Objects.equals(this.buildConfiguration(), other.buildConfiguration()) && Objects.equals(this.autoCreateApplication(), other.autoCreateApplication()) && Objects.equals(this.process(), other.process()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationVersionRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("Description", (Object)this.description()).add("SourceBuildInformation", (Object)this.sourceBuildInformation()).add("SourceBundle", (Object)this.sourceBundle()).add("BuildConfiguration", (Object)this.buildConfiguration()).add("AutoCreateApplication", (Object)this.autoCreateApplication()).add("Process", (Object)this.process()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SourceBuildInformation": {
                return Optional.ofNullable(clazz.cast(this.sourceBuildInformation()));
            }
            case "SourceBundle": {
                return Optional.ofNullable(clazz.cast(this.sourceBundle()));
            }
            case "BuildConfiguration": {
                return Optional.ofNullable(clazz.cast(this.buildConfiguration()));
            }
            case "AutoCreateApplication": {
                return Optional.ofNullable(clazz.cast(this.autoCreateApplication()));
            }
            case "Process": {
                return Optional.ofNullable(clazz.cast(this.process()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateApplicationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String description;
        private SourceBuildInformation sourceBuildInformation;
        private S3Location sourceBundle;
        private BuildConfiguration buildConfiguration;
        private Boolean autoCreateApplication;
        private Boolean process;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.description(model.description);
            this.sourceBuildInformation(model.sourceBuildInformation);
            this.sourceBundle(model.sourceBundle);
            this.buildConfiguration(model.buildConfiguration);
            this.autoCreateApplication(model.autoCreateApplication);
            this.process(model.process);
            this.tags(model.tags);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return this.sourceBuildInformation != null ? this.sourceBuildInformation.toBuilder() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        public final S3Location.Builder getSourceBundle() {
            return this.sourceBundle != null ? this.sourceBundle.toBuilder() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        public final BuildConfiguration.Builder getBuildConfiguration() {
            return this.buildConfiguration != null ? this.buildConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder buildConfiguration(BuildConfiguration buildConfiguration) {
            this.buildConfiguration = buildConfiguration;
            return this;
        }

        public final void setBuildConfiguration(BuildConfiguration.BuilderImpl buildConfiguration) {
            this.buildConfiguration = buildConfiguration != null ? buildConfiguration.build() : null;
        }

        public final Boolean getAutoCreateApplication() {
            return this.autoCreateApplication;
        }

        @Override
        public final Builder autoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
            return this;
        }

        public final void setAutoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
        }

        public final Boolean getProcess() {
            return this.process;
        }

        @Override
        public final Builder process(Boolean process) {
            this.process = process;
            return this;
        }

        public final void setProcess(Boolean process) {
            this.process = process;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder description(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        default public Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return this.sourceBuildInformation((SourceBuildInformation)((SourceBuildInformation.Builder)SourceBuildInformation.builder().applyMutation(sourceBuildInformation)).build());
        }

        public Builder sourceBundle(S3Location var1);

        default public Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return this.sourceBundle((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(sourceBundle)).build());
        }

        public Builder buildConfiguration(BuildConfiguration var1);

        default public Builder buildConfiguration(Consumer<BuildConfiguration.Builder> buildConfiguration) {
            return this.buildConfiguration((BuildConfiguration)((BuildConfiguration.Builder)BuildConfiguration.builder().applyMutation(buildConfiguration)).build());
        }

        public Builder autoCreateApplication(Boolean var1);

        public Builder process(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

