/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application request metrics for an AWS Elastic Beanstalk environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationMetrics.Builder, ApplicationMetrics> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ApplicationMetrics::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ApplicationMetrics::requestCount)).setter(setter(Builder::requestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()).build();

    private static final SdkField<StatusCodes> STATUS_CODES_FIELD = SdkField.<StatusCodes> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationMetrics::statusCodes)).setter(setter(Builder::statusCodes))
            .constructor(StatusCodes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCodes").build()).build();

    private static final SdkField<Latency> LATENCY_FIELD = SdkField.<Latency> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationMetrics::latency)).setter(setter(Builder::latency)).constructor(Latency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD,
            REQUEST_COUNT_FIELD, STATUS_CODES_FIELD, LATENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private final Integer requestCount;

    private final StatusCodes statusCodes;

    private final Latency latency;

    private ApplicationMetrics(BuilderImpl builder) {
        this.duration = builder.duration;
        this.requestCount = builder.requestCount;
        this.statusCodes = builder.statusCodes;
        this.latency = builder.latency;
    }

    /**
     * <p>
     * The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests (
     * <code>request_count</code>) within the most recent time slice of 10 seconds (<code>duration</code>).
     * </p>
     * 
     * @return The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests (
     *         <code>request_count</code>) within the most recent time slice of 10 seconds (<code>duration</code>).
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * Average number of requests handled by the web server per second over the last 10 seconds.
     * </p>
     * 
     * @return Average number of requests handled by the web server per second over the last 10 seconds.
     */
    public Integer requestCount() {
        return requestCount;
    }

    /**
     * <p>
     * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code
     * response.
     * </p>
     * 
     * @return Represents the percentage of requests over the last 10 seconds that resulted in each type of status code
     *         response.
     */
    public StatusCodes statusCodes() {
        return statusCodes;
    }

    /**
     * <p>
     * Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies are in
     * seconds with one millisecond resolution.
     * </p>
     * 
     * @return Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies
     *         are in seconds with one millisecond resolution.
     */
    public Latency latency() {
        return latency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodes());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationMetrics)) {
            return false;
        }
        ApplicationMetrics other = (ApplicationMetrics) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(requestCount(), other.requestCount())
                && Objects.equals(statusCodes(), other.statusCodes()) && Objects.equals(latency(), other.latency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationMetrics").add("Duration", duration()).add("RequestCount", requestCount())
                .add("StatusCodes", statusCodes()).add("Latency", latency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "RequestCount":
            return Optional.ofNullable(clazz.cast(requestCount()));
        case "StatusCodes":
            return Optional.ofNullable(clazz.cast(statusCodes()));
        case "Latency":
            return Optional.ofNullable(clazz.cast(latency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationMetrics, T> g) {
        return obj -> g.apply((ApplicationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationMetrics> {
        /**
         * <p>
         * The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests (
         * <code>request_count</code>) within the most recent time slice of 10 seconds (<code>duration</code>).
         * </p>
         * 
         * @param duration
         *        The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests
         *        (<code>request_count</code>) within the most recent time slice of 10 seconds (<code>duration</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * Average number of requests handled by the web server per second over the last 10 seconds.
         * </p>
         * 
         * @param requestCount
         *        Average number of requests handled by the web server per second over the last 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCount(Integer requestCount);

        /**
         * <p>
         * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code
         * response.
         * </p>
         * 
         * @param statusCodes
         *        Represents the percentage of requests over the last 10 seconds that resulted in each type of status
         *        code response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(StatusCodes statusCodes);

        /**
         * <p>
         * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code
         * response.
         * </p>
         * This is a convenience that creates an instance of the {@link StatusCodes.Builder} avoiding the need to create
         * one manually via {@link StatusCodes#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatusCodes.Builder#build()} is called immediately and its result
         * is passed to {@link #statusCodes(StatusCodes)}.
         * 
         * @param statusCodes
         *        a consumer that will call methods on {@link StatusCodes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusCodes(StatusCodes)
         */
        default Builder statusCodes(Consumer<StatusCodes.Builder> statusCodes) {
            return statusCodes(StatusCodes.builder().applyMutation(statusCodes).build());
        }

        /**
         * <p>
         * Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies are
         * in seconds with one millisecond resolution.
         * </p>
         * 
         * @param latency
         *        Represents the average latency for the slowest X percent of requests over the last 10 seconds.
         *        Latencies are in seconds with one millisecond resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Latency latency);

        /**
         * <p>
         * Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies are
         * in seconds with one millisecond resolution.
         * </p>
         * This is a convenience that creates an instance of the {@link Latency.Builder} avoiding the need to create one
         * manually via {@link Latency#builder()}.
         *
         * When the {@link Consumer} completes, {@link Latency.Builder#build()} is called immediately and its result is
         * passed to {@link #latency(Latency)}.
         * 
         * @param latency
         *        a consumer that will call methods on {@link Latency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latency(Latency)
         */
        default Builder latency(Consumer<Latency.Builder> latency) {
            return latency(Latency.builder().applyMutation(latency).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private Integer requestCount;

        private StatusCodes statusCodes;

        private Latency latency;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationMetrics model) {
            duration(model.duration);
            requestCount(model.requestCount);
            statusCodes(model.statusCodes);
            latency(model.latency);
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getRequestCount() {
            return requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final StatusCodes.Builder getStatusCodes() {
            return statusCodes != null ? statusCodes.toBuilder() : null;
        }

        @Override
        public final Builder statusCodes(StatusCodes statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public final void setStatusCodes(StatusCodes.BuilderImpl statusCodes) {
            this.statusCodes = statusCodes != null ? statusCodes.build() : null;
        }

        public final Latency.Builder getLatency() {
            return latency != null ? latency.toBuilder() : null;
        }

        @Override
        public final Builder latency(Latency latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Latency.BuilderImpl latency) {
            this.latency = latency != null ? latency.build() : null;
        }

        @Override
        public ApplicationMetrics build() {
            return new ApplicationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
