/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CodeBuildNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkServiceException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InsufficientPrivilegesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InvalidRequestException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionInvalidStateException;
import software.amazon.awssdk.services.elasticbeanstalk.model.OperationInProgressException;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformVersionStillReferencedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3LocationNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3SubscriptionRequiredException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBundleDeletionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationVersionsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyBucketsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyConfigurationTemplatesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyEnvironmentsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyPlatformsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable;

/**
 * Service client for accessing Elastic Beanstalk. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Elastic Beanstalk</fullname>
 * <p>
 * AWS Elastic Beanstalk makes it easy for you to create, deploy, and manage scalable, fault-tolerant applications
 * running on the Amazon Web Services cloud.
 * </p>
 * <p>
 * For more information about this product, go to the <a href="http://aws.amazon.com/elasticbeanstalk/">AWS Elastic
 * Beanstalk</a> details page. The location of the latest AWS Elastic Beanstalk WSDL is <a
 * href="https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl"
 * >https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl</a>. To install the Software
 * Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools that enable you to
 * access the API, go to <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 * <p>
 * <b>Endpoints</b>
 * </p>
 * <p>
 * For a list of region-specific endpoints that AWS Elastic Beanstalk supports, go to <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region">Regions and Endpoints</a> in
 * the <i>Amazon Web Services Glossary</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ElasticBeanstalkClient extends SdkClient {
    String SERVICE_NAME = "elasticbeanstalk";

    /**
     * Create a {@link ElasticBeanstalkClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticBeanstalkClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticBeanstalkClient}.
     */
    static ElasticBeanstalkClientBuilder builder() {
        return new DefaultElasticBeanstalkClientBuilder();
    }

    /**
     * <p>
     * Cancels in-progress environment configuration update or application version deployment.
     * </p>
     *
     * @param abortEnvironmentUpdateRequest
     * @return Result of the AbortEnvironmentUpdate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.AbortEnvironmentUpdate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default AbortEnvironmentUpdateResponse abortEnvironmentUpdate(AbortEnvironmentUpdateRequest abortEnvironmentUpdateRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels in-progress environment configuration update or application version deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortEnvironmentUpdateRequest.Builder} avoiding the
     * need to create one manually via {@link AbortEnvironmentUpdateRequest#builder()}
     * </p>
     *
     * @param abortEnvironmentUpdateRequest
     *        A {@link Consumer} that will call methods on {@link AbortEnvironmentUpdateMessage.Builder} to create a
     *        request.
     * @return Result of the AbortEnvironmentUpdate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.AbortEnvironmentUpdate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default AbortEnvironmentUpdateResponse abortEnvironmentUpdate(
            Consumer<AbortEnvironmentUpdateRequest.Builder> abortEnvironmentUpdateRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return abortEnvironmentUpdate(AbortEnvironmentUpdateRequest.builder().applyMutation(abortEnvironmentUpdateRequest)
                .build());
    }

    /**
     * <p>
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is
     * <code>Scheduled</code>. Get the status and action ID of a managed action with
     * <a>DescribeEnvironmentManagedActions</a>.
     * </p>
     *
     * @param applyEnvironmentManagedActionRequest
     *        Request to execute a scheduled managed action immediately.
     * @return Result of the ApplyEnvironmentManagedAction operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws ManagedActionInvalidStateException
     *         Cannot modify the managed action in its current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ApplyEnvironmentManagedAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyEnvironmentManagedActionResponse applyEnvironmentManagedAction(
            ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) throws ElasticBeanstalkServiceException,
            ManagedActionInvalidStateException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is
     * <code>Scheduled</code>. Get the status and action ID of a managed action with
     * <a>DescribeEnvironmentManagedActions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyEnvironmentManagedActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyEnvironmentManagedActionRequest#builder()}
     * </p>
     *
     * @param applyEnvironmentManagedActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyEnvironmentManagedActionRequest.Builder} to
     *        create a request. Request to execute a scheduled managed action immediately.
     * @return Result of the ApplyEnvironmentManagedAction operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws ManagedActionInvalidStateException
     *         Cannot modify the managed action in its current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ApplyEnvironmentManagedAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyEnvironmentManagedActionResponse applyEnvironmentManagedAction(
            Consumer<ApplyEnvironmentManagedActionRequest.Builder> applyEnvironmentManagedActionRequest)
            throws ElasticBeanstalkServiceException, ManagedActionInvalidStateException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest.builder()
                .applyMutation(applyEnvironmentManagedActionRequest).build());
    }

    /**
     * <p>
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the
     * associated operations role for permissions to downstream services during subsequent calls acting on this
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     *
     * @param associateEnvironmentOperationsRoleRequest
     *        Request to add or change the operations role used by an environment.
     * @return Result of the AssociateEnvironmentOperationsRole operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.AssociateEnvironmentOperationsRole
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnvironmentOperationsRoleResponse associateEnvironmentOperationsRole(
            AssociateEnvironmentOperationsRoleRequest associateEnvironmentOperationsRoleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the
     * associated operations role for permissions to downstream services during subsequent calls acting on this
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnvironmentOperationsRoleRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEnvironmentOperationsRoleRequest#builder()}
     * </p>
     *
     * @param associateEnvironmentOperationsRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEnvironmentOperationsRoleMessage.Builder} to
     *        create a request. Request to add or change the operations role used by an environment.
     * @return Result of the AssociateEnvironmentOperationsRole operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.AssociateEnvironmentOperationsRole
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnvironmentOperationsRoleResponse associateEnvironmentOperationsRole(
            Consumer<AssociateEnvironmentOperationsRoleRequest.Builder> associateEnvironmentOperationsRoleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return associateEnvironmentOperationsRole(AssociateEnvironmentOperationsRoleRequest.builder()
                .applyMutation(associateEnvironmentOperationsRoleRequest).build());
    }

    /**
     * <p>
     * Checks if the specified CNAME is available.
     * </p>
     *
     * @param checkDnsAvailabilityRequest
     *        Results message indicating whether a CNAME is available.
     * @return Result of the CheckDNSAvailability operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CheckDNSAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDnsAvailabilityResponse checkDNSAvailability(CheckDnsAvailabilityRequest checkDnsAvailabilityRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks if the specified CNAME is available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckDnsAvailabilityRequest.Builder} avoiding the
     * need to create one manually via {@link CheckDnsAvailabilityRequest#builder()}
     * </p>
     *
     * @param checkDnsAvailabilityRequest
     *        A {@link Consumer} that will call methods on {@link CheckDNSAvailabilityMessage.Builder} to create a
     *        request. Results message indicating whether a CNAME is available.
     * @return Result of the CheckDNSAvailability operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CheckDNSAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckDnsAvailabilityResponse checkDNSAvailability(
            Consumer<CheckDnsAvailabilityRequest.Builder> checkDnsAvailabilityRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return checkDNSAvailability(CheckDnsAvailabilityRequest.builder().applyMutation(checkDnsAvailabilityRequest).build());
    }

    /**
     * <p>
     * Create or update a group of environments that each run a separate component of a single application. Takes a list
     * of version labels that specify application source bundles for each of the environments to create or update. The
     * name of each environment and other required information must be included in the source bundles in an environment
     * manifest named <code>env.yaml</code>. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose
     * Environments</a> for details.
     * </p>
     *
     * @param composeEnvironmentsRequest
     *        Request to create or update a group of environments.
     * @return Result of the ComposeEnvironments operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ComposeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ComposeEnvironmentsResponse composeEnvironments(ComposeEnvironmentsRequest composeEnvironmentsRequest)
            throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update a group of environments that each run a separate component of a single application. Takes a list
     * of version labels that specify application source bundles for each of the environments to create or update. The
     * name of each environment and other required information must be included in the source bundles in an environment
     * manifest named <code>env.yaml</code>. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose
     * Environments</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ComposeEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ComposeEnvironmentsRequest#builder()}
     * </p>
     *
     * @param composeEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ComposeEnvironmentsMessage.Builder} to create a
     *        request. Request to create or update a group of environments.
     * @return Result of the ComposeEnvironments operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ComposeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default ComposeEnvironmentsResponse composeEnvironments(
            Consumer<ComposeEnvironmentsRequest.Builder> composeEnvironmentsRequest) throws TooManyEnvironmentsException,
            InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return composeEnvironments(ComposeEnvironmentsRequest.builder().applyMutation(composeEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Creates an application that has one configuration template named <code>default</code> and no application
     * versions.
     * </p>
     *
     * @param createApplicationRequest
     *        Request to create an application.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws TooManyApplicationsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application that has one configuration template named <code>default</code> and no application
     * versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationMessage.Builder} to create a request.
     *        Request to create an application.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws TooManyApplicationsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an application version for the specified application. You can create an application version from a source
     * bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     * </p>
     * <p>
     * Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.
     * </p>
     * <p>
     * Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.
     * </p>
     * <p>
     * Specify a source bundle in S3 with <code>SourceBundle</code>
     * </p>
     * <p>
     * Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample
     * application.
     * </p>
     * <note>
     * <p>
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that
     * Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an
     * environment from the application version.
     * </p>
     * </note>
     *
     * @param createApplicationVersionRequest
     * @return Result of the CreateApplicationVersion operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws TooManyApplicationVersionsException
     *         The specified account has reached its limit of application versions.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws CodeBuildNotInServiceRegionException
     *         AWS CodeBuild is not available in the specified region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationVersionResponse createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) throws TooManyApplicationsException,
            TooManyApplicationVersionsException, InsufficientPrivilegesException, S3LocationNotInServiceRegionException,
            CodeBuildNotInServiceRegionException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application version for the specified application. You can create an application version from a source
     * bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     * </p>
     * <p>
     * Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.
     * </p>
     * <p>
     * Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.
     * </p>
     * <p>
     * Specify a source bundle in S3 with <code>SourceBundle</code>
     * </p>
     * <p>
     * Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample
     * application.
     * </p>
     * <note>
     * <p>
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that
     * Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an
     * environment from the application version.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationVersionMessage.Builder} to create a
     *        request.
     * @return Result of the CreateApplicationVersion operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws TooManyApplicationVersionsException
     *         The specified account has reached its limit of application versions.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws CodeBuildNotInServiceRegionException
     *         AWS CodeBuild is not available in the specified region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationVersionResponse createApplicationVersion(
            Consumer<CreateApplicationVersionRequest.Builder> createApplicationVersionRequest)
            throws TooManyApplicationsException, TooManyApplicationVersionsException, InsufficientPrivilegesException,
            S3LocationNotInServiceRegionException, CodeBuildNotInServiceRegionException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return createApplicationVersion(CreateApplicationVersionRequest.builder().applyMutation(createApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You can then use the
     * configuration template to deploy different versions of the application with the same configuration settings.
     * </p>
     * <p>
     * Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always
     * <code>null</code>.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeConfigurationSettings</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListAvailableSolutionStacks</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createConfigurationTemplateRequest
     *        Request to create a configuration template.
     * @return Result of the CreateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws TooManyConfigurationTemplatesException
     *         The specified account has reached its limit of configuration templates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationTemplateResponse createConfigurationTemplate(
            CreateConfigurationTemplateRequest createConfigurationTemplateRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, TooManyConfigurationTemplatesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You can then use the
     * configuration template to deploy different versions of the application with the same configuration settings.
     * </p>
     * <p>
     * Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always
     * <code>null</code>.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeConfigurationSettings</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListAvailableSolutionStacks</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationTemplateMessage.Builder} to create
     *        a request. Request to create a configuration template.
     * @return Result of the CreateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws TooManyConfigurationTemplatesException
     *         The specified account has reached its limit of configuration templates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationTemplateResponse createConfigurationTemplate(
            Consumer<CreateConfigurationTemplateRequest.Builder> createConfigurationTemplateRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, TooManyConfigurationTemplatesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return createConfigurationTemplate(CreateConfigurationTemplateRequest.builder()
                .applyMutation(createConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest)
            throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentMessage.Builder} to create a request.
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEnvironmentResponse createEnvironment(Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest)
            throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Create a new version of your custom platform.
     * </p>
     *
     * @param createPlatformVersionRequest
     *        Request to create a new platform version.
     * @return Result of the CreatePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws TooManyPlatformsException
     *         You have exceeded the maximum number of allowed platforms associated with the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreatePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlatformVersionResponse createPlatformVersion(CreatePlatformVersionRequest createPlatformVersionRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, TooManyPlatformsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new version of your custom platform.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlatformVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlatformVersionRequest#builder()}
     * </p>
     *
     * @param createPlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlatformVersionRequest.Builder} to create a
     *        request. Request to create a new platform version.
     * @return Result of the CreatePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws TooManyPlatformsException
     *         You have exceeded the maximum number of allowed platforms associated with the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreatePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlatformVersionResponse createPlatformVersion(
            Consumer<CreatePlatformVersionRequest.Builder> createPlatformVersionRequest) throws InsufficientPrivilegesException,
            ElasticBeanstalkServiceException, TooManyPlatformsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return createPlatformVersion(CreatePlatformVersionRequest.builder().applyMutation(createPlatformVersionRequest).build());
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     *
     * @return Result of the CreateStorageLocation operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws S3SubscriptionRequiredException
     *         The specified account does not have a subscription to Amazon S3.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateStorageLocation
     * @see #createStorageLocation(CreateStorageLocationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStorageLocationResponse createStorageLocation() throws TooManyBucketsException,
            S3SubscriptionRequiredException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return createStorageLocation(CreateStorageLocationRequest.builder().build());
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     *
     * @param createStorageLocationRequest
     * @return Result of the CreateStorageLocation operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws S3SubscriptionRequiredException
     *         The specified account does not have a subscription to Amazon S3.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateStorageLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStorageLocationResponse createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest)
            throws TooManyBucketsException, S3SubscriptionRequiredException, InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorageLocationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStorageLocationRequest#builder()}
     * </p>
     *
     * @param createStorageLocationRequest
     *        A {@link Consumer} that will call methods on {@link CreateStorageLocationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStorageLocation operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws S3SubscriptionRequiredException
     *         The specified account does not have a subscription to Amazon S3.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateStorageLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStorageLocationResponse createStorageLocation(
            Consumer<CreateStorageLocationRequest.Builder> createStorageLocationRequest) throws TooManyBucketsException,
            S3SubscriptionRequiredException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return createStorageLocation(CreateStorageLocationRequest.builder().applyMutation(createStorageLocationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application along with all associated versions and configurations. The application versions
     * will not be deleted from your Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application that has a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationRequest
     *        Request to delete an application.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application along with all associated versions and configurations. The application versions
     * will not be deleted from your Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application that has a running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationMessage.Builder} to create a request.
     *        Request to delete an application.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version from the specified application.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application version that is associated with a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationVersionRequest
     *        Request to delete an application version.
     * @return Result of the DeleteApplicationVersion operation returned by the service.
     * @throws SourceBundleDeletionException
     *         Unable to delete the Amazon S3 source bundle associated with the application version. The application
     *         version was deleted successfully.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationVersionResponse deleteApplicationVersion(
            DeleteApplicationVersionRequest deleteApplicationVersionRequest) throws SourceBundleDeletionException,
            InsufficientPrivilegesException, OperationInProgressException, S3LocationNotInServiceRegionException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version from the specified application.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application version that is associated with a running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationVersionRequest#builder()}
     * </p>
     *
     * @param deleteApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationVersionMessage.Builder} to create a
     *        request. Request to delete an application version.
     * @return Result of the DeleteApplicationVersion operation returned by the service.
     * @throws SourceBundleDeletionException
     *         Unable to delete the Amazon S3 source bundle associated with the application version. The application
     *         version was deleted successfully.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationVersionResponse deleteApplicationVersion(
            Consumer<DeleteApplicationVersionRequest.Builder> deleteApplicationVersionRequest)
            throws SourceBundleDeletionException, InsufficientPrivilegesException, OperationInProgressException,
            S3LocationNotInServiceRegionException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return deleteApplicationVersion(DeleteApplicationVersionRequest.builder().applyMutation(deleteApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified configuration template.
     * </p>
     * <note>
     * <p>
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You
     * can delete or modify the environment's copy of the template without affecting the running environment.
     * </p>
     * </note>
     *
     * @param deleteConfigurationTemplateRequest
     *        Request to delete a configuration template.
     * @return Result of the DeleteConfigurationTemplate operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationTemplateResponse deleteConfigurationTemplate(
            DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) throws OperationInProgressException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configuration template.
     * </p>
     * <note>
     * <p>
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You
     * can delete or modify the environment's copy of the template without affecting the running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationTemplateMessage.Builder} to create
     *        a request. Request to delete a configuration template.
     * @return Result of the DeleteConfigurationTemplate operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationTemplateResponse deleteConfigurationTemplate(
            Consumer<DeleteConfigurationTemplateRequest.Builder> deleteConfigurationTemplateRequest)
            throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return deleteConfigurationTemplate(DeleteConfigurationTemplateRequest.builder()
                .applyMutation(deleteConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the draft configuration associated with the running environment.
     * </p>
     * <p>
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the
     * draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
     * fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in
     * process or has failed. The draft configuration remains in existence until it is deleted with this action.
     * </p>
     *
     * @param deleteEnvironmentConfigurationRequest
     *        Request to delete a draft environment configuration.
     * @return Result of the DeleteEnvironmentConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteEnvironmentConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentConfigurationResponse deleteEnvironmentConfiguration(
            DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the draft configuration associated with the running environment.
     * </p>
     * <p>
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the
     * draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
     * fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in
     * process or has failed. The draft configuration remains in existence until it is deleted with this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEnvironmentConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentConfigurationMessage.Builder} to
     *        create a request. Request to delete a draft environment configuration.
     * @return Result of the DeleteEnvironmentConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteEnvironmentConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEnvironmentConfigurationResponse deleteEnvironmentConfiguration(
            Consumer<DeleteEnvironmentConfigurationRequest.Builder> deleteEnvironmentConfigurationRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest.builder()
                .applyMutation(deleteEnvironmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version of a custom platform.
     * </p>
     *
     * @param deletePlatformVersionRequest
     * @return Result of the DeletePlatformVersion operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws PlatformVersionStillReferencedException
     *         You cannot delete the platform version because there are still environments running on it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeletePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlatformVersionResponse deletePlatformVersion(DeletePlatformVersionRequest deletePlatformVersionRequest)
            throws OperationInProgressException, InsufficientPrivilegesException, ElasticBeanstalkServiceException,
            PlatformVersionStillReferencedException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version of a custom platform.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlatformVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePlatformVersionRequest#builder()}
     * </p>
     *
     * @param deletePlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlatformVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePlatformVersion operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws PlatformVersionStillReferencedException
     *         You cannot delete the platform version because there are still environments running on it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeletePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlatformVersionResponse deletePlatformVersion(
            Consumer<DeletePlatformVersionRequest.Builder> deletePlatformVersionRequest) throws OperationInProgressException,
            InsufficientPrivilegesException, ElasticBeanstalkServiceException, PlatformVersionStillReferencedException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return deletePlatformVersion(DeletePlatformVersionRequest.builder().applyMutation(deletePlatformVersionRequest).build());
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     *
     * @return Result of the DescribeApplicationVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplicationVersions
     * @see #describeApplicationVersions(DescribeApplicationVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationVersionsResponse describeApplicationVersions() throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return describeApplicationVersions(DescribeApplicationVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     *
     * @param describeApplicationVersionsRequest
     *        Request to describe application versions.
     * @return Result of the DescribeApplicationVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplicationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationVersionsResponse describeApplicationVersions(
            DescribeApplicationVersionsRequest describeApplicationVersionsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param describeApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationVersionsMessage.Builder} to create
     *        a request. Request to describe application versions.
     * @return Result of the DescribeApplicationVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplicationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationVersionsResponse describeApplicationVersions(
            Consumer<DescribeApplicationVersionsRequest.Builder> describeApplicationVersionsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return describeApplicationVersions(DescribeApplicationVersionsRequest.builder()
                .applyMutation(describeApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     *
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplications
     * @see #describeApplications(DescribeApplicationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications() throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return describeApplications(DescribeApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     *
     * @param describeApplicationsRequest
     *        Request to describe one or more applications.
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationsMessage.Builder} to create a
     *        request. Request to describe one or more applications.
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return describeApplications(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest).build());
    }

    /**
     * <p>
     * Describes the configuration options that are used in a particular configuration template or environment, or that
     * a specified solution stack defines. The description includes the values the options, their default values, and an
     * indication of the required action on a running environment if an option value is changed.
     * </p>
     *
     * @param describeConfigurationOptionsRequest
     *        Result message containing a list of application version descriptions.
     * @return Result of the DescribeConfigurationOptions operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationOptionsResponse describeConfigurationOptions(
            DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) throws TooManyBucketsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the configuration options that are used in a particular configuration template or environment, or that
     * a specified solution stack defines. The description includes the values the options, their default values, and an
     * indication of the required action on a running environment if an option value is changed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationOptionsMessage.Builder} to create
     *        a request. Result message containing a list of application version descriptions.
     * @return Result of the DescribeConfigurationOptions operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationOptionsResponse describeConfigurationOptions(
            Consumer<DescribeConfigurationOptionsRequest.Builder> describeConfigurationOptionsRequest)
            throws TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeConfigurationOptions(DescribeConfigurationOptionsRequest.builder()
                .applyMutation(describeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a description of the settings for the specified configuration set, that is, either a configuration
     * template or the configuration set associated with a running environment.
     * </p>
     * <p>
     * When describing the settings for the configuration set associated with a running environment, it is possible to
     * receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft
     * configuration of an environment that is either in the process of deployment or that failed to deploy.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteEnvironmentConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeConfigurationSettingsRequest
     *        Result message containing all of the configuration settings for a specified solution stack or
     *        configuration template.
     * @return Result of the DescribeConfigurationSettings operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSettingsResponse describeConfigurationSettings(
            DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) throws TooManyBucketsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the settings for the specified configuration set, that is, either a configuration
     * template or the configuration set associated with a running environment.
     * </p>
     * <p>
     * When describing the settings for the configuration set associated with a running environment, it is possible to
     * receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft
     * configuration of an environment that is either in the process of deployment or that failed to deploy.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteEnvironmentConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationSettingsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationSettingsMessage.Builder} to
     *        create a request. Result message containing all of the configuration settings for a specified solution
     *        stack or configuration template.
     * @return Result of the DescribeConfigurationSettings operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSettingsResponse describeConfigurationSettings(
            Consumer<DescribeConfigurationSettingsRequest.Builder> describeConfigurationSettingsRequest)
            throws TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeConfigurationSettings(DescribeConfigurationSettingsRequest.builder()
                .applyMutation(describeConfigurationSettingsRequest).build());
    }

    /**
     * <p>
     * Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b>
     * operation is only available with AWS Elastic Beanstalk Enhanced Health.
     * </p>
     *
     * @param describeEnvironmentHealthRequest
     *        See the example below to learn how to create a request body.
     * @return Result of the DescribeEnvironmentHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentHealthResponse describeEnvironmentHealth(
            DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) throws InvalidRequestException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b>
     * operation is only available with AWS Elastic Beanstalk Enhanced Health.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEnvironmentHealthRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentHealthRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentHealthRequest.Builder} to create a
     *        request. See the example below to learn how to create a request body.
     * @return Result of the DescribeEnvironmentHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentHealthResponse describeEnvironmentHealth(
            Consumer<DescribeEnvironmentHealthRequest.Builder> describeEnvironmentHealthRequest) throws InvalidRequestException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEnvironmentHealth(DescribeEnvironmentHealthRequest.builder()
                .applyMutation(describeEnvironmentHealthRequest).build());
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        Request to list completed and failed managed actions.
     * @return Result of the DescribeEnvironmentManagedActionHistory operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryResponse describeEnvironmentManagedActionHistory(
            DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEnvironmentManagedActionHistoryRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} to create a request. Request to list
     *        completed and failed managed actions.
     * @return Result of the DescribeEnvironmentManagedActionHistory operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryResponse describeEnvironmentManagedActionHistory(
            Consumer<DescribeEnvironmentManagedActionHistoryRequest.Builder> describeEnvironmentManagedActionHistoryRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest.builder()
                .applyMutation(describeEnvironmentManagedActionHistoryRequest).build());
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client
     *             .describeEnvironmentManagedActionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        Request to list completed and failed managed actions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryIterable describeEnvironmentManagedActionHistoryPaginator(
            DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client
     *             .describeEnvironmentManagedActionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryIterable responses = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEnvironmentManagedActionHistoryRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} to create a request. Request to list
     *        completed and failed managed actions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryIterable describeEnvironmentManagedActionHistoryPaginator(
            Consumer<DescribeEnvironmentManagedActionHistoryRequest.Builder> describeEnvironmentManagedActionHistoryRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEnvironmentManagedActionHistoryPaginator(DescribeEnvironmentManagedActionHistoryRequest.builder()
                .applyMutation(describeEnvironmentManagedActionHistoryRequest).build());
    }

    /**
     * <p>
     * Lists an environment's upcoming and in-progress managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionsRequest
     *        Request to list an environment's upcoming and in-progress managed actions.
     * @return Result of the DescribeEnvironmentManagedActions operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActions
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionsResponse describeEnvironmentManagedActions(
            DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's upcoming and in-progress managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentManagedActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentManagedActionsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentManagedActionsRequest.Builder} to
     *        create a request. Request to list an environment's upcoming and in-progress managed actions.
     * @return Result of the DescribeEnvironmentManagedActions operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActions
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionsResponse describeEnvironmentManagedActions(
            Consumer<DescribeEnvironmentManagedActionsRequest.Builder> describeEnvironmentManagedActionsRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest.builder()
                .applyMutation(describeEnvironmentManagedActionsRequest).build());
    }

    /**
     * <p>
     * Returns AWS resources for this environment.
     * </p>
     *
     * @param describeEnvironmentResourcesRequest
     *        Request to describe the resources in an environment.
     * @return Result of the DescribeEnvironmentResources operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentResourcesResponse describeEnvironmentResources(
            DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS resources for this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentResourcesRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentResourcesMessage.Builder} to create
     *        a request. Request to describe the resources in an environment.
     * @return Result of the DescribeEnvironmentResources operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentResourcesResponse describeEnvironmentResources(
            Consumer<DescribeEnvironmentResourcesRequest.Builder> describeEnvironmentResourcesRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEnvironmentResources(DescribeEnvironmentResourcesRequest.builder()
                .applyMutation(describeEnvironmentResourcesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     *
     * @return Result of the DescribeEnvironments operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironments
     * @see #describeEnvironments(DescribeEnvironmentsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentsResponse describeEnvironments() throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return describeEnvironments(DescribeEnvironmentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        Request to describe one or more environments.
     * @return Result of the DescribeEnvironments operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentsResponse describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEnvironmentsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentsMessage.Builder} to create a
     *        request. Request to describe one or more environments.
     * @return Result of the DescribeEnvironments operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentsResponse describeEnvironments(
            Consumer<DescribeEnvironmentsRequest.Builder> describeEnvironmentsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return describeEnvironments(DescribeEnvironmentsRequest.builder().applyMutation(describeEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Request to retrieve a list of events for an environment.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Request to retrieve a list of events for an environment.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation
     * requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting</a>.
     * </p>
     *
     * @param describeInstancesHealthRequest
     *        Parameters for a call to <code>DescribeInstancesHealth</code>.
     * @return Result of the DescribeInstancesHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeInstancesHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancesHealthResponse describeInstancesHealth(DescribeInstancesHealthRequest describeInstancesHealthRequest)
            throws InvalidRequestException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation
     * requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancesHealthRequest#builder()}
     * </p>
     *
     * @param describeInstancesHealthRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancesHealthRequest.Builder} to create a
     *        request. Parameters for a call to <code>DescribeInstancesHealth</code>.
     * @return Result of the DescribeInstancesHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeInstancesHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancesHealthResponse describeInstancesHealth(
            Consumer<DescribeInstancesHealthRequest.Builder> describeInstancesHealthRequest) throws InvalidRequestException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return describeInstancesHealth(DescribeInstancesHealthRequest.builder().applyMutation(describeInstancesHealthRequest)
                .build());
    }

    /**
     * <p>
     * Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides
     * summary information about a list of platform versions.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param describePlatformVersionRequest
     * @return Result of the DescribePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlatformVersionResponse describePlatformVersion(DescribePlatformVersionRequest describePlatformVersionRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides
     * summary information about a list of platform versions.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlatformVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePlatformVersionRequest#builder()}
     * </p>
     *
     * @param describePlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlatformVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlatformVersionResponse describePlatformVersion(
            Consumer<DescribePlatformVersionRequest.Builder> describePlatformVersionRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return describePlatformVersion(DescribePlatformVersionRequest.builder().applyMutation(describePlatformVersionRequest)
                .build());
    }

    /**
     * <p>
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the
     * caller's permissions for permissions to downstream services during subsequent calls acting on this environment.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     *
     * @param disassociateEnvironmentOperationsRoleRequest
     *        Request to disassociate the operations role from an environment.
     * @return Result of the DisassociateEnvironmentOperationsRole operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DisassociateEnvironmentOperationsRole
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEnvironmentOperationsRoleResponse disassociateEnvironmentOperationsRole(
            DisassociateEnvironmentOperationsRoleRequest disassociateEnvironmentOperationsRoleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the
     * caller's permissions for permissions to downstream services during subsequent calls acting on this environment.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateEnvironmentOperationsRoleRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateEnvironmentOperationsRoleRequest#builder()}
     * </p>
     *
     * @param disassociateEnvironmentOperationsRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateEnvironmentOperationsRoleMessage.Builder}
     *        to create a request. Request to disassociate the operations role from an environment.
     * @return Result of the DisassociateEnvironmentOperationsRole operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DisassociateEnvironmentOperationsRole
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateEnvironmentOperationsRoleResponse disassociateEnvironmentOperationsRole(
            Consumer<DisassociateEnvironmentOperationsRoleRequest.Builder> disassociateEnvironmentOperationsRoleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return disassociateEnvironmentOperationsRole(DisassociateEnvironmentOperationsRoleRequest.builder()
                .applyMutation(disassociateEnvironmentOperationsRoleRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     *
     * @return Result of the ListAvailableSolutionStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListAvailableSolutionStacks
     * @see #listAvailableSolutionStacks(ListAvailableSolutionStacksRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableSolutionStacksResponse listAvailableSolutionStacks() throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     *
     * @param listAvailableSolutionStacksRequest
     * @return Result of the ListAvailableSolutionStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListAvailableSolutionStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableSolutionStacksResponse listAvailableSolutionStacks(
            ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableSolutionStacksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableSolutionStacksRequest#builder()}
     * </p>
     *
     * @param listAvailableSolutionStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableSolutionStacksRequest.Builder} to create
     *        a request.
     * @return Result of the ListAvailableSolutionStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListAvailableSolutionStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableSolutionStacksResponse listAvailableSolutionStacks(
            Consumer<ListAvailableSolutionStacksRequest.Builder> listAvailableSolutionStacksRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.builder()
                .applyMutation(listAvailableSolutionStacksRequest).build());
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return Result of the ListPlatformBranches operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesResponse listPlatformBranches(ListPlatformBranchesRequest listPlatformBranchesRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformBranchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformBranchesRequest#builder()}
     * </p>
     *
     * @param listPlatformBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformBranchesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPlatformBranches operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesResponse listPlatformBranches(
            Consumer<ListPlatformBranchesRequest.Builder> listPlatformBranchesRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return listPlatformBranches(ListPlatformBranchesRequest.builder().applyMutation(listPlatformBranchesRequest).build());
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client
     *             .listPlatformBranchesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesIterable listPlatformBranchesPaginator(ListPlatformBranchesRequest listPlatformBranchesRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client
     *             .listPlatformBranchesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformBranchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformBranchesRequest#builder()}
     * </p>
     *
     * @param listPlatformBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformBranchesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesIterable listPlatformBranchesPaginator(
            Consumer<ListPlatformBranchesRequest.Builder> listPlatformBranchesRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return listPlatformBranchesPaginator(ListPlatformBranchesRequest.builder().applyMutation(listPlatformBranchesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @return Result of the ListPlatformVersions operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see #listPlatformVersions(ListPlatformVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsResponse listPlatformVersions() throws InsufficientPrivilegesException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return listPlatformVersions(ListPlatformVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformVersionsRequest
     * @return Result of the ListPlatformVersions operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsResponse listPlatformVersions(ListPlatformVersionsRequest listPlatformVersionsRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformVersionsRequest#builder()}
     * </p>
     *
     * @param listPlatformVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPlatformVersions operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsResponse listPlatformVersions(
            Consumer<ListPlatformVersionsRequest.Builder> listPlatformVersionsRequest) throws InsufficientPrivilegesException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return listPlatformVersions(ListPlatformVersionsRequest.builder().applyMutation(listPlatformVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client
     *             .listPlatformVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see #listPlatformVersionsPaginator(ListPlatformVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsIterable listPlatformVersionsPaginator() throws InsufficientPrivilegesException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return listPlatformVersionsPaginator(ListPlatformVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client
     *             .listPlatformVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsIterable listPlatformVersionsPaginator(ListPlatformVersionsRequest listPlatformVersionsRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client
     *             .listPlatformVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsIterable responses = client.listPlatformVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformVersionsRequest#builder()}
     * </p>
     *
     * @param listPlatformVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsIterable listPlatformVersionsPaginator(
            Consumer<ListPlatformVersionsRequest.Builder> listPlatformVersionsRequest) throws InsufficientPrivilegesException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return listPlatformVersionsPaginator(ListPlatformVersionsRequest.builder().applyMutation(listPlatformVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value
     * pairs.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InsufficientPrivilegesException, ResourceNotFoundException, ResourceTypeNotSupportedException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value
     * pairs.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InsufficientPrivilegesException,
            ResourceNotFoundException, ResourceTypeNotSupportedException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a
     * specified environment and forces a restart.
     * </p>
     *
     * @param rebuildEnvironmentRequest
     * @return Result of the RebuildEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RebuildEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default RebuildEnvironmentResponse rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a
     * specified environment and forces a restart.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebuildEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link RebuildEnvironmentRequest#builder()}
     * </p>
     *
     * @param rebuildEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link RebuildEnvironmentMessage.Builder} to create a
     *        request.
     * @return Result of the RebuildEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RebuildEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default RebuildEnvironmentResponse rebuildEnvironment(Consumer<RebuildEnvironmentRequest.Builder> rebuildEnvironmentRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return rebuildEnvironment(RebuildEnvironmentRequest.builder().applyMutation(rebuildEnvironmentRequest).build());
    }

    /**
     * <p>
     * Initiates a request to compile the specified type of information of the deployed environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log
     * files of every Amazon EC2 instance in your environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every
     * Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs.
     * </p>
     * <p>
     * Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RetrieveEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param requestEnvironmentInfoRequest
     *        Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage bucket.
     * @return Result of the RequestEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RequestEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestEnvironmentInfoResponse requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a request to compile the specified type of information of the deployed environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log
     * files of every Amazon EC2 instance in your environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every
     * Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs.
     * </p>
     * <p>
     * Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RetrieveEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestEnvironmentInfoRequest.Builder} avoiding the
     * need to create one manually via {@link RequestEnvironmentInfoRequest#builder()}
     * </p>
     *
     * @param requestEnvironmentInfoRequest
     *        A {@link Consumer} that will call methods on {@link RequestEnvironmentInfoMessage.Builder} to create a
     *        request. Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage
     *        bucket.
     * @return Result of the RequestEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RequestEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestEnvironmentInfoResponse requestEnvironmentInfo(
            Consumer<RequestEnvironmentInfoRequest.Builder> requestEnvironmentInfoRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return requestEnvironmentInfo(RequestEnvironmentInfoRequest.builder().applyMutation(requestEnvironmentInfoRequest)
                .build());
    }

    /**
     * <p>
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     * </p>
     *
     * @param restartAppServerRequest
     * @return Result of the RestartAppServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RestartAppServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartAppServerResponse restartAppServer(RestartAppServerRequest restartAppServerRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartAppServerRequest.Builder} avoiding the need
     * to create one manually via {@link RestartAppServerRequest#builder()}
     * </p>
     *
     * @param restartAppServerRequest
     *        A {@link Consumer} that will call methods on {@link RestartAppServerMessage.Builder} to create a request.
     * @return Result of the RestartAppServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RestartAppServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartAppServerResponse restartAppServer(Consumer<RestartAppServerRequest.Builder> restartAppServerRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return restartAppServer(RestartAppServerRequest.builder().applyMutation(restartAppServerRequest).build());
    }

    /**
     * <p>
     * Retrieves the compiled information from a <a>RequestEnvironmentInfo</a> request.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RequestEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param retrieveEnvironmentInfoRequest
     *        Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
     * @return Result of the RetrieveEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RetrieveEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveEnvironmentInfoResponse retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the compiled information from a <a>RequestEnvironmentInfo</a> request.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RequestEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveEnvironmentInfoRequest.Builder} avoiding
     * the need to create one manually via {@link RetrieveEnvironmentInfoRequest#builder()}
     * </p>
     *
     * @param retrieveEnvironmentInfoRequest
     *        A {@link Consumer} that will call methods on {@link RetrieveEnvironmentInfoMessage.Builder} to create a
     *        request. Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
     * @return Result of the RetrieveEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RetrieveEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveEnvironmentInfoResponse retrieveEnvironmentInfo(
            Consumer<RetrieveEnvironmentInfoRequest.Builder> retrieveEnvironmentInfoRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest.builder().applyMutation(retrieveEnvironmentInfoRequest)
                .build());
    }

    /**
     * <p>
     * Swaps the CNAMEs of two environments.
     * </p>
     *
     * @param swapEnvironmentCnamEsRequest
     *        Swaps the CNAMEs of two environments.
     * @return Result of the SwapEnvironmentCNAMEs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.SwapEnvironmentCNAMEs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs"
     *      target="_top">AWS API Documentation</a>
     */
    default SwapEnvironmentCnamEsResponse swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Swaps the CNAMEs of two environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SwapEnvironmentCnamEsRequest.Builder} avoiding the
     * need to create one manually via {@link SwapEnvironmentCnamEsRequest#builder()}
     * </p>
     *
     * @param swapEnvironmentCnamEsRequest
     *        A {@link Consumer} that will call methods on {@link SwapEnvironmentCNAMEsMessage.Builder} to create a
     *        request. Swaps the CNAMEs of two environments.
     * @return Result of the SwapEnvironmentCNAMEs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.SwapEnvironmentCNAMEs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs"
     *      target="_top">AWS API Documentation</a>
     */
    default SwapEnvironmentCnamEsResponse swapEnvironmentCNAMEs(
            Consumer<SwapEnvironmentCnamEsRequest.Builder> swapEnvironmentCnamEsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest.builder().applyMutation(swapEnvironmentCnamEsRequest).build());
    }

    /**
     * <p>
     * Terminates the specified environment.
     * </p>
     *
     * @param terminateEnvironmentRequest
     *        Request to terminate an environment.
     * @return Result of the TerminateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.TerminateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateEnvironmentResponse terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateEnvironmentRequest#builder()}
     * </p>
     *
     * @param terminateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link TerminateEnvironmentMessage.Builder} to create a
     *        request. Request to terminate an environment.
     * @return Result of the TerminateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.TerminateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateEnvironmentResponse terminateEnvironment(
            Consumer<TerminateEnvironmentRequest.Builder> terminateEnvironmentRequest) throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return terminateEnvironment(TerminateEnvironmentRequest.builder().applyMutation(terminateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates the specified application to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * these properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     *        Request to update an application.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * these properties, specify an empty string.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationMessage.Builder} to create a request.
     *        Request to update an application.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Modifies lifecycle settings for an application.
     * </p>
     *
     * @param updateApplicationResourceLifecycleRequest
     * @return Result of the UpdateApplicationResourceLifecycle operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationResourceLifecycle
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResourceLifecycleResponse updateApplicationResourceLifecycle(
            UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies lifecycle settings for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationResourceLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApplicationResourceLifecycleRequest#builder()}
     * </p>
     *
     * @param updateApplicationResourceLifecycleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationResourceLifecycleMessage.Builder} to
     *        create a request.
     * @return Result of the UpdateApplicationResourceLifecycle operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationResourceLifecycle
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResourceLifecycleResponse updateApplicationResourceLifecycle(
            Consumer<UpdateApplicationResourceLifecycleRequest.Builder> updateApplicationResourceLifecycleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest.builder()
                .applyMutation(updateApplicationResourceLifecycleRequest).build());
    }

    /**
     * <p>
     * Updates the specified application version to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationVersionRequest
     * @return Result of the UpdateApplicationVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationVersionResponse updateApplicationVersion(
            UpdateApplicationVersionRequest updateApplicationVersionRequest) throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application version to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * properties, specify an empty string.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param updateApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationVersionMessage.Builder} to create a
     *        request.
     * @return Result of the UpdateApplicationVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationVersionResponse updateApplicationVersion(
            Consumer<UpdateApplicationVersionRequest.Builder> updateApplicationVersionRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {
        return updateApplicationVersion(UpdateApplicationVersionRequest.builder().applyMutation(updateApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified configuration template to have the specified properties or configuration option values.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear
     * such properties, specify an empty string.
     * </p>
     * </note>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConfigurationTemplateRequest
     *        The result message containing the options for the specified solution stack.
     * @return Result of the UpdateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationTemplateResponse updateConfigurationTemplate(
            UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified configuration template to have the specified properties or configuration option values.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear
     * such properties, specify an empty string.
     * </p>
     * </note>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationTemplateMessage.Builder} to create
     *        a request. The result message containing the options for the specified solution stack.
     * @return Result of the UpdateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationTemplateResponse updateConfigurationTemplate(
            Consumer<UpdateConfigurationTemplateRequest.Builder> updateConfigurationTemplateRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return updateConfigurationTemplate(UpdateConfigurationTemplateRequest.builder()
                .applyMutation(updateConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the environment description, deploys a new application version, updates the configuration settings to an
     * entirely new configuration template, or updates select configuration option values in the running environment.
     * </p>
     * <p>
     * Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an
     * <code>InvalidParameterCombination</code> error.
     * </p>
     * <p>
     * When updating the configuration settings to a new template or individual settings, a draft configuration is
     * created and <a>DescribeConfigurationSettings</a> for this environment returns two setting descriptions with
     * different <code>DeploymentStatus</code> values.
     * </p>
     *
     * @param updateEnvironmentRequest
     *        Request to update an environment.
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the environment description, deploys a new application version, updates the configuration settings to an
     * entirely new configuration template, or updates select configuration option values in the running environment.
     * </p>
     * <p>
     * Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an
     * <code>InvalidParameterCombination</code> error.
     * </p>
     * <p>
     * When updating the configuration settings to a new template or individual settings, a draft configuration is
     * created and <a>DescribeConfigurationSettings</a> for this environment returns two setting descriptions with
     * different <code>DeploymentStatus</code> values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentMessage.Builder} to create a request.
     *        Request to update an environment.
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEnvironmentResponse updateEnvironment(Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed:
     * <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <p>
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two
     * virtual actions (or both) instead of the API operation name:
     * </p>
     * <dl>
     * <dt>elasticbeanstalk:AddTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the
     * <code>TagsToAdd</code> parameter.
     * </p>
     * </dd>
     * <dt>elasticbeanstalk:RemoveTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the
     * <code>TagsToRemove</code> parameter.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For details about creating a custom user policy, see <a href=
     * "https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies"
     * >Creating a Custom User Policy</a>.
     * </p>
     *
     * @param updateTagsForResourceRequest
     * @return Result of the UpdateTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws TooManyTagsException
     *         The number of tags in the resource would exceed the number of tags that each resource can have.</p>
     *         <p>
     *         To calculate this, the operation considers both the number of tags the resource already has and the tags
     *         this operation would add if it succeeded.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagsForResourceResponse updateTagsForResource(UpdateTagsForResourceRequest updateTagsForResourceRequest)
            throws InsufficientPrivilegesException, OperationInProgressException, TooManyTagsException,
            ResourceNotFoundException, ResourceTypeNotSupportedException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed:
     * <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <p>
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two
     * virtual actions (or both) instead of the API operation name:
     * </p>
     * <dl>
     * <dt>elasticbeanstalk:AddTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the
     * <code>TagsToAdd</code> parameter.
     * </p>
     * </dd>
     * <dt>elasticbeanstalk:RemoveTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the
     * <code>TagsToRemove</code> parameter.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For details about creating a custom user policy, see <a href=
     * "https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies"
     * >Creating a Custom User Policy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTagsForResourceRequest#builder()}
     * </p>
     *
     * @param updateTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTagsForResourceMessage.Builder} to create a
     *        request.
     * @return Result of the UpdateTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws TooManyTagsException
     *         The number of tags in the resource would exceed the number of tags that each resource can have.</p>
     *         <p>
     *         To calculate this, the operation considers both the number of tags the resource already has and the tags
     *         this operation would add if it succeeded.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTagsForResourceResponse updateTagsForResource(
            Consumer<UpdateTagsForResourceRequest.Builder> updateTagsForResourceRequest) throws InsufficientPrivilegesException,
            OperationInProgressException, TooManyTagsException, ResourceNotFoundException, ResourceTypeNotSupportedException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return updateTagsForResource(UpdateTagsForResourceRequest.builder().applyMutation(updateTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether
     * those values are valid.
     * </p>
     * <p>
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option
     * values.
     * </p>
     *
     * @param validateConfigurationSettingsRequest
     *        A list of validation messages for a specified configuration template.
     * @return Result of the ValidateConfigurationSettings operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ValidateConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateConfigurationSettingsResponse validateConfigurationSettings(
            ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether
     * those values are valid.
     * </p>
     * <p>
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option
     * values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateConfigurationSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateConfigurationSettingsRequest#builder()}
     * </p>
     *
     * @param validateConfigurationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link ValidateConfigurationSettingsMessage.Builder} to
     *        create a request. A list of validation messages for a specified configuration template.
     * @return Result of the ValidateConfigurationSettings operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ValidateConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateConfigurationSettingsResponse validateConfigurationSettings(
            Consumer<ValidateConfigurationSettingsRequest.Builder> validateConfigurationSettingsRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {
        return validateConfigurationSettings(ValidateConfigurationSettingsRequest.builder()
                .applyMutation(validateConfigurationSettingsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("elasticbeanstalk");
    }
}
