/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom AMI available to platforms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAmi implements SdkPojo, Serializable, ToCopyableBuilder<CustomAmi.Builder, CustomAmi> {
    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomAmi::virtualizationType)).setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomAmi::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUALIZATION_TYPE_FIELD,
            IMAGE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualizationType;

    private final String imageId;

    private CustomAmi(BuilderImpl builder) {
        this.virtualizationType = builder.virtualizationType;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The type of virtualization used to create the custom AMI.
     * </p>
     * 
     * @return The type of virtualization used to create the custom AMI.
     */
    public String virtualizationType() {
        return virtualizationType;
    }

    /**
     * <p>
     * THe ID of the image used to create the custom AMI.
     * </p>
     * 
     * @return THe ID of the image used to create the custom AMI.
     */
    public String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAmi)) {
            return false;
        }
        CustomAmi other = (CustomAmi) obj;
        return Objects.equals(virtualizationType(), other.virtualizationType()) && Objects.equals(imageId(), other.imageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CustomAmi").add("VirtualizationType", virtualizationType()).add("ImageId", imageId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationType()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAmi, T> g) {
        return obj -> g.apply((CustomAmi) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAmi> {
        /**
         * <p>
         * The type of virtualization used to create the custom AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization used to create the custom AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * THe ID of the image used to create the custom AMI.
         * </p>
         * 
         * @param imageId
         *        THe ID of the image used to create the custom AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);
    }

    static final class BuilderImpl implements Builder {
        private String virtualizationType;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAmi model) {
            virtualizationType(model.virtualizationType);
            imageId(model.imageId);
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public CustomAmi build() {
            return new CustomAmi(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
