/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformBranchesResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ListPlatformBranchesResponse.Builder, ListPlatformBranchesResponse> {
    private static final SdkField<List<PlatformBranchSummary>> PLATFORM_BRANCH_SUMMARY_LIST_FIELD = SdkField
            .<List<PlatformBranchSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListPlatformBranchesResponse::platformBranchSummaryList))
            .setter(setter(Builder::platformBranchSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformBranchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformBranchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPlatformBranchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLATFORM_BRANCH_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<PlatformBranchSummary> platformBranchSummaryList;

    private final String nextToken;

    private ListPlatformBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.platformBranchSummaryList = builder.platformBranchSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PlatformBranchSummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPlatformBranchSummaryList() {
        return platformBranchSummaryList != null && !(platformBranchSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the platform branches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlatformBranchSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the platform branches.
     */
    public List<PlatformBranchSummary> platformBranchSummaryList() {
        return platformBranchSummaryList;
    }

    /**
     * <p>
     * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent
     * request to get the next response page.
     * </p>
     * 
     * @return In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
     *         subsequent request to get the next response page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformBranchSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformBranchesResponse)) {
            return false;
        }
        ListPlatformBranchesResponse other = (ListPlatformBranchesResponse) obj;
        return Objects.equals(platformBranchSummaryList(), other.platformBranchSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPlatformBranchesResponse").add("PlatformBranchSummaryList", platformBranchSummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformBranchSummaryList":
            return Optional.ofNullable(clazz.cast(platformBranchSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformBranchesResponse, T> g) {
        return obj -> g.apply((ListPlatformBranchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformBranchesResponse> {
        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * 
         * @param platformBranchSummaryList
         *        Summary information about the platform branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchSummaryList(Collection<PlatformBranchSummary> platformBranchSummaryList);

        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * 
         * @param platformBranchSummaryList
         *        Summary information about the platform branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchSummaryList(PlatformBranchSummary... platformBranchSummaryList);

        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformBranchSummary>.Builder} avoiding
         * the need to create one manually via {@link List<PlatformBranchSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformBranchSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #platformBranchSummaryList(List<PlatformBranchSummary>)}.
         * 
         * @param platformBranchSummaryList
         *        a consumer that will call methods on {@link List<PlatformBranchSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformBranchSummaryList(List<PlatformBranchSummary>)
         */
        Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder>... platformBranchSummaryList);

        /**
         * <p>
         * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         * subsequent request to get the next response page.
         * </p>
         * 
         * @param nextToken
         *        In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         *        subsequent request to get the next response page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<PlatformBranchSummary> platformBranchSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformBranchesResponse model) {
            super(model);
            platformBranchSummaryList(model.platformBranchSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<PlatformBranchSummary.Builder> getPlatformBranchSummaryList() {
            return platformBranchSummaryList != null ? platformBranchSummaryList.stream().map(PlatformBranchSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformBranchSummaryList(Collection<PlatformBranchSummary> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copy(platformBranchSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(PlatformBranchSummary... platformBranchSummaryList) {
            platformBranchSummaryList(Arrays.asList(platformBranchSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder>... platformBranchSummaryList) {
            platformBranchSummaryList(Stream.of(platformBranchSummaryList)
                    .map(c -> PlatformBranchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformBranchSummaryList(Collection<PlatformBranchSummary.BuilderImpl> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copyFromBuilder(platformBranchSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformBranchesResponse build() {
            return new ListPlatformBranchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
