/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformVersionsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<ListPlatformVersionsRequest.Builder, ListPlatformVersionsRequest> {
    private static final SdkField<List<PlatformFilter>> FILTERS_FIELD = SdkField
            .<List<PlatformFilter>> builder(MarshallingType.LIST)
            .getter(getter(ListPlatformVersionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListPlatformVersionsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPlatformVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<PlatformFilter> filters;

    private final Integer maxRecords;

    private final String nextToken;

    private ListPlatformVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical
     * conjunction (AND) of the separate <code>PlatformFilter</code> terms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical
     *         conjunction (AND) of the separate <code>PlatformFilter</code> terms.
     */
    public List<PlatformFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of platform version values returned in one call.
     * </p>
     * 
     * @return The maximum number of platform version values returned in one call.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All
     * other parameter values must be identical to the ones specified in the initial request.
     * </p>
     * <p>
     * If no <code>NextToken</code> is specified, the first page is retrieved.
     * </p>
     * 
     * @return For a paginated request. Specify a token from a previous response page to retrieve the next response
     *         page. All other parameter values must be identical to the ones specified in the initial request.</p>
     *         <p>
     *         If no <code>NextToken</code> is specified, the first page is retrieved.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsRequest)) {
            return false;
        }
        ListPlatformVersionsRequest other = (ListPlatformVersionsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPlatformVersionsRequest").add("Filters", filters()).add("MaxRecords", maxRecords())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformVersionsRequest, T> g) {
        return obj -> g.apply((ListPlatformVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformVersionsRequest> {
        /**
         * <p>
         * Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical
         * conjunction (AND) of the separate <code>PlatformFilter</code> terms.
         * </p>
         * 
         * @param filters
         *        Criteria for restricting the resulting list of platform versions. The filter is interpreted as a
         *        logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PlatformFilter> filters);

        /**
         * <p>
         * Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical
         * conjunction (AND) of the separate <code>PlatformFilter</code> terms.
         * </p>
         * 
         * @param filters
         *        Criteria for restricting the resulting list of platform versions. The filter is interpreted as a
         *        logical conjunction (AND) of the separate <code>PlatformFilter</code> terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PlatformFilter... filters);

        /**
         * <p>
         * Criteria for restricting the resulting list of platform versions. The filter is interpreted as a logical
         * conjunction (AND) of the separate <code>PlatformFilter</code> terms.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformFilter>.Builder} avoiding the need
         * to create one manually via {@link List<PlatformFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<PlatformFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<PlatformFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<PlatformFilter>)
         */
        Builder filters(Consumer<PlatformFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of platform version values returned in one call.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of platform version values returned in one call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * For a paginated request. Specify a token from a previous response page to retrieve the next response page.
         * All other parameter values must be identical to the ones specified in the initial request.
         * </p>
         * <p>
         * If no <code>NextToken</code> is specified, the first page is retrieved.
         * </p>
         * 
         * @param nextToken
         *        For a paginated request. Specify a token from a previous response page to retrieve the next response
         *        page. All other parameter values must be identical to the ones specified in the initial request.</p>
         *        <p>
         *        If no <code>NextToken</code> is specified, the first page is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private List<PlatformFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsRequest model) {
            super(model);
            filters(model.filters);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<PlatformFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(PlatformFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PlatformFilter> filters) {
            this.filters = PlatformFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PlatformFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PlatformFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> PlatformFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PlatformFilter.BuilderImpl> filters) {
            this.filters = PlatformFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPlatformVersionsRequest build() {
            return new ListPlatformVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
