/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a description of the requested environment info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveEnvironmentInfoResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<RetrieveEnvironmentInfoResponse.Builder, RetrieveEnvironmentInfoResponse> {
    private static final SdkField<List<EnvironmentInfoDescription>> ENVIRONMENT_INFO_FIELD = SdkField
            .<List<EnvironmentInfoDescription>> builder(MarshallingType.LIST)
            .getter(getter(RetrieveEnvironmentInfoResponse::environmentInfo))
            .setter(setter(Builder::environmentInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentInfoDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentInfoDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_INFO_FIELD));

    private final List<EnvironmentInfoDescription> environmentInfo;

    private RetrieveEnvironmentInfoResponse(BuilderImpl builder) {
        super(builder);
        this.environmentInfo = builder.environmentInfo;
    }

    /**
     * Returns true if the EnvironmentInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEnvironmentInfo() {
        return environmentInfo != null && !(environmentInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a>EnvironmentInfoDescription</a> of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <a>EnvironmentInfoDescription</a> of the environment.
     */
    public List<EnvironmentInfoDescription> environmentInfo() {
        return environmentInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoResponse)) {
            return false;
        }
        RetrieveEnvironmentInfoResponse other = (RetrieveEnvironmentInfoResponse) obj;
        return Objects.equals(environmentInfo(), other.environmentInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetrieveEnvironmentInfoResponse").add("EnvironmentInfo", environmentInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentInfo":
            return Optional.ofNullable(clazz.cast(environmentInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveEnvironmentInfoResponse, T> g) {
        return obj -> g.apply((RetrieveEnvironmentInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * 
         * @param environmentInfo
         *        The <a>EnvironmentInfoDescription</a> of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo);

        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * 
         * @param environmentInfo
         *        The <a>EnvironmentInfoDescription</a> of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInfo(EnvironmentInfoDescription... environmentInfo);

        /**
         * <p>
         * The <a>EnvironmentInfoDescription</a> of the environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentInfoDescription>.Builder}
         * avoiding the need to create one manually via {@link List<EnvironmentInfoDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentInfoDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentInfo(List<EnvironmentInfoDescription>)}.
         * 
         * @param environmentInfo
         *        a consumer that will call methods on {@link List<EnvironmentInfoDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentInfo(List<EnvironmentInfoDescription>)
         */
        Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder>... environmentInfo);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<EnvironmentInfoDescription> environmentInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoResponse model) {
            super(model);
            environmentInfo(model.environmentInfo);
        }

        public final Collection<EnvironmentInfoDescription.Builder> getEnvironmentInfo() {
            return environmentInfo != null ? environmentInfo.stream().map(EnvironmentInfoDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(EnvironmentInfoDescription... environmentInfo) {
            environmentInfo(Arrays.asList(environmentInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder>... environmentInfo) {
            environmentInfo(Stream.of(environmentInfo).map(c -> EnvironmentInfoDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentInfo(Collection<EnvironmentInfoDescription.BuilderImpl> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copyFromBuilder(environmentInfo);
        }

        @Override
        public RetrieveEnvironmentInfoResponse build() {
            return new RetrieveEnvironmentInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
