/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<ApplicationDescription> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Application").getter(CreateApplicationResponse.getter(CreateApplicationResponse::application)).setter(CreateApplicationResponse.setter(Builder::application)).constructor(ApplicationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Application").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD));
    private final ApplicationDescription application;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
    }

    public ApplicationDescription application() {
        return this.application;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.application(), other.application());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("Application", (Object)this.application()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private ApplicationDescription application;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.application(model.application);
        }

        public final ApplicationDescription.Builder getApplication() {
            return this.application != null ? this.application.toBuilder() : null;
        }

        @Override
        public final Builder application(ApplicationDescription application) {
            this.application = application;
            return this;
        }

        public final void setApplication(ApplicationDescription.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder application(ApplicationDescription var1);

        default public Builder application(Consumer<ApplicationDescription.Builder> application) {
            return this.application((ApplicationDescription)((ApplicationDescription.Builder)ApplicationDescription.builder().applyMutation(application)).build());
        }
    }
}

