/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to execute a scheduled managed action immediately.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyEnvironmentManagedActionRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<ApplyEnvironmentManagedActionRequest.Builder, ApplyEnvironmentManagedActionRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(ApplyEnvironmentManagedActionRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(ApplyEnvironmentManagedActionRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(ApplyEnvironmentManagedActionRequest::actionId))
            .setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            ENVIRONMENT_ID_FIELD, ACTION_ID_FIELD));

    private final String environmentName;

    private final String environmentId;

    private final String actionId;

    private ApplyEnvironmentManagedActionRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.actionId = builder.actionId;
    }

    /**
     * <p>
     * The name of the target environment.
     * </p>
     * 
     * @return The name of the target environment.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The environment ID of the target environment.
     * </p>
     * 
     * @return The environment ID of the target environment.
     */
    public String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The action ID of the scheduled managed action to execute.
     * </p>
     * 
     * @return The action ID of the scheduled managed action to execute.
     */
    public String actionId() {
        return actionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionRequest)) {
            return false;
        }
        ApplyEnvironmentManagedActionRequest other = (ApplyEnvironmentManagedActionRequest) obj;
        return Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(actionId(), other.actionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplyEnvironmentManagedActionRequest").add("EnvironmentName", environmentName())
                .add("EnvironmentId", environmentId()).add("ActionId", actionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyEnvironmentManagedActionRequest, T> g) {
        return obj -> g.apply((ApplyEnvironmentManagedActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ApplyEnvironmentManagedActionRequest> {
        /**
         * <p>
         * The name of the target environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the target environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The environment ID of the target environment.
         * </p>
         * 
         * @param environmentId
         *        The environment ID of the target environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The action ID of the scheduled managed action to execute.
         * </p>
         * 
         * @param actionId
         *        The action ID of the scheduled managed action to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentName;

        private String environmentId;

        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionRequest model) {
            super(model);
            environmentName(model.environmentName);
            environmentId(model.environmentId);
            actionId(model.actionId);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyEnvironmentManagedActionRequest build() {
            return new ApplyEnvironmentManagedActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
