/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to add or change the operations role used by an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateEnvironmentOperationsRoleRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<AssociateEnvironmentOperationsRoleRequest.Builder, AssociateEnvironmentOperationsRoleRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(AssociateEnvironmentOperationsRoleRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> OPERATIONS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationsRole").getter(getter(AssociateEnvironmentOperationsRoleRequest::operationsRole))
            .setter(setter(Builder::operationsRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            OPERATIONS_ROLE_FIELD));

    private final String environmentName;

    private final String operationsRole;

    private AssociateEnvironmentOperationsRoleRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.operationsRole = builder.operationsRole;
    }

    /**
     * <p>
     * The name of the environment to which to set the operations role.
     * </p>
     * 
     * @return The name of the environment to which to set the operations role.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.
     */
    public String operationsRole() {
        return operationsRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(operationsRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEnvironmentOperationsRoleRequest)) {
            return false;
        }
        AssociateEnvironmentOperationsRoleRequest other = (AssociateEnvironmentOperationsRoleRequest) obj;
        return Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(operationsRole(), other.operationsRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateEnvironmentOperationsRoleRequest").add("EnvironmentName", environmentName())
                .add("OperationsRole", operationsRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "OperationsRole":
            return Optional.ofNullable(clazz.cast(operationsRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateEnvironmentOperationsRoleRequest, T> g) {
        return obj -> g.apply((AssociateEnvironmentOperationsRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateEnvironmentOperationsRoleRequest> {
        /**
         * <p>
         * The name of the environment to which to set the operations role.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment to which to set the operations role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations role.
         * </p>
         * 
         * @param operationsRole
         *        The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's operations
         *        role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsRole(String operationsRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentName;

        private String operationsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEnvironmentOperationsRoleRequest model) {
            super(model);
            environmentName(model.environmentName);
            operationsRole(model.operationsRole);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getOperationsRole() {
            return operationsRole;
        }

        @Override
        public final Builder operationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
            return this;
        }

        public final void setOperationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEnvironmentOperationsRoleRequest build() {
            return new AssociateEnvironmentOperationsRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
