/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the settings for a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationTemplateResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<CreateConfigurationTemplateResponse.Builder, CreateConfigurationTemplateResponse> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolutionStackName").getter(getter(CreateConfigurationTemplateResponse::solutionStackName))
            .setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(CreateConfigurationTemplateResponse::platformArn))
            .setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateConfigurationTemplateResponse::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CreateConfigurationTemplateResponse::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConfigurationTemplateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(CreateConfigurationTemplateResponse::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(CreateConfigurationTemplateResponse::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(CreateConfigurationTemplateResponse::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateUpdated").getter(getter(CreateConfigurationTemplateResponse::dateUpdated))
            .setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationOptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(CreateConfigurationTemplateResponse::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD,
            PLATFORM_ARN_FIELD, APPLICATION_NAME_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_NAME_FIELD,
            DEPLOYMENT_STATUS_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, OPTION_SETTINGS_FIELD));

    private final String solutionStackName;

    private final String platformArn;

    private final String applicationName;

    private final String templateName;

    private final String description;

    private final String environmentName;

    private final String deploymentStatus;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final List<ConfigurationOptionSetting> optionSettings;

    private CreateConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.environmentName = builder.environmentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.optionSettings = builder.optionSettings;
    }

    /**
     * <p>
     * The name of the solution stack this configuration set uses.
     * </p>
     * 
     * @return The name of the solution stack this configuration set uses.
     */
    public String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The ARN of the platform version.
     * </p>
     * 
     * @return The ARN of the platform version.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The name of the application associated with this configuration set.
     * </p>
     * 
     * @return The name of the application associated with this configuration set.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * If not <code>null</code>, the name of the configuration template for this configuration set.
     * </p>
     * 
     * @return If not <code>null</code>, the name of the configuration template for this configuration set.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * Describes this configuration set.
     * </p>
     * 
     * @return Describes this configuration set.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If not <code>null</code>, the name of the environment for this configuration set.
     * </p>
     * 
     * @return If not <code>null</code>, the name of the environment for this configuration set.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
     * indicates the deployment status of this configuration set:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>null</code>: This configuration is not associated with a running environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in
     * the process of deploying.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deployed</code>: This is the configuration that is currently deployed to the associated running
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>: This is a draft configuration that failed to successfully deploy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link ConfigurationDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
     *         indicates the deployment status of this configuration set: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>null</code>: This configuration is not associated with a running environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: This is a draft configuration that is not deployed to the associated environment
     *         but is in the process of deploying.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deployed</code>: This is the configuration that is currently deployed to the associated running
     *         environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code>: This is a draft configuration that failed to successfully deploy.
     *         </p>
     *         </li>
     * @see ConfigurationDeploymentStatus
     */
    public ConfigurationDeploymentStatus deploymentStatus() {
        return ConfigurationDeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
     * indicates the deployment status of this configuration set:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>null</code>: This configuration is not associated with a running environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is in
     * the process of deploying.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deployed</code>: This is the configuration that is currently deployed to the associated running
     * environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>: This is a draft configuration that failed to successfully deploy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link ConfigurationDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
     *         indicates the deployment status of this configuration set: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>null</code>: This configuration is not associated with a running environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: This is a draft configuration that is not deployed to the associated environment
     *         but is in the process of deploying.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deployed</code>: This is the configuration that is currently deployed to the associated running
     *         environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code>: This is a draft configuration that failed to successfully deploy.
     *         </p>
     *         </li>
     * @see ConfigurationDeploymentStatus
     */
    public String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The date (in UTC time) when this configuration set was created.
     * </p>
     * 
     * @return The date (in UTC time) when this configuration set was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date (in UTC time) when this configuration set was last modified.
     * </p>
     * 
     * @return The date (in UTC time) when this configuration set was last modified.
     */
    public Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * Returns true if the OptionSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the configuration options and their values in this configuration set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptionSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the configuration options and their values in this configuration set.
     */
    public List<ConfigurationOptionSetting> optionSettings() {
        return optionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateResponse)) {
            return false;
        }
        CreateConfigurationTemplateResponse other = (CreateConfigurationTemplateResponse) obj;
        return Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformArn(), other.platformArn())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(templateName(), other.templateName()) && Objects.equals(description(), other.description())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && hasOptionSettings() == other.hasOptionSettings() && Objects.equals(optionSettings(), other.optionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationTemplateResponse").add("SolutionStackName", solutionStackName())
                .add("PlatformArn", platformArn()).add("ApplicationName", applicationName()).add("TemplateName", templateName())
                .add("Description", description()).add("EnvironmentName", environmentName())
                .add("DeploymentStatus", deploymentStatusAsString()).add("DateCreated", dateCreated())
                .add("DateUpdated", dateUpdated()).add("OptionSettings", hasOptionSettings() ? optionSettings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((CreateConfigurationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationTemplateResponse> {
        /**
         * <p>
         * The name of the solution stack this configuration set uses.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack this configuration set uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The ARN of the platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The name of the application associated with this configuration set.
         * </p>
         * 
         * @param applicationName
         *        The name of the application associated with this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * If not <code>null</code>, the name of the configuration template for this configuration set.
         * </p>
         * 
         * @param templateName
         *        If not <code>null</code>, the name of the configuration template for this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * Describes this configuration set.
         * </p>
         * 
         * @param description
         *        Describes this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If not <code>null</code>, the name of the environment for this configuration set.
         * </p>
         * 
         * @param environmentName
         *        If not <code>null</code>, the name of the environment for this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
         * indicates the deployment status of this configuration set:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>null</code>: This configuration is not associated with a running environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is
         * in the process of deploying.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deployed</code>: This is the configuration that is currently deployed to the associated running
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>: This is a draft configuration that failed to successfully deploy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        If this configuration set is associated with an environment, the <code>DeploymentStatus</code>
         *        parameter indicates the deployment status of this configuration set: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>null</code>: This configuration is not associated with a running environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: This is a draft configuration that is not deployed to the associated environment
         *        but is in the process of deploying.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deployed</code>: This is the configuration that is currently deployed to the associated running
         *        environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code>: This is a draft configuration that failed to successfully deploy.
         *        </p>
         *        </li>
         * @see ConfigurationDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationDeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * If this configuration set is associated with an environment, the <code>DeploymentStatus</code> parameter
         * indicates the deployment status of this configuration set:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>null</code>: This configuration is not associated with a running environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: This is a draft configuration that is not deployed to the associated environment but is
         * in the process of deploying.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deployed</code>: This is the configuration that is currently deployed to the associated running
         * environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>: This is a draft configuration that failed to successfully deploy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        If this configuration set is associated with an environment, the <code>DeploymentStatus</code>
         *        parameter indicates the deployment status of this configuration set: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>null</code>: This configuration is not associated with a running environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: This is a draft configuration that is not deployed to the associated environment
         *        but is in the process of deploying.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deployed</code>: This is the configuration that is currently deployed to the associated running
         *        environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code>: This is a draft configuration that failed to successfully deploy.
         *        </p>
         *        </li>
         * @see ConfigurationDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationDeploymentStatus
         */
        Builder deploymentStatus(ConfigurationDeploymentStatus deploymentStatus);

        /**
         * <p>
         * The date (in UTC time) when this configuration set was created.
         * </p>
         * 
         * @param dateCreated
         *        The date (in UTC time) when this configuration set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date (in UTC time) when this configuration set was last modified.
         * </p>
         * 
         * @param dateUpdated
         *        The date (in UTC time) when this configuration set was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * A list of the configuration options and their values in this configuration set.
         * </p>
         * 
         * @param optionSettings
         *        A list of the configuration options and their values in this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings);

        /**
         * <p>
         * A list of the configuration options and their values in this configuration set.
         * </p>
         * 
         * @param optionSettings
         *        A list of the configuration options and their values in this configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(ConfigurationOptionSetting... optionSettings);

        /**
         * <p>
         * A list of the configuration options and their values in this configuration set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionSetting>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionSettings(List<ConfigurationOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<ConfigurationOptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<ConfigurationOptionSetting>)
         */
        Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private String solutionStackName;

        private String platformArn;

        private String applicationName;

        private String templateName;

        private String description;

        private String environmentName;

        private String deploymentStatus;

        private Instant dateCreated;

        private Instant dateUpdated;

        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationTemplateResponse model) {
            super(model);
            solutionStackName(model.solutionStackName);
            platformArn(model.platformArn);
            applicationName(model.applicationName);
            templateName(model.templateName);
            description(model.description);
            environmentName(model.environmentName);
            deploymentStatus(model.deploymentStatus);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            optionSettings(model.optionSettings);
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(ConfigurationDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            if (optionSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return optionSettings != null ? optionSettings.stream().map(ConfigurationOptionSetting::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> ConfigurationOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public CreateConfigurationTemplateResponse build() {
            return new CreateConfigurationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
