/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePlatformVersionResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DeletePlatformVersionResponse.Builder, DeletePlatformVersionResponse> {
    private static final SdkField<PlatformSummary> PLATFORM_SUMMARY_FIELD = SdkField
            .<PlatformSummary> builder(MarshallingType.SDK_POJO).memberName("PlatformSummary")
            .getter(getter(DeletePlatformVersionResponse::platformSummary)).setter(setter(Builder::platformSummary))
            .constructor(PlatformSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_FIELD));

    private final PlatformSummary platformSummary;

    private DeletePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummary = builder.platformSummary;
    }

    /**
     * <p>
     * Detailed information about the version of the custom platform.
     * </p>
     * 
     * @return Detailed information about the version of the custom platform.
     */
    public PlatformSummary platformSummary() {
        return platformSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePlatformVersionResponse)) {
            return false;
        }
        DeletePlatformVersionResponse other = (DeletePlatformVersionResponse) obj;
        return Objects.equals(platformSummary(), other.platformSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePlatformVersionResponse").add("PlatformSummary", platformSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformSummary":
            return Optional.ofNullable(clazz.cast(platformSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePlatformVersionResponse, T> g) {
        return obj -> g.apply((DeletePlatformVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePlatformVersionResponse> {
        /**
         * <p>
         * Detailed information about the version of the custom platform.
         * </p>
         * 
         * @param platformSummary
         *        Detailed information about the version of the custom platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummary(PlatformSummary platformSummary);

        /**
         * <p>
         * Detailed information about the version of the custom platform.
         * </p>
         * This is a convenience that creates an instance of the {@link PlatformSummary.Builder} avoiding the need to
         * create one manually via {@link PlatformSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlatformSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #platformSummary(PlatformSummary)}.
         * 
         * @param platformSummary
         *        a consumer that will call methods on {@link PlatformSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformSummary(PlatformSummary)
         */
        default Builder platformSummary(Consumer<PlatformSummary.Builder> platformSummary) {
            return platformSummary(PlatformSummary.builder().applyMutation(platformSummary).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private PlatformSummary platformSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePlatformVersionResponse model) {
            super(model);
            platformSummary(model.platformSummary);
        }

        public final PlatformSummary.Builder getPlatformSummary() {
            return platformSummary != null ? platformSummary.toBuilder() : null;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final void setPlatformSummary(PlatformSummary.BuilderImpl platformSummary) {
            this.platformSummary = platformSummary != null ? platformSummary.build() : null;
        }

        @Override
        public DeletePlatformVersionResponse build() {
            return new DeletePlatformVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
