/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message wrapping a list of application version descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationVersionsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeApplicationVersionsResponse.Builder, DescribeApplicationVersionsResponse> {
    private static final SdkField<List<ApplicationVersionDescription>> APPLICATION_VERSIONS_FIELD = SdkField
            .<List<ApplicationVersionDescription>> builder(MarshallingType.LIST)
            .memberName("ApplicationVersions")
            .getter(getter(DescribeApplicationVersionsResponse::applicationVersions))
            .setter(setter(Builder::applicationVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationVersionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationVersionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeApplicationVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApplicationVersionDescription> applicationVersions;

    private final String nextToken;

    private DescribeApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersions = builder.applicationVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ApplicationVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasApplicationVersions() {
        return applicationVersions != null && !(applicationVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplicationVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
     */
    public List<ApplicationVersionDescription> applicationVersions() {
        return applicationVersions;
    }

    /**
     * <p>
     * In a paginated request, the token that you can pass in a subsequent request to get the next response page.
     * </p>
     * 
     * @return In a paginated request, the token that you can pass in a subsequent request to get the next response
     *         page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationVersions() ? applicationVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionsResponse)) {
            return false;
        }
        DescribeApplicationVersionsResponse other = (DescribeApplicationVersionsResponse) obj;
        return hasApplicationVersions() == other.hasApplicationVersions()
                && Objects.equals(applicationVersions(), other.applicationVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeApplicationVersionsResponse")
                .add("ApplicationVersions", hasApplicationVersions() ? applicationVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersions":
            return Optional.ofNullable(clazz.cast(applicationVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationVersionsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
        /**
         * <p>
         * List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
         * </p>
         * 
         * @param applicationVersions
         *        List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersions(Collection<ApplicationVersionDescription> applicationVersions);

        /**
         * <p>
         * List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
         * </p>
         * 
         * @param applicationVersions
         *        List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersions(ApplicationVersionDescription... applicationVersions);

        /**
         * <p>
         * List of <code>ApplicationVersionDescription</code> objects sorted in order of creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationVersionDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ApplicationVersionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationVersionDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationVersions(List<ApplicationVersionDescription>)}.
         * 
         * @param applicationVersions
         *        a consumer that will call methods on {@link List<ApplicationVersionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersions(List<ApplicationVersionDescription>)
         */
        Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder>... applicationVersions);

        /**
         * <p>
         * In a paginated request, the token that you can pass in a subsequent request to get the next response page.
         * </p>
         * 
         * @param nextToken
         *        In a paginated request, the token that you can pass in a subsequent request to get the next response
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ApplicationVersionDescription> applicationVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationVersionsResponse model) {
            super(model);
            applicationVersions(model.applicationVersions);
            nextToken(model.nextToken);
        }

        public final Collection<ApplicationVersionDescription.Builder> getApplicationVersions() {
            if (applicationVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationVersions != null ? applicationVersions.stream().map(ApplicationVersionDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationVersions(Collection<ApplicationVersionDescription> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copy(applicationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(ApplicationVersionDescription... applicationVersions) {
            applicationVersions(Arrays.asList(applicationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(Consumer<ApplicationVersionDescription.Builder>... applicationVersions) {
            applicationVersions(Stream.of(applicationVersions)
                    .map(c -> ApplicationVersionDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationVersions(Collection<ApplicationVersionDescription.BuilderImpl> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copyFromBuilder(applicationVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeApplicationVersionsResponse build() {
            return new DescribeApplicationVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
