/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing all of the configuration settings for a specified solution stack or configuration template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationSettingsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeConfigurationSettingsRequest.Builder, DescribeConfigurationSettingsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DescribeConfigurationSettingsRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(DescribeConfigurationSettingsRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(DescribeConfigurationSettingsRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD));

    private final String applicationName;

    private final String templateName;

    private final String environmentName;

    private DescribeConfigurationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
    }

    /**
     * <p>
     * The application for the environment or configuration template.
     * </p>
     * 
     * @return The application for the environment or configuration template.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the configuration template to describe.
     * </p>
     * <p>
     * Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both, AWS
     * Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS
     * Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The name of the configuration template to describe.</p>
     *         <p>
     *         Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify
     *         both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not
     *         specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The name of the environment to describe.
     * </p>
     * <p>
     * Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic
     * Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS Elastic
     * Beanstalk returns <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The name of the environment to describe.</p>
     *         <p>
     *         Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic
     *         Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS
     *         Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
     */
    public String environmentName() {
        return environmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsRequest)) {
            return false;
        }
        DescribeConfigurationSettingsRequest other = (DescribeConfigurationSettingsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(environmentName(), other.environmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationSettingsRequest").add("ApplicationName", applicationName())
                .add("TemplateName", templateName()).add("EnvironmentName", environmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSettingsRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationSettingsRequest> {
        /**
         * <p>
         * The application for the environment or configuration template.
         * </p>
         * 
         * @param applicationName
         *        The application for the environment or configuration template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the configuration template to describe.
         * </p>
         * <p>
         * Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you specify both,
         * AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify
         * either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param templateName
         *        The name of the configuration template to describe.</p>
         *        <p>
         *        Conditional: You must specify either this parameter or an EnvironmentName, but not both. If you
         *        specify both, AWS Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you
         *        do not specify either, AWS Elastic Beanstalk returns a <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of the environment to describe.
         * </p>
         * <p>
         * Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS Elastic
         * Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify either, AWS
         * Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment to describe.</p>
         *        <p>
         *        Condition: You must specify either this or a TemplateName, but not both. If you specify both, AWS
         *        Elastic Beanstalk returns an <code>InvalidParameterCombination</code> error. If you do not specify
         *        either, AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String templateName;

        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsRequest model) {
            super(model);
            applicationName(model.applicationName);
            templateName(model.templateName);
            environmentName(model.environmentName);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationSettingsRequest build() {
            return new DescribeConfigurationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
