/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A result message containing a list of completed and failed managed actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentManagedActionHistoryResponse extends ElasticBeanstalkResponse
        implements
        ToCopyableBuilder<DescribeEnvironmentManagedActionHistoryResponse.Builder, DescribeEnvironmentManagedActionHistoryResponse> {
    private static final SdkField<List<ManagedActionHistoryItem>> MANAGED_ACTION_HISTORY_ITEMS_FIELD = SdkField
            .<List<ManagedActionHistoryItem>> builder(MarshallingType.LIST)
            .memberName("ManagedActionHistoryItems")
            .getter(getter(DescribeEnvironmentManagedActionHistoryResponse::managedActionHistoryItems))
            .setter(setter(Builder::managedActionHistoryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedActionHistoryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedActionHistoryItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedActionHistoryItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEnvironmentManagedActionHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANAGED_ACTION_HISTORY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ManagedActionHistoryItem> managedActionHistoryItems;

    private final String nextToken;

    private DescribeEnvironmentManagedActionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.managedActionHistoryItems = builder.managedActionHistoryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ManagedActionHistoryItems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasManagedActionHistoryItems() {
        return managedActionHistoryItems != null && !(managedActionHistoryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of completed and failed managed actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasManagedActionHistoryItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of completed and failed managed actions.
     */
    public List<ManagedActionHistoryItem> managedActionHistoryItems() {
        return managedActionHistoryItems;
    }

    /**
     * <p>
     * A pagination token that you pass to <a>DescribeEnvironmentManagedActionHistory</a> to get the next page of
     * results.
     * </p>
     * 
     * @return A pagination token that you pass to <a>DescribeEnvironmentManagedActionHistory</a> to get the next page
     *         of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedActionHistoryItems() ? managedActionHistoryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionHistoryResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionHistoryResponse other = (DescribeEnvironmentManagedActionHistoryResponse) obj;
        return hasManagedActionHistoryItems() == other.hasManagedActionHistoryItems()
                && Objects.equals(managedActionHistoryItems(), other.managedActionHistoryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEnvironmentManagedActionHistoryResponse")
                .add("ManagedActionHistoryItems", hasManagedActionHistoryItems() ? managedActionHistoryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedActionHistoryItems":
            return Optional.ofNullable(clazz.cast(managedActionHistoryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentManagedActionHistoryResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentManagedActionHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryResponse> {
        /**
         * <p>
         * A list of completed and failed managed actions.
         * </p>
         * 
         * @param managedActionHistoryItems
         *        A list of completed and failed managed actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> managedActionHistoryItems);

        /**
         * <p>
         * A list of completed and failed managed actions.
         * </p>
         * 
         * @param managedActionHistoryItems
         *        A list of completed and failed managed actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedActionHistoryItems(ManagedActionHistoryItem... managedActionHistoryItems);

        /**
         * <p>
         * A list of completed and failed managed actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ManagedActionHistoryItem>.Builder} avoiding
         * the need to create one manually via {@link List<ManagedActionHistoryItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedActionHistoryItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #managedActionHistoryItems(List<ManagedActionHistoryItem>)}.
         * 
         * @param managedActionHistoryItems
         *        a consumer that will call methods on {@link List<ManagedActionHistoryItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedActionHistoryItems(List<ManagedActionHistoryItem>)
         */
        Builder managedActionHistoryItems(Consumer<ManagedActionHistoryItem.Builder>... managedActionHistoryItems);

        /**
         * <p>
         * A pagination token that you pass to <a>DescribeEnvironmentManagedActionHistory</a> to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that you pass to <a>DescribeEnvironmentManagedActionHistory</a> to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ManagedActionHistoryItem> managedActionHistoryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionHistoryResponse model) {
            super(model);
            managedActionHistoryItems(model.managedActionHistoryItems);
            nextToken(model.nextToken);
        }

        public final Collection<ManagedActionHistoryItem.Builder> getManagedActionHistoryItems() {
            if (managedActionHistoryItems instanceof SdkAutoConstructList) {
                return null;
            }
            return managedActionHistoryItems != null ? managedActionHistoryItems.stream()
                    .map(ManagedActionHistoryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copy(managedActionHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActionHistoryItems(ManagedActionHistoryItem... managedActionHistoryItems) {
            managedActionHistoryItems(Arrays.asList(managedActionHistoryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActionHistoryItems(Consumer<ManagedActionHistoryItem.Builder>... managedActionHistoryItems) {
            managedActionHistoryItems(Stream.of(managedActionHistoryItems)
                    .map(c -> ManagedActionHistoryItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setManagedActionHistoryItems(Collection<ManagedActionHistoryItem.BuilderImpl> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copyFromBuilder(managedActionHistoryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEnvironmentManagedActionHistoryResponse build() {
            return new DescribeEnvironmentManagedActionHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
