/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the AWS resources in use by this environment. This data is live.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentResourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentResourceDescription.Builder, EnvironmentResourceDescription> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(EnvironmentResourceDescription::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<AutoScalingGroup>> builder(MarshallingType.LIST)
            .memberName("AutoScalingGroups")
            .getter(getter(EnvironmentResourceDescription::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(EnvironmentResourceDescription::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchConfiguration>> LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<List<LaunchConfiguration>> builder(MarshallingType.LIST)
            .memberName("LaunchConfigurations")
            .getter(getter(EnvironmentResourceDescription::launchConfigurations))
            .setter(setter(Builder::launchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchTemplate>> LAUNCH_TEMPLATES_FIELD = SdkField
            .<List<LaunchTemplate>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplates")
            .getter(getter(EnvironmentResourceDescription::launchTemplates))
            .setter(setter(Builder::launchTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .memberName("LoadBalancers")
            .getter(getter(EnvironmentResourceDescription::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .memberName("Triggers")
            .getter(getter(EnvironmentResourceDescription::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Queue>> QUEUES_FIELD = SdkField
            .<List<Queue>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(EnvironmentResourceDescription::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Queue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Queue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            AUTO_SCALING_GROUPS_FIELD, INSTANCES_FIELD, LAUNCH_CONFIGURATIONS_FIELD, LAUNCH_TEMPLATES_FIELD,
            LOAD_BALANCERS_FIELD, TRIGGERS_FIELD, QUEUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String environmentName;

    private final List<AutoScalingGroup> autoScalingGroups;

    private final List<Instance> instances;

    private final List<LaunchConfiguration> launchConfigurations;

    private final List<LaunchTemplate> launchTemplates;

    private final List<LoadBalancer> loadBalancers;

    private final List<Trigger> triggers;

    private final List<Queue> queues;

    private EnvironmentResourceDescription(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.instances = builder.instances;
        this.launchConfigurations = builder.launchConfigurations;
        this.launchTemplates = builder.launchTemplates;
        this.loadBalancers = builder.loadBalancers;
        this.triggers = builder.triggers;
        this.queues = builder.queues;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * Returns true if the AutoScalingGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoScalingGroups() {
        return autoScalingGroups != null && !(autoScalingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>AutoScalingGroups</code> used by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoScalingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>AutoScalingGroups</code> used by this environment.
     */
    public List<AutoScalingGroup> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 instances used by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon EC2 instances used by this environment.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * Returns true if the LaunchConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchConfigurations() {
        return launchConfigurations != null && !(launchConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Auto Scaling launch configurations in use by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Auto Scaling launch configurations in use by this environment.
     */
    public List<LaunchConfiguration> launchConfigurations() {
        return launchConfigurations;
    }

    /**
     * Returns true if the LaunchTemplates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchTemplates() {
        return launchTemplates != null && !(launchTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 launch templates in use by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon EC2 launch templates in use by this environment.
     */
    public List<LaunchTemplate> launchTemplates() {
        return launchTemplates;
    }

    /**
     * Returns true if the LoadBalancers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The LoadBalancers in use by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The LoadBalancers in use by this environment.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * Returns true if the Triggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>AutoScaling</code> triggers in use by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The <code>AutoScaling</code> triggers in use by this environment.
     */
    public List<Trigger> triggers() {
        return triggers;
    }

    /**
     * Returns true if the Queues property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues used by this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The queues used by this environment.
     */
    public List<Queue> queues() {
        return queues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroups() ? autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchConfigurations() ? launchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplates() ? launchTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription) obj;
        return Objects.equals(environmentName(), other.environmentName())
                && hasAutoScalingGroups() == other.hasAutoScalingGroups()
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances()) && hasLaunchConfigurations() == other.hasLaunchConfigurations()
                && Objects.equals(launchConfigurations(), other.launchConfigurations())
                && hasLaunchTemplates() == other.hasLaunchTemplates()
                && Objects.equals(launchTemplates(), other.launchTemplates()) && hasLoadBalancers() == other.hasLoadBalancers()
                && Objects.equals(loadBalancers(), other.loadBalancers()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers()) && hasQueues() == other.hasQueues()
                && Objects.equals(queues(), other.queues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnvironmentResourceDescription").add("EnvironmentName", environmentName())
                .add("AutoScalingGroups", hasAutoScalingGroups() ? autoScalingGroups() : null)
                .add("Instances", hasInstances() ? instances() : null)
                .add("LaunchConfigurations", hasLaunchConfigurations() ? launchConfigurations() : null)
                .add("LaunchTemplates", hasLaunchTemplates() ? launchTemplates() : null)
                .add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null)
                .add("Triggers", hasTriggers() ? triggers() : null).add("Queues", hasQueues() ? queues() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "AutoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "LaunchConfigurations":
            return Optional.ofNullable(clazz.cast(launchConfigurations()));
        case "LaunchTemplates":
            return Optional.ofNullable(clazz.cast(launchTemplates()));
        case "LoadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "Triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentResourceDescription, T> g) {
        return obj -> g.apply((EnvironmentResourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentResourceDescription> {
        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The <code>AutoScalingGroups</code> used by this environment.
         * </p>
         * 
         * @param autoScalingGroups
         *        The <code>AutoScalingGroups</code> used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups);

        /**
         * <p>
         * The <code>AutoScalingGroups</code> used by this environment.
         * </p>
         * 
         * @param autoScalingGroups
         *        The <code>AutoScalingGroups</code> used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups);

        /**
         * <p>
         * The <code>AutoScalingGroups</code> used by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoScalingGroup>.Builder} avoiding the
         * need to create one manually via {@link List<AutoScalingGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoScalingGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #autoScalingGroups(List<AutoScalingGroup>)}.
         * 
         * @param autoScalingGroups
         *        a consumer that will call methods on {@link List<AutoScalingGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroups(List<AutoScalingGroup>)
         */
        Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups);

        /**
         * <p>
         * The Amazon EC2 instances used by this environment.
         * </p>
         * 
         * @param instances
         *        The Amazon EC2 instances used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The Amazon EC2 instances used by this environment.
         * </p>
         * 
         * @param instances
         *        The Amazon EC2 instances used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The Amazon EC2 instances used by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Instance>.Builder} avoiding the need to
         * create one manually via {@link List<Instance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Instance>.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<Instance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The Auto Scaling launch configurations in use by this environment.
         * </p>
         * 
         * @param launchConfigurations
         *        The Auto Scaling launch configurations in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations);

        /**
         * <p>
         * The Auto Scaling launch configurations in use by this environment.
         * </p>
         * 
         * @param launchConfigurations
         *        The Auto Scaling launch configurations in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(LaunchConfiguration... launchConfigurations);

        /**
         * <p>
         * The Auto Scaling launch configurations in use by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #launchConfigurations(List<LaunchConfiguration>)}.
         * 
         * @param launchConfigurations
         *        a consumer that will call methods on {@link List<LaunchConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfigurations(List<LaunchConfiguration>)
         */
        Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations);

        /**
         * <p>
         * The Amazon EC2 launch templates in use by this environment.
         * </p>
         * 
         * @param launchTemplates
         *        The Amazon EC2 launch templates in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplates(Collection<LaunchTemplate> launchTemplates);

        /**
         * <p>
         * The Amazon EC2 launch templates in use by this environment.
         * </p>
         * 
         * @param launchTemplates
         *        The Amazon EC2 launch templates in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplates(LaunchTemplate... launchTemplates);

        /**
         * <p>
         * The Amazon EC2 launch templates in use by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplate>.Builder} avoiding the need
         * to create one manually via {@link List<LaunchTemplate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplate>.Builder#build()} is called immediately and
         * its result is passed to {@link #launchTemplates(List<LaunchTemplate>)}.
         * 
         * @param launchTemplates
         *        a consumer that will call methods on {@link List<LaunchTemplate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplates(List<LaunchTemplate>)
         */
        Builder launchTemplates(Consumer<LaunchTemplate.Builder>... launchTemplates);

        /**
         * <p>
         * The LoadBalancers in use by this environment.
         * </p>
         * 
         * @param loadBalancers
         *        The LoadBalancers in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * The LoadBalancers in use by this environment.
         * </p>
         * 
         * @param loadBalancers
         *        The LoadBalancers in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * The LoadBalancers in use by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The <code>AutoScaling</code> triggers in use by this environment.
         * </p>
         * 
         * @param triggers
         *        The <code>AutoScaling</code> triggers in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * The <code>AutoScaling</code> triggers in use by this environment.
         * </p>
         * 
         * @param triggers
         *        The <code>AutoScaling</code> triggers in use by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * The <code>AutoScaling</code> triggers in use by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trigger>.Builder} avoiding the need to
         * create one manually via {@link List<Trigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trigger>.Builder#build()} is called immediately and its
         * result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<Trigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        /**
         * <p>
         * The queues used by this environment.
         * </p>
         * 
         * @param queues
         *        The queues used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<Queue> queues);

        /**
         * <p>
         * The queues used by this environment.
         * </p>
         * 
         * @param queues
         *        The queues used by this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Queue... queues);

        /**
         * <p>
         * The queues used by this environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Queue>.Builder} avoiding the need to create
         * one manually via {@link List<Queue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Queue>.Builder#build()} is called immediately and its result
         * is passed to {@link #queues(List<Queue>)}.
         * 
         * @param queues
         *        a consumer that will call methods on {@link List<Queue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queues(List<Queue>)
         */
        Builder queues(Consumer<Queue.Builder>... queues);
    }

    static final class BuilderImpl implements Builder {
        private String environmentName;

        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchConfiguration> launchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplate> launchTemplates = DefaultSdkAutoConstructList.getInstance();

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<Queue> queues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResourceDescription model) {
            environmentName(model.environmentName);
            autoScalingGroups(model.autoScalingGroups);
            instances(model.instances);
            launchConfigurations(model.launchConfigurations);
            launchTemplates(model.launchTemplates);
            loadBalancers(model.loadBalancers);
            triggers(model.triggers);
            queues(model.queues);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<AutoScalingGroup.Builder> getAutoScalingGroups() {
            if (autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroups != null ? autoScalingGroups.stream().map(AutoScalingGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder>... autoScalingGroups) {
            autoScalingGroups(Stream.of(autoScalingGroups).map(c -> AutoScalingGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        public final Collection<Instance.Builder> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            if (launchConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return launchConfigurations != null ? launchConfigurations.stream().map(LaunchConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration... launchConfigurations) {
            launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations) {
            launchConfigurations(Stream.of(launchConfigurations).map(c -> LaunchConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copyFromBuilder(launchConfigurations);
        }

        public final Collection<LaunchTemplate.Builder> getLaunchTemplates() {
            if (launchTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return launchTemplates != null ? launchTemplates.stream().map(LaunchTemplate::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder launchTemplates(Collection<LaunchTemplate> launchTemplates) {
            this.launchTemplates = LaunchTemplateListCopier.copy(launchTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(LaunchTemplate... launchTemplates) {
            launchTemplates(Arrays.asList(launchTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(Consumer<LaunchTemplate.Builder>... launchTemplates) {
            launchTemplates(Stream.of(launchTemplates).map(c -> LaunchTemplate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplates(Collection<LaunchTemplate.BuilderImpl> launchTemplates) {
            this.launchTemplates = LaunchTemplateListCopier.copyFromBuilder(launchTemplates);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            if (loadBalancers instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<Trigger.Builder> getTriggers() {
            if (triggers instanceof SdkAutoConstructList) {
                return null;
            }
            return triggers != null ? triggers.stream().map(Trigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        public final Collection<Queue.Builder> getQueues() {
            if (queues instanceof SdkAutoConstructList) {
                return null;
            }
            return queues != null ? queues.stream().map(Queue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = QueueListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<Queue.Builder>... queues) {
            queues(Stream.of(queues).map(c -> Queue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = QueueListCopier.copyFromBuilder(queues);
        }

        @Override
        public EnvironmentResourceDescription build() {
            return new EnvironmentResourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
