/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The record of an upcoming or in-progress managed action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedAction implements SdkPojo, Serializable, ToCopyableBuilder<ManagedAction.Builder, ManagedAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(ManagedAction::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionDescription").getter(getter(ManagedAction::actionDescription))
            .setter(setter(Builder::actionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(ManagedAction::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ManagedAction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> WINDOW_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("WindowStartTime").getter(getter(ManagedAction::windowStartTime))
            .setter(setter(Builder::windowStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            ACTION_DESCRIPTION_FIELD, ACTION_TYPE_FIELD, STATUS_FIELD, WINDOW_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String actionDescription;

    private final String actionType;

    private final String status;

    private final Instant windowStartTime;

    private ManagedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
        this.windowStartTime = builder.windowStartTime;
    }

    /**
     * <p>
     * A unique identifier for the managed action.
     * </p>
     * 
     * @return A unique identifier for the managed action.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * A description of the managed action.
     * </p>
     * 
     * @return A description of the managed action.
     */
    public String actionDescription() {
        return actionDescription;
    }

    /**
     * <p>
     * The type of managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of managed action.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of managed action.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately with
     * <a>ApplyEnvironmentManagedAction</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately
     *         with <a>ApplyEnvironmentManagedAction</a>.
     * @see ActionStatus
     */
    public ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately with
     * <a>ApplyEnvironmentManagedAction</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately
     *         with <a>ApplyEnvironmentManagedAction</a>.
     * @see ActionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The start time of the maintenance window in which the managed action will execute.
     * </p>
     * 
     * @return The start time of the maintenance window in which the managed action will execute.
     */
    public Instant windowStartTime() {
        return windowStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(windowStartTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAction)) {
            return false;
        }
        ManagedAction other = (ManagedAction) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(actionDescription(), other.actionDescription())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(windowStartTime(), other.windowStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ManagedAction").add("ActionId", actionId()).add("ActionDescription", actionDescription())
                .add("ActionType", actionTypeAsString()).add("Status", statusAsString())
                .add("WindowStartTime", windowStartTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "ActionDescription":
            return Optional.ofNullable(clazz.cast(actionDescription()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "WindowStartTime":
            return Optional.ofNullable(clazz.cast(windowStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedAction, T> g) {
        return obj -> g.apply((ManagedAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedAction> {
        /**
         * <p>
         * A unique identifier for the managed action.
         * </p>
         * 
         * @param actionId
         *        A unique identifier for the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * A description of the managed action.
         * </p>
         * 
         * @param actionDescription
         *        A description of the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDescription(String actionDescription);

        /**
         * <p>
         * The type of managed action.
         * </p>
         * 
         * @param actionType
         *        The type of managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of managed action.
         * </p>
         * 
         * @param actionType
         *        The type of managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately with
         * <a>ApplyEnvironmentManagedAction</a>.
         * </p>
         * 
         * @param status
         *        The status of the managed action. If the action is <code>Scheduled</code>, you can apply it
         *        immediately with <a>ApplyEnvironmentManagedAction</a>.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the managed action. If the action is <code>Scheduled</code>, you can apply it immediately with
         * <a>ApplyEnvironmentManagedAction</a>.
         * </p>
         * 
         * @param status
         *        The status of the managed action. If the action is <code>Scheduled</code>, you can apply it
         *        immediately with <a>ApplyEnvironmentManagedAction</a>.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * <p>
         * The start time of the maintenance window in which the managed action will execute.
         * </p>
         * 
         * @param windowStartTime
         *        The start time of the maintenance window in which the managed action will execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowStartTime(Instant windowStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String actionDescription;

        private String actionType;

        private String status;

        private Instant windowStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAction model) {
            actionId(model.actionId);
            actionDescription(model.actionDescription);
            actionType(model.actionType);
            status(model.status);
            windowStartTime(model.windowStartTime);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getWindowStartTime() {
            return windowStartTime;
        }

        @Override
        public final Builder windowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
            return this;
        }

        public final void setWindowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
        }

        @Override
        public ManagedAction build() {
            return new ManagedAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
