/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AWS Elastic Beanstalk quota information for a single resource type in an AWS account. It reflects the resource's
 * limits for this account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceQuota implements SdkPojo, Serializable, ToCopyableBuilder<ResourceQuota.Builder, ResourceQuota> {
    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Maximum").getter(getter(ResourceQuota::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximum;

    private ResourceQuota(BuilderImpl builder) {
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can use.
     * </p>
     * 
     * @return The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can use.
     */
    public Integer maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceQuota)) {
            return false;
        }
        ResourceQuota other = (ResourceQuota) obj;
        return Objects.equals(maximum(), other.maximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceQuota").add("Maximum", maximum()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceQuota, T> g) {
        return obj -> g.apply((ResourceQuota) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceQuota> {
        /**
         * <p>
         * The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can use.
         * </p>
         * 
         * @param maximum
         *        The maximum number of instances of this Elastic Beanstalk resource type that an AWS account can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceQuota model) {
            maximum(model.maximum);
        }

        public final Integer getMaximum() {
            return maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        public ResourceQuota build() {
            return new ResourceQuota(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
