/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentManagedActionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
    private static final SdkField<List<ManagedAction>> MANAGED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedActions").getter(DescribeEnvironmentManagedActionsResponse.getter(DescribeEnvironmentManagedActionsResponse::managedActions)).setter(DescribeEnvironmentManagedActionsResponse.setter(Builder::managedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_ACTIONS_FIELD));
    private final List<ManagedAction> managedActions;

    private DescribeEnvironmentManagedActionsResponse(BuilderImpl builder) {
        super(builder);
        this.managedActions = builder.managedActions;
    }

    public boolean hasManagedActions() {
        return this.managedActions != null && !(this.managedActions instanceof SdkAutoConstructList);
    }

    public List<ManagedAction> managedActions() {
        return this.managedActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedActions() ? this.managedActions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionsResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionsResponse other = (DescribeEnvironmentManagedActionsResponse)((Object)obj);
        return this.hasManagedActions() == other.hasManagedActions() && Objects.equals(this.managedActions(), other.managedActions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentManagedActionsResponse").add("ManagedActions", this.hasManagedActions() ? this.managedActions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedActions": {
                return Optional.ofNullable(clazz.cast(this.managedActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentManagedActionsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentManagedActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ManagedAction> managedActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionsResponse model) {
            super(model);
            this.managedActions(model.managedActions);
        }

        public final Collection<ManagedAction.Builder> getManagedActions() {
            if (this.managedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedActions != null ? (Collection)this.managedActions.stream().map(ManagedAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedActions(Collection<ManagedAction> managedActions) {
            this.managedActions = ManagedActionsCopier.copy(managedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(ManagedAction ... managedActions) {
            this.managedActions(Arrays.asList(managedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(Consumer<ManagedAction.Builder> ... managedActions) {
            this.managedActions(Stream.of(managedActions).map(c -> (ManagedAction)((ManagedAction.Builder)ManagedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setManagedActions(Collection<ManagedAction.BuilderImpl> managedActions) {
            this.managedActions = ManagedActionsCopier.copyFromBuilder(managedActions);
        }

        @Override
        public DescribeEnvironmentManagedActionsResponse build() {
            return new DescribeEnvironmentManagedActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
        public Builder managedActions(Collection<ManagedAction> var1);

        public Builder managedActions(ManagedAction ... var1);

        public Builder managedActions(Consumer<ManagedAction.Builder> ... var1);
    }
}

