/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryPublisher;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesPublisher;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher;
import software.amazon.awssdk.services.elasticbeanstalk.waiters.ElasticBeanstalkAsyncWaiter;

/**
 * Service client for accessing Elastic Beanstalk asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Elastic Beanstalk</fullname>
 * <p>
 * AWS Elastic Beanstalk makes it easy for you to create, deploy, and manage scalable, fault-tolerant applications
 * running on the Amazon Web Services cloud.
 * </p>
 * <p>
 * For more information about this product, go to the <a href="http://aws.amazon.com/elasticbeanstalk/">AWS Elastic
 * Beanstalk</a> details page. The location of the latest AWS Elastic Beanstalk WSDL is <a
 * href="https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl"
 * >https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl</a>. To install the Software
 * Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools that enable you to
 * access the API, go to <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 * <p>
 * <b>Endpoints</b>
 * </p>
 * <p>
 * For a list of region-specific endpoints that AWS Elastic Beanstalk supports, go to <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region">Regions and Endpoints</a> in
 * the <i>Amazon Web Services Glossary</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ElasticBeanstalkAsyncClient extends SdkClient {
    String SERVICE_NAME = "elasticbeanstalk";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticbeanstalk";

    /**
     * Create a {@link ElasticBeanstalkAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticBeanstalkAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticBeanstalkAsyncClient}.
     */
    static ElasticBeanstalkAsyncClientBuilder builder() {
        return new DefaultElasticBeanstalkAsyncClientBuilder();
    }

    /**
     * <p>
     * Cancels in-progress environment configuration update or application version deployment.
     * </p>
     *
     * @param abortEnvironmentUpdateRequest
     * @return A Java Future containing the result of the AbortEnvironmentUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.AbortEnvironmentUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortEnvironmentUpdateResponse> abortEnvironmentUpdate(
            AbortEnvironmentUpdateRequest abortEnvironmentUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels in-progress environment configuration update or application version deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortEnvironmentUpdateRequest.Builder} avoiding the
     * need to create one manually via {@link AbortEnvironmentUpdateRequest#builder()}
     * </p>
     *
     * @param abortEnvironmentUpdateRequest
     *        A {@link Consumer} that will call methods on {@link AbortEnvironmentUpdateMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AbortEnvironmentUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.AbortEnvironmentUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortEnvironmentUpdateResponse> abortEnvironmentUpdate(
            Consumer<AbortEnvironmentUpdateRequest.Builder> abortEnvironmentUpdateRequest) {
        return abortEnvironmentUpdate(AbortEnvironmentUpdateRequest.builder().applyMutation(abortEnvironmentUpdateRequest)
                .build());
    }

    /**
     * <p>
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is
     * <code>Scheduled</code>. Get the status and action ID of a managed action with
     * <a>DescribeEnvironmentManagedActions</a>.
     * </p>
     *
     * @param applyEnvironmentManagedActionRequest
     *        Request to execute a scheduled managed action immediately.
     * @return A Java Future containing the result of the ApplyEnvironmentManagedAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>ManagedActionInvalidStateException Cannot modify the managed action in its current state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ApplyEnvironmentManagedAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyEnvironmentManagedActionResponse> applyEnvironmentManagedAction(
            ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is
     * <code>Scheduled</code>. Get the status and action ID of a managed action with
     * <a>DescribeEnvironmentManagedActions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyEnvironmentManagedActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyEnvironmentManagedActionRequest#builder()}
     * </p>
     *
     * @param applyEnvironmentManagedActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyEnvironmentManagedActionRequest.Builder} to
     *        create a request. Request to execute a scheduled managed action immediately.
     * @return A Java Future containing the result of the ApplyEnvironmentManagedAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>ManagedActionInvalidStateException Cannot modify the managed action in its current state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ApplyEnvironmentManagedAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyEnvironmentManagedActionResponse> applyEnvironmentManagedAction(
            Consumer<ApplyEnvironmentManagedActionRequest.Builder> applyEnvironmentManagedActionRequest) {
        return applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest.builder()
                .applyMutation(applyEnvironmentManagedActionRequest).build());
    }

    /**
     * <p>
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the
     * associated operations role for permissions to downstream services during subsequent calls acting on this
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     *
     * @param associateEnvironmentOperationsRoleRequest
     *        Request to add or change the operations role used by an environment.
     * @return A Java Future containing the result of the AssociateEnvironmentOperationsRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.AssociateEnvironmentOperationsRole
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnvironmentOperationsRoleResponse> associateEnvironmentOperationsRole(
            AssociateEnvironmentOperationsRoleRequest associateEnvironmentOperationsRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the
     * associated operations role for permissions to downstream services during subsequent calls acting on this
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnvironmentOperationsRoleRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEnvironmentOperationsRoleRequest#builder()}
     * </p>
     *
     * @param associateEnvironmentOperationsRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEnvironmentOperationsRoleMessage.Builder} to
     *        create a request. Request to add or change the operations role used by an environment.
     * @return A Java Future containing the result of the AssociateEnvironmentOperationsRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.AssociateEnvironmentOperationsRole
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateEnvironmentOperationsRoleResponse> associateEnvironmentOperationsRole(
            Consumer<AssociateEnvironmentOperationsRoleRequest.Builder> associateEnvironmentOperationsRoleRequest) {
        return associateEnvironmentOperationsRole(AssociateEnvironmentOperationsRoleRequest.builder()
                .applyMutation(associateEnvironmentOperationsRoleRequest).build());
    }

    /**
     * <p>
     * Checks if the specified CNAME is available.
     * </p>
     *
     * @param checkDnsAvailabilityRequest
     *        Results message indicating whether a CNAME is available.
     * @return A Java Future containing the result of the CheckDNSAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CheckDNSAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDnsAvailabilityResponse> checkDNSAvailability(
            CheckDnsAvailabilityRequest checkDnsAvailabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks if the specified CNAME is available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckDnsAvailabilityRequest.Builder} avoiding the
     * need to create one manually via {@link CheckDnsAvailabilityRequest#builder()}
     * </p>
     *
     * @param checkDnsAvailabilityRequest
     *        A {@link Consumer} that will call methods on {@link CheckDNSAvailabilityMessage.Builder} to create a
     *        request. Results message indicating whether a CNAME is available.
     * @return A Java Future containing the result of the CheckDNSAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CheckDNSAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDnsAvailabilityResponse> checkDNSAvailability(
            Consumer<CheckDnsAvailabilityRequest.Builder> checkDnsAvailabilityRequest) {
        return checkDNSAvailability(CheckDnsAvailabilityRequest.builder().applyMutation(checkDnsAvailabilityRequest).build());
    }

    /**
     * <p>
     * Create or update a group of environments that each run a separate component of a single application. Takes a list
     * of version labels that specify application source bundles for each of the environments to create or update. The
     * name of each environment and other required information must be included in the source bundles in an environment
     * manifest named <code>env.yaml</code>. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose
     * Environments</a> for details.
     * </p>
     *
     * @param composeEnvironmentsRequest
     *        Request to create or update a group of environments.
     * @return A Java Future containing the result of the ComposeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyEnvironmentsException The specified account has reached its limit of environments.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ComposeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ComposeEnvironmentsResponse> composeEnvironments(
            ComposeEnvironmentsRequest composeEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update a group of environments that each run a separate component of a single application. Takes a list
     * of version labels that specify application source bundles for each of the environments to create or update. The
     * name of each environment and other required information must be included in the source bundles in an environment
     * manifest named <code>env.yaml</code>. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose
     * Environments</a> for details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ComposeEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ComposeEnvironmentsRequest#builder()}
     * </p>
     *
     * @param composeEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ComposeEnvironmentsMessage.Builder} to create a
     *        request. Request to create or update a group of environments.
     * @return A Java Future containing the result of the ComposeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyEnvironmentsException The specified account has reached its limit of environments.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ComposeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ComposeEnvironmentsResponse> composeEnvironments(
            Consumer<ComposeEnvironmentsRequest.Builder> composeEnvironmentsRequest) {
        return composeEnvironments(ComposeEnvironmentsRequest.builder().applyMutation(composeEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Creates an application that has one configuration template named <code>default</code> and no application
     * versions.
     * </p>
     *
     * @param createApplicationRequest
     *        Request to create an application.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyApplicationsException The specified account has reached its limit of applications.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application that has one configuration template named <code>default</code> and no application
     * versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationMessage.Builder} to create a request.
     *        Request to create an application.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyApplicationsException The specified account has reached its limit of applications.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an application version for the specified application. You can create an application version from a source
     * bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     * </p>
     * <p>
     * Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.
     * </p>
     * <p>
     * Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.
     * </p>
     * <p>
     * Specify a source bundle in S3 with <code>SourceBundle</code>
     * </p>
     * <p>
     * Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample
     * application.
     * </p>
     * <note>
     * <p>
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that
     * Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an
     * environment from the application version.
     * </p>
     * </note>
     *
     * @param createApplicationVersionRequest
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyApplicationsException The specified account has reached its limit of applications.</li>
     *         <li>TooManyApplicationVersionsException The specified account has reached its limit of application
     *         versions.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>S3LocationNotInServiceRegionException The specified S3 bucket does not belong to the S3 region in
     *         which the service is running. The following regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li></li>
     *         <li>CodeBuildNotInServiceRegionException AWS CodeBuild is not available in the specified region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application version for the specified application. You can create an application version from a source
     * bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     * </p>
     * <p>
     * Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.
     * </p>
     * <p>
     * Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.
     * </p>
     * <p>
     * Specify a source bundle in S3 with <code>SourceBundle</code>
     * </p>
     * <p>
     * Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample
     * application.
     * </p>
     * <note>
     * <p>
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that
     * Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an
     * environment from the application version.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationVersionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyApplicationsException The specified account has reached its limit of applications.</li>
     *         <li>TooManyApplicationVersionsException The specified account has reached its limit of application
     *         versions.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>S3LocationNotInServiceRegionException The specified S3 bucket does not belong to the S3 region in
     *         which the service is running. The following regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li></li>
     *         <li>CodeBuildNotInServiceRegionException AWS CodeBuild is not available in the specified region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            Consumer<CreateApplicationVersionRequest.Builder> createApplicationVersionRequest) {
        return createApplicationVersion(CreateApplicationVersionRequest.builder().applyMutation(createApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You can then use the
     * configuration template to deploy different versions of the application with the same configuration settings.
     * </p>
     * <p>
     * Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always
     * <code>null</code>.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeConfigurationSettings</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListAvailableSolutionStacks</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createConfigurationTemplateRequest
     *        Request to create a configuration template.
     * @return A Java Future containing the result of the CreateConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>TooManyConfigurationTemplatesException The specified account has reached its limit of configuration
     *         templates.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationTemplateResponse> createConfigurationTemplate(
            CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You can then use the
     * configuration template to deploy different versions of the application with the same configuration settings.
     * </p>
     * <p>
     * Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always
     * <code>null</code>.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeConfigurationSettings</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListAvailableSolutionStacks</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationTemplateMessage.Builder} to create
     *        a request. Request to create a configuration template.
     * @return A Java Future containing the result of the CreateConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>TooManyConfigurationTemplatesException The specified account has reached its limit of configuration
     *         templates.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationTemplateResponse> createConfigurationTemplate(
            Consumer<CreateConfigurationTemplateRequest.Builder> createConfigurationTemplateRequest) {
        return createConfigurationTemplate(CreateConfigurationTemplateRequest.builder()
                .applyMutation(createConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyEnvironmentsException The specified account has reached its limit of environments.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyEnvironmentsException The specified account has reached its limit of environments.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Create a new version of your custom platform.
     * </p>
     *
     * @param createPlatformVersionRequest
     *        Request to create a new platform version.
     * @return A Java Future containing the result of the CreatePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>TooManyPlatformsException You have exceeded the maximum number of allowed platforms associated with
     *         the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreatePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePlatformVersionResponse> createPlatformVersion(
            CreatePlatformVersionRequest createPlatformVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new version of your custom platform.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlatformVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlatformVersionRequest#builder()}
     * </p>
     *
     * @param createPlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlatformVersionRequest.Builder} to create a
     *        request. Request to create a new platform version.
     * @return A Java Future containing the result of the CreatePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>TooManyPlatformsException You have exceeded the maximum number of allowed platforms associated with
     *         the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreatePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePlatformVersionResponse> createPlatformVersion(
            Consumer<CreatePlatformVersionRequest.Builder> createPlatformVersionRequest) {
        return createPlatformVersion(CreatePlatformVersionRequest.builder().applyMutation(createPlatformVersionRequest).build());
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     *
     * @param createStorageLocationRequest
     * @return A Java Future containing the result of the CreateStorageLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>S3SubscriptionRequiredException The specified account does not have a subscription to Amazon S3.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateStorageLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStorageLocationResponse> createStorageLocation(
            CreateStorageLocationRequest createStorageLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorageLocationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStorageLocationRequest#builder()}
     * </p>
     *
     * @param createStorageLocationRequest
     *        A {@link Consumer} that will call methods on {@link CreateStorageLocationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStorageLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>S3SubscriptionRequiredException The specified account does not have a subscription to Amazon S3.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateStorageLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStorageLocationResponse> createStorageLocation(
            Consumer<CreateStorageLocationRequest.Builder> createStorageLocationRequest) {
        return createStorageLocation(CreateStorageLocationRequest.builder().applyMutation(createStorageLocationRequest).build());
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     *
     * @return A Java Future containing the result of the CreateStorageLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>S3SubscriptionRequiredException The specified account does not have a subscription to Amazon S3.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.CreateStorageLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStorageLocationResponse> createStorageLocation() {
        return createStorageLocation(CreateStorageLocationRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the specified application along with all associated versions and configurations. The application versions
     * will not be deleted from your Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application that has a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationRequest
     *        Request to delete an application.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application along with all associated versions and configurations. The application versions
     * will not be deleted from your Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application that has a running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationMessage.Builder} to create a request.
     *        Request to delete an application.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version from the specified application.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application version that is associated with a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationVersionRequest
     *        Request to delete an application version.
     * @return A Java Future containing the result of the DeleteApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SourceBundleDeletionException Unable to delete the Amazon S3 source bundle associated with the
     *         application version. The application version was deleted successfully.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>S3LocationNotInServiceRegionException The specified S3 bucket does not belong to the S3 region in
     *         which the service is running. The following regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationVersionResponse> deleteApplicationVersion(
            DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version from the specified application.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application version that is associated with a running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationVersionRequest#builder()}
     * </p>
     *
     * @param deleteApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationVersionMessage.Builder} to create a
     *        request. Request to delete an application version.
     * @return A Java Future containing the result of the DeleteApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SourceBundleDeletionException Unable to delete the Amazon S3 source bundle associated with the
     *         application version. The application version was deleted successfully.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>S3LocationNotInServiceRegionException The specified S3 bucket does not belong to the S3 region in
     *         which the service is running. The following regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationVersionResponse> deleteApplicationVersion(
            Consumer<DeleteApplicationVersionRequest.Builder> deleteApplicationVersionRequest) {
        return deleteApplicationVersion(DeleteApplicationVersionRequest.builder().applyMutation(deleteApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified configuration template.
     * </p>
     * <note>
     * <p>
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You
     * can delete or modify the environment's copy of the template without affecting the running environment.
     * </p>
     * </note>
     *
     * @param deleteConfigurationTemplateRequest
     *        Request to delete a configuration template.
     * @return A Java Future containing the result of the DeleteConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationTemplateResponse> deleteConfigurationTemplate(
            DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configuration template.
     * </p>
     * <note>
     * <p>
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You
     * can delete or modify the environment's copy of the template without affecting the running environment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationTemplateMessage.Builder} to create
     *        a request. Request to delete a configuration template.
     * @return A Java Future containing the result of the DeleteConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationTemplateResponse> deleteConfigurationTemplate(
            Consumer<DeleteConfigurationTemplateRequest.Builder> deleteConfigurationTemplateRequest) {
        return deleteConfigurationTemplate(DeleteConfigurationTemplateRequest.builder()
                .applyMutation(deleteConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the draft configuration associated with the running environment.
     * </p>
     * <p>
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the
     * draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
     * fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in
     * process or has failed. The draft configuration remains in existence until it is deleted with this action.
     * </p>
     *
     * @param deleteEnvironmentConfigurationRequest
     *        Request to delete a draft environment configuration.
     * @return A Java Future containing the result of the DeleteEnvironmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteEnvironmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentConfigurationResponse> deleteEnvironmentConfiguration(
            DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the draft configuration associated with the running environment.
     * </p>
     * <p>
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the
     * draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
     * fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in
     * process or has failed. The draft configuration remains in existence until it is deleted with this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEnvironmentConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentConfigurationMessage.Builder} to
     *        create a request. Request to delete a draft environment configuration.
     * @return A Java Future containing the result of the DeleteEnvironmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeleteEnvironmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentConfigurationResponse> deleteEnvironmentConfiguration(
            Consumer<DeleteEnvironmentConfigurationRequest.Builder> deleteEnvironmentConfigurationRequest) {
        return deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest.builder()
                .applyMutation(deleteEnvironmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version of a custom platform.
     * </p>
     *
     * @param deletePlatformVersionRequest
     * @return A Java Future containing the result of the DeletePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>PlatformVersionStillReferencedException You cannot delete the platform version because there are
     *         still environments running on it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeletePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePlatformVersionResponse> deletePlatformVersion(
            DeletePlatformVersionRequest deletePlatformVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version of a custom platform.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlatformVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePlatformVersionRequest#builder()}
     * </p>
     *
     * @param deletePlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlatformVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>PlatformVersionStillReferencedException You cannot delete the platform version because there are
     *         still environments running on it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DeletePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePlatformVersionResponse> deletePlatformVersion(
            Consumer<DeletePlatformVersionRequest.Builder> deletePlatformVersionRequest) {
        return deletePlatformVersion(DeletePlatformVersionRequest.builder().applyMutation(deletePlatformVersionRequest).build());
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes() {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     *
     * @param describeApplicationVersionsRequest
     *        Request to describe application versions.
     * @return A Java Future containing the result of the DescribeApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationVersionsResponse> describeApplicationVersions(
            DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param describeApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationVersionsMessage.Builder} to create
     *        a request. Request to describe application versions.
     * @return A Java Future containing the result of the DescribeApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationVersionsResponse> describeApplicationVersions(
            Consumer<DescribeApplicationVersionsRequest.Builder> describeApplicationVersionsRequest) {
        return describeApplicationVersions(DescribeApplicationVersionsRequest.builder()
                .applyMutation(describeApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationVersionsResponse> describeApplicationVersions() {
        return describeApplicationVersions(DescribeApplicationVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     *
     * @param describeApplicationsRequest
     *        Request to describe one or more applications.
     * @return A Java Future containing the result of the DescribeApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationsResponse> describeApplications(
            DescribeApplicationsRequest describeApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationsMessage.Builder} to create a
     *        request. Request to describe one or more applications.
     * @return A Java Future containing the result of the DescribeApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationsResponse> describeApplications(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) {
        return describeApplications(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationsResponse> describeApplications() {
        return describeApplications(DescribeApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the configuration options that are used in a particular configuration template or environment, or that
     * a specified solution stack defines. The description includes the values the options, their default values, and an
     * indication of the required action on a running environment if an option value is changed.
     * </p>
     *
     * @param describeConfigurationOptionsRequest
     *        Result message containing a list of application version descriptions.
     * @return A Java Future containing the result of the DescribeConfigurationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationOptionsResponse> describeConfigurationOptions(
            DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the configuration options that are used in a particular configuration template or environment, or that
     * a specified solution stack defines. The description includes the values the options, their default values, and an
     * indication of the required action on a running environment if an option value is changed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationOptionsMessage.Builder} to create
     *        a request. Result message containing a list of application version descriptions.
     * @return A Java Future containing the result of the DescribeConfigurationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationOptionsResponse> describeConfigurationOptions(
            Consumer<DescribeConfigurationOptionsRequest.Builder> describeConfigurationOptionsRequest) {
        return describeConfigurationOptions(DescribeConfigurationOptionsRequest.builder()
                .applyMutation(describeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a description of the settings for the specified configuration set, that is, either a configuration
     * template or the configuration set associated with a running environment.
     * </p>
     * <p>
     * When describing the settings for the configuration set associated with a running environment, it is possible to
     * receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft
     * configuration of an environment that is either in the process of deployment or that failed to deploy.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteEnvironmentConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeConfigurationSettingsRequest
     *        Result message containing all of the configuration settings for a specified solution stack or
     *        configuration template.
     * @return A Java Future containing the result of the DescribeConfigurationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeConfigurationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSettingsResponse> describeConfigurationSettings(
            DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the settings for the specified configuration set, that is, either a configuration
     * template or the configuration set associated with a running environment.
     * </p>
     * <p>
     * When describing the settings for the configuration set associated with a running environment, it is possible to
     * receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft
     * configuration of an environment that is either in the process of deployment or that failed to deploy.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteEnvironmentConfiguration</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationSettingsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationSettingsMessage.Builder} to
     *        create a request. Result message containing all of the configuration settings for a specified solution
     *        stack or configuration template.
     * @return A Java Future containing the result of the DescribeConfigurationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeConfigurationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSettingsResponse> describeConfigurationSettings(
            Consumer<DescribeConfigurationSettingsRequest.Builder> describeConfigurationSettingsRequest) {
        return describeConfigurationSettings(DescribeConfigurationSettingsRequest.builder()
                .applyMutation(describeConfigurationSettingsRequest).build());
    }

    /**
     * <p>
     * Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b>
     * operation is only available with AWS Elastic Beanstalk Enhanced Health.
     * </p>
     *
     * @param describeEnvironmentHealthRequest
     *        See the example below to learn how to create a request body.
     * @return A Java Future containing the result of the DescribeEnvironmentHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException One or more input parameters is not valid. Please correct the input
     *         parameters and try the operation again.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentHealthResponse> describeEnvironmentHealth(
            DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b>
     * operation is only available with AWS Elastic Beanstalk Enhanced Health.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEnvironmentHealthRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentHealthRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentHealthRequest.Builder} to create a
     *        request. See the example below to learn how to create a request body.
     * @return A Java Future containing the result of the DescribeEnvironmentHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException One or more input parameters is not valid. Please correct the input
     *         parameters and try the operation again.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentHealthResponse> describeEnvironmentHealth(
            Consumer<DescribeEnvironmentHealthRequest.Builder> describeEnvironmentHealthRequest) {
        return describeEnvironmentHealth(DescribeEnvironmentHealthRequest.builder()
                .applyMutation(describeEnvironmentHealthRequest).build());
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        Request to list completed and failed managed actions.
     * @return A Java Future containing the result of the DescribeEnvironmentManagedActionHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentManagedActionHistoryResponse> describeEnvironmentManagedActionHistory(
            DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEnvironmentManagedActionHistoryRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} to create a request. Request to list
     *        completed and failed managed actions.
     * @return A Java Future containing the result of the DescribeEnvironmentManagedActionHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentManagedActionHistoryResponse> describeEnvironmentManagedActionHistory(
            Consumer<DescribeEnvironmentManagedActionHistoryRequest.Builder> describeEnvironmentManagedActionHistoryRequest) {
        return describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest.builder()
                .applyMutation(describeEnvironmentManagedActionHistoryRequest).build());
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryPublisher publisher = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryPublisher publisher = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        Request to list completed and failed managed actions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryPublisher describeEnvironmentManagedActionHistoryPaginator(
            DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryPublisher publisher = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEnvironmentManagedActionHistoryPublisher publisher = client.describeEnvironmentManagedActionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentManagedActionHistory(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEnvironmentManagedActionHistoryRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEnvironmentManagedActionHistoryRequest.Builder} to create a request. Request to list
     *        completed and failed managed actions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentManagedActionHistoryPublisher describeEnvironmentManagedActionHistoryPaginator(
            Consumer<DescribeEnvironmentManagedActionHistoryRequest.Builder> describeEnvironmentManagedActionHistoryRequest) {
        return describeEnvironmentManagedActionHistoryPaginator(DescribeEnvironmentManagedActionHistoryRequest.builder()
                .applyMutation(describeEnvironmentManagedActionHistoryRequest).build());
    }

    /**
     * <p>
     * Lists an environment's upcoming and in-progress managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionsRequest
     *        Request to list an environment's upcoming and in-progress managed actions.
     * @return A Java Future containing the result of the DescribeEnvironmentManagedActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentManagedActionsResponse> describeEnvironmentManagedActions(
            DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an environment's upcoming and in-progress managed actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentManagedActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentManagedActionsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentManagedActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentManagedActionsRequest.Builder} to
     *        create a request. Request to list an environment's upcoming and in-progress managed actions.
     * @return A Java Future containing the result of the DescribeEnvironmentManagedActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentManagedActions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentManagedActionsResponse> describeEnvironmentManagedActions(
            Consumer<DescribeEnvironmentManagedActionsRequest.Builder> describeEnvironmentManagedActionsRequest) {
        return describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest.builder()
                .applyMutation(describeEnvironmentManagedActionsRequest).build());
    }

    /**
     * <p>
     * Returns AWS resources for this environment.
     * </p>
     *
     * @param describeEnvironmentResourcesRequest
     *        Request to describe the resources in an environment.
     * @return A Java Future containing the result of the DescribeEnvironmentResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentResourcesResponse> describeEnvironmentResources(
            DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS resources for this environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentResourcesRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentResourcesMessage.Builder} to create
     *        a request. Request to describe the resources in an environment.
     * @return A Java Future containing the result of the DescribeEnvironmentResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironmentResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentResourcesResponse> describeEnvironmentResources(
            Consumer<DescribeEnvironmentResourcesRequest.Builder> describeEnvironmentResourcesRequest) {
        return describeEnvironmentResources(DescribeEnvironmentResourcesRequest.builder()
                .applyMutation(describeEnvironmentResourcesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        Request to describe one or more environments.
     * @return A Java Future containing the result of the DescribeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments(
            DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEnvironmentsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentsMessage.Builder} to create a
     *        request. Request to describe one or more environments.
     * @return A Java Future containing the result of the DescribeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments(
            Consumer<DescribeEnvironmentsRequest.Builder> describeEnvironmentsRequest) {
        return describeEnvironments(DescribeEnvironmentsRequest.builder().applyMutation(describeEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments() {
        return describeEnvironments(DescribeEnvironmentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Request to retrieve a list of events for an environment.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Request to retrieve a list of events for an environment.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation
     * requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting</a>.
     * </p>
     *
     * @param describeInstancesHealthRequest
     *        Parameters for a call to <code>DescribeInstancesHealth</code>.
     * @return A Java Future containing the result of the DescribeInstancesHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException One or more input parameters is not valid. Please correct the input
     *         parameters and try the operation again.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeInstancesHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancesHealthResponse> describeInstancesHealth(
            DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation
     * requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancesHealthRequest#builder()}
     * </p>
     *
     * @param describeInstancesHealthRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancesHealthRequest.Builder} to create a
     *        request. Parameters for a call to <code>DescribeInstancesHealth</code>.
     * @return A Java Future containing the result of the DescribeInstancesHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException One or more input parameters is not valid. Please correct the input
     *         parameters and try the operation again.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribeInstancesHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancesHealthResponse> describeInstancesHealth(
            Consumer<DescribeInstancesHealthRequest.Builder> describeInstancesHealthRequest) {
        return describeInstancesHealth(DescribeInstancesHealthRequest.builder().applyMutation(describeInstancesHealthRequest)
                .build());
    }

    /**
     * <p>
     * Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides
     * summary information about a list of platform versions.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param describePlatformVersionRequest
     * @return A Java Future containing the result of the DescribePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePlatformVersionResponse> describePlatformVersion(
            DescribePlatformVersionRequest describePlatformVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides
     * summary information about a list of platform versions.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlatformVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePlatformVersionRequest#builder()}
     * </p>
     *
     * @param describePlatformVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlatformVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePlatformVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DescribePlatformVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePlatformVersionResponse> describePlatformVersion(
            Consumer<DescribePlatformVersionRequest.Builder> describePlatformVersionRequest) {
        return describePlatformVersion(DescribePlatformVersionRequest.builder().applyMutation(describePlatformVersionRequest)
                .build());
    }

    /**
     * <p>
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the
     * caller's permissions for permissions to downstream services during subsequent calls acting on this environment.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     *
     * @param disassociateEnvironmentOperationsRoleRequest
     *        Request to disassociate the operations role from an environment.
     * @return A Java Future containing the result of the DisassociateEnvironmentOperationsRole operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DisassociateEnvironmentOperationsRole
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEnvironmentOperationsRoleResponse> disassociateEnvironmentOperationsRole(
            DisassociateEnvironmentOperationsRoleRequest disassociateEnvironmentOperationsRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the
     * caller's permissions for permissions to downstream services during subsequent calls acting on this environment.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles</a> in the
     * <i>AWS Elastic Beanstalk Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateEnvironmentOperationsRoleRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateEnvironmentOperationsRoleRequest#builder()}
     * </p>
     *
     * @param disassociateEnvironmentOperationsRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateEnvironmentOperationsRoleMessage.Builder}
     *        to create a request. Request to disassociate the operations role from an environment.
     * @return A Java Future containing the result of the DisassociateEnvironmentOperationsRole operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.DisassociateEnvironmentOperationsRole
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateEnvironmentOperationsRoleResponse> disassociateEnvironmentOperationsRole(
            Consumer<DisassociateEnvironmentOperationsRoleRequest.Builder> disassociateEnvironmentOperationsRoleRequest) {
        return disassociateEnvironmentOperationsRole(DisassociateEnvironmentOperationsRoleRequest.builder()
                .applyMutation(disassociateEnvironmentOperationsRoleRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     *
     * @param listAvailableSolutionStacksRequest
     * @return A Java Future containing the result of the ListAvailableSolutionStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListAvailableSolutionStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableSolutionStacksResponse> listAvailableSolutionStacks(
            ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableSolutionStacksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableSolutionStacksRequest#builder()}
     * </p>
     *
     * @param listAvailableSolutionStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableSolutionStacksRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAvailableSolutionStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListAvailableSolutionStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableSolutionStacksResponse> listAvailableSolutionStacks(
            Consumer<ListAvailableSolutionStacksRequest.Builder> listAvailableSolutionStacksRequest) {
        return listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.builder()
                .applyMutation(listAvailableSolutionStacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     *
     * @return A Java Future containing the result of the ListAvailableSolutionStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListAvailableSolutionStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableSolutionStacksResponse> listAvailableSolutionStacks() {
        return listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return A Java Future containing the result of the ListPlatformBranches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlatformBranchesResponse> listPlatformBranches(
            ListPlatformBranchesRequest listPlatformBranchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformBranchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformBranchesRequest#builder()}
     * </p>
     *
     * @param listPlatformBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformBranchesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPlatformBranches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlatformBranchesResponse> listPlatformBranches(
            Consumer<ListPlatformBranchesRequest.Builder> listPlatformBranchesRequest) {
        return listPlatformBranches(ListPlatformBranchesRequest.builder().applyMutation(listPlatformBranchesRequest).build());
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesPublisher publisher = client.listPlatformBranchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesPublisher publisher = client.listPlatformBranchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesPublisher listPlatformBranchesPaginator(ListPlatformBranchesRequest listPlatformBranchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesPublisher publisher = client.listPlatformBranchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesPublisher publisher = client.listPlatformBranchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformBranchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformBranchesRequest#builder()}
     * </p>
     *
     * @param listPlatformBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformBranchesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformBranches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformBranchesPublisher listPlatformBranchesPaginator(
            Consumer<ListPlatformBranchesRequest.Builder> listPlatformBranchesRequest) {
        return listPlatformBranchesPaginator(ListPlatformBranchesRequest.builder().applyMutation(listPlatformBranchesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformVersionsRequest
     * @return A Java Future containing the result of the ListPlatformVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlatformVersionsResponse> listPlatformVersions(
            ListPlatformVersionsRequest listPlatformVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformVersionsRequest#builder()}
     * </p>
     *
     * @param listPlatformVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPlatformVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlatformVersionsResponse> listPlatformVersions(
            Consumer<ListPlatformVersionsRequest.Builder> listPlatformVersionsRequest) {
        return listPlatformVersions(ListPlatformVersionsRequest.builder().applyMutation(listPlatformVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListPlatformVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPlatformVersionsResponse> listPlatformVersions() {
        return listPlatformVersions(ListPlatformVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsPublisher listPlatformVersionsPaginator() {
        return listPlatformVersionsPaginator(ListPlatformVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsPublisher listPlatformVersionsPaginator(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformVersionsPublisher publisher = client.listPlatformVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformVersions(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlatformVersionsRequest#builder()}
     * </p>
     *
     * @param listPlatformVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlatformVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ElasticBeanstalkServiceException A generic service exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListPlatformVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlatformVersionsPublisher listPlatformVersionsPaginator(
            Consumer<ListPlatformVersionsRequest.Builder> listPlatformVersionsRequest) {
        return listPlatformVersionsPaginator(ListPlatformVersionsRequest.builder().applyMutation(listPlatformVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value
     * pairs.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ResourceNotFoundException A resource doesn't exist for the specified Amazon Resource Name (ARN).</li>
     *         <li>ResourceTypeNotSupportedException The type of the specified Amazon Resource Name (ARN) isn't
     *         supported for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value
     * pairs.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>ResourceNotFoundException A resource doesn't exist for the specified Amazon Resource Name (ARN).</li>
     *         <li>ResourceTypeNotSupportedException The type of the specified Amazon Resource Name (ARN) isn't
     *         supported for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a
     * specified environment and forces a restart.
     * </p>
     *
     * @param rebuildEnvironmentRequest
     * @return A Java Future containing the result of the RebuildEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RebuildEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebuildEnvironmentResponse> rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a
     * specified environment and forces a restart.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebuildEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link RebuildEnvironmentRequest#builder()}
     * </p>
     *
     * @param rebuildEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link RebuildEnvironmentMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RebuildEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RebuildEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RebuildEnvironmentResponse> rebuildEnvironment(
            Consumer<RebuildEnvironmentRequest.Builder> rebuildEnvironmentRequest) {
        return rebuildEnvironment(RebuildEnvironmentRequest.builder().applyMutation(rebuildEnvironmentRequest).build());
    }

    /**
     * <p>
     * Initiates a request to compile the specified type of information of the deployed environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log
     * files of every Amazon EC2 instance in your environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every
     * Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs.
     * </p>
     * <p>
     * Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RetrieveEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param requestEnvironmentInfoRequest
     *        Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage bucket.
     * @return A Java Future containing the result of the RequestEnvironmentInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RequestEnvironmentInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestEnvironmentInfoResponse> requestEnvironmentInfo(
            RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a request to compile the specified type of information of the deployed environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log
     * files of every Amazon EC2 instance in your environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every
     * Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs.
     * </p>
     * <p>
     * Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RetrieveEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestEnvironmentInfoRequest.Builder} avoiding the
     * need to create one manually via {@link RequestEnvironmentInfoRequest#builder()}
     * </p>
     *
     * @param requestEnvironmentInfoRequest
     *        A {@link Consumer} that will call methods on {@link RequestEnvironmentInfoMessage.Builder} to create a
     *        request. Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage
     *        bucket.
     * @return A Java Future containing the result of the RequestEnvironmentInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RequestEnvironmentInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestEnvironmentInfoResponse> requestEnvironmentInfo(
            Consumer<RequestEnvironmentInfoRequest.Builder> requestEnvironmentInfoRequest) {
        return requestEnvironmentInfo(RequestEnvironmentInfoRequest.builder().applyMutation(requestEnvironmentInfoRequest)
                .build());
    }

    /**
     * <p>
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     * </p>
     *
     * @param restartAppServerRequest
     * @return A Java Future containing the result of the RestartAppServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RestartAppServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartAppServerResponse> restartAppServer(RestartAppServerRequest restartAppServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartAppServerRequest.Builder} avoiding the need
     * to create one manually via {@link RestartAppServerRequest#builder()}
     * </p>
     *
     * @param restartAppServerRequest
     *        A {@link Consumer} that will call methods on {@link RestartAppServerMessage.Builder} to create a request.
     * @return A Java Future containing the result of the RestartAppServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RestartAppServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartAppServerResponse> restartAppServer(
            Consumer<RestartAppServerRequest.Builder> restartAppServerRequest) {
        return restartAppServer(RestartAppServerRequest.builder().applyMutation(restartAppServerRequest).build());
    }

    /**
     * <p>
     * Retrieves the compiled information from a <a>RequestEnvironmentInfo</a> request.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RequestEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param retrieveEnvironmentInfoRequest
     *        Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
     * @return A Java Future containing the result of the RetrieveEnvironmentInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RetrieveEnvironmentInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveEnvironmentInfoResponse> retrieveEnvironmentInfo(
            RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the compiled information from a <a>RequestEnvironmentInfo</a> request.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RequestEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveEnvironmentInfoRequest.Builder} avoiding
     * the need to create one manually via {@link RetrieveEnvironmentInfoRequest#builder()}
     * </p>
     *
     * @param retrieveEnvironmentInfoRequest
     *        A {@link Consumer} that will call methods on {@link RetrieveEnvironmentInfoMessage.Builder} to create a
     *        request. Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
     * @return A Java Future containing the result of the RetrieveEnvironmentInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.RetrieveEnvironmentInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveEnvironmentInfoResponse> retrieveEnvironmentInfo(
            Consumer<RetrieveEnvironmentInfoRequest.Builder> retrieveEnvironmentInfoRequest) {
        return retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest.builder().applyMutation(retrieveEnvironmentInfoRequest)
                .build());
    }

    /**
     * <p>
     * Swaps the CNAMEs of two environments.
     * </p>
     *
     * @param swapEnvironmentCnamEsRequest
     *        Swaps the CNAMEs of two environments.
     * @return A Java Future containing the result of the SwapEnvironmentCNAMEs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.SwapEnvironmentCNAMEs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SwapEnvironmentCnamEsResponse> swapEnvironmentCNAMEs(
            SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Swaps the CNAMEs of two environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SwapEnvironmentCnamEsRequest.Builder} avoiding the
     * need to create one manually via {@link SwapEnvironmentCnamEsRequest#builder()}
     * </p>
     *
     * @param swapEnvironmentCnamEsRequest
     *        A {@link Consumer} that will call methods on {@link SwapEnvironmentCNAMEsMessage.Builder} to create a
     *        request. Swaps the CNAMEs of two environments.
     * @return A Java Future containing the result of the SwapEnvironmentCNAMEs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.SwapEnvironmentCNAMEs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SwapEnvironmentCnamEsResponse> swapEnvironmentCNAMEs(
            Consumer<SwapEnvironmentCnamEsRequest.Builder> swapEnvironmentCnamEsRequest) {
        return swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest.builder().applyMutation(swapEnvironmentCnamEsRequest).build());
    }

    /**
     * <p>
     * Terminates the specified environment.
     * </p>
     *
     * @param terminateEnvironmentRequest
     *        Request to terminate an environment.
     * @return A Java Future containing the result of the TerminateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.TerminateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateEnvironmentResponse> terminateEnvironment(
            TerminateEnvironmentRequest terminateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateEnvironmentRequest#builder()}
     * </p>
     *
     * @param terminateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link TerminateEnvironmentMessage.Builder} to create a
     *        request. Request to terminate an environment.
     * @return A Java Future containing the result of the TerminateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.TerminateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateEnvironmentResponse> terminateEnvironment(
            Consumer<TerminateEnvironmentRequest.Builder> terminateEnvironmentRequest) {
        return terminateEnvironment(TerminateEnvironmentRequest.builder().applyMutation(terminateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates the specified application to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * these properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     *        Request to update an application.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * these properties, specify an empty string.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationMessage.Builder} to create a request.
     *        Request to update an application.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Modifies lifecycle settings for an application.
     * </p>
     *
     * @param updateApplicationResourceLifecycleRequest
     * @return A Java Future containing the result of the UpdateApplicationResourceLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplicationResourceLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResourceLifecycleResponse> updateApplicationResourceLifecycle(
            UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies lifecycle settings for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationResourceLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApplicationResourceLifecycleRequest#builder()}
     * </p>
     *
     * @param updateApplicationResourceLifecycleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationResourceLifecycleMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateApplicationResourceLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplicationResourceLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResourceLifecycleResponse> updateApplicationResourceLifecycle(
            Consumer<UpdateApplicationResourceLifecycleRequest.Builder> updateApplicationResourceLifecycleRequest) {
        return updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest.builder()
                .applyMutation(updateApplicationResourceLifecycleRequest).build());
    }

    /**
     * <p>
     * Updates the specified application version to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationVersionRequest
     * @return A Java Future containing the result of the UpdateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationVersionResponse> updateApplicationVersion(
            UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application version to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * properties, specify an empty string.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param updateApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationVersionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationVersionResponse> updateApplicationVersion(
            Consumer<UpdateApplicationVersionRequest.Builder> updateApplicationVersionRequest) {
        return updateApplicationVersion(UpdateApplicationVersionRequest.builder().applyMutation(updateApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified configuration template to have the specified properties or configuration option values.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear
     * such properties, specify an empty string.
     * </p>
     * </note>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConfigurationTemplateRequest
     *        The result message containing the options for the specified solution stack.
     * @return A Java Future containing the result of the UpdateConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationTemplateResponse> updateConfigurationTemplate(
            UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified configuration template to have the specified properties or configuration option values.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear
     * such properties, specify an empty string.
     * </p>
     * </note>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationTemplateMessage.Builder} to create
     *        a request. The result message containing the options for the specified solution stack.
     * @return A Java Future containing the result of the UpdateConfigurationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationTemplateResponse> updateConfigurationTemplate(
            Consumer<UpdateConfigurationTemplateRequest.Builder> updateConfigurationTemplateRequest) {
        return updateConfigurationTemplate(UpdateConfigurationTemplateRequest.builder()
                .applyMutation(updateConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the environment description, deploys a new application version, updates the configuration settings to an
     * entirely new configuration template, or updates select configuration option values in the running environment.
     * </p>
     * <p>
     * Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an
     * <code>InvalidParameterCombination</code> error.
     * </p>
     * <p>
     * When updating the configuration settings to a new template or individual settings, a draft configuration is
     * created and <a>DescribeConfigurationSettings</a> for this environment returns two setting descriptions with
     * different <code>DeploymentStatus</code> values.
     * </p>
     *
     * @param updateEnvironmentRequest
     *        Request to update an environment.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the environment description, deploys a new application version, updates the configuration settings to an
     * entirely new configuration template, or updates select configuration option values in the running environment.
     * </p>
     * <p>
     * Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an
     * <code>InvalidParameterCombination</code> error.
     * </p>
     * <p>
     * When updating the configuration settings to a new template or individual settings, a draft configuration is
     * created and <a>DescribeConfigurationSettings</a> for this environment returns two setting descriptions with
     * different <code>DeploymentStatus</code> values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentMessage.Builder} to create a request.
     *        Request to update an environment.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed:
     * <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <p>
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two
     * virtual actions (or both) instead of the API operation name:
     * </p>
     * <dl>
     * <dt>elasticbeanstalk:AddTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the
     * <code>TagsToAdd</code> parameter.
     * </p>
     * </dd>
     * <dt>elasticbeanstalk:RemoveTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the
     * <code>TagsToRemove</code> parameter.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For details about creating a custom user policy, see <a href=
     * "https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies"
     * >Creating a Custom User Policy</a>.
     * </p>
     *
     * @param updateTagsForResourceRequest
     * @return A Java Future containing the result of the UpdateTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>TooManyTagsException The number of tags in the resource would exceed the number of tags that each
     *         resource can have.</p>
     *         <p>
     *         To calculate this, the operation considers both the number of tags the resource already has and the tags
     *         this operation would add if it succeeded.</li>
     *         <li>ResourceNotFoundException A resource doesn't exist for the specified Amazon Resource Name (ARN).</li>
     *         <li>ResourceTypeNotSupportedException The type of the specified Amazon Resource Name (ARN) isn't
     *         supported for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagsForResourceResponse> updateTagsForResource(
            UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed:
     * <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <p>
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two
     * virtual actions (or both) instead of the API operation name:
     * </p>
     * <dl>
     * <dt>elasticbeanstalk:AddTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the
     * <code>TagsToAdd</code> parameter.
     * </p>
     * </dd>
     * <dt>elasticbeanstalk:RemoveTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the
     * <code>TagsToRemove</code> parameter.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For details about creating a custom user policy, see <a href=
     * "https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies"
     * >Creating a Custom User Policy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTagsForResourceRequest#builder()}
     * </p>
     *
     * @param updateTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTagsForResourceMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>OperationInProgressException Unable to perform the specified operation because another operation that
     *         effects an element in this activity is already in progress.</li>
     *         <li>TooManyTagsException The number of tags in the resource would exceed the number of tags that each
     *         resource can have.</p>
     *         <p>
     *         To calculate this, the operation considers both the number of tags the resource already has and the tags
     *         this operation would add if it succeeded.</li>
     *         <li>ResourceNotFoundException A resource doesn't exist for the specified Amazon Resource Name (ARN).</li>
     *         <li>ResourceTypeNotSupportedException The type of the specified Amazon Resource Name (ARN) isn't
     *         supported for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.UpdateTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagsForResourceResponse> updateTagsForResource(
            Consumer<UpdateTagsForResourceRequest.Builder> updateTagsForResourceRequest) {
        return updateTagsForResource(UpdateTagsForResourceRequest.builder().applyMutation(updateTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether
     * those values are valid.
     * </p>
     * <p>
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option
     * values.
     * </p>
     *
     * @param validateConfigurationSettingsRequest
     *        A list of validation messages for a specified configuration template.
     * @return A Java Future containing the result of the ValidateConfigurationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ValidateConfigurationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateConfigurationSettingsResponse> validateConfigurationSettings(
            ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether
     * those values are valid.
     * </p>
     * <p>
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option
     * values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateConfigurationSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateConfigurationSettingsRequest#builder()}
     * </p>
     *
     * @param validateConfigurationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link ValidateConfigurationSettingsMessage.Builder} to
     *        create a request. A list of validation messages for a specified configuration template.
     * @return A Java Future containing the result of the ValidateConfigurationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPrivilegesException The specified account does not have sufficient privileges for one or
     *         more AWS services.</li>
     *         <li>TooManyBucketsException The specified account has reached its limit of Amazon S3 buckets.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticBeanstalkException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ElasticBeanstalkAsyncClient.ValidateConfigurationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateConfigurationSettingsResponse> validateConfigurationSettings(
            Consumer<ValidateConfigurationSettingsRequest.Builder> validateConfigurationSettingsRequest) {
        return validateConfigurationSettings(ValidateConfigurationSettingsRequest.builder()
                .applyMutation(validateConfigurationSettingsRequest).build());
    }

    /**
     * Create an instance of {@link ElasticBeanstalkAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElasticBeanstalkAsyncWaiter}
     */
    default ElasticBeanstalkAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
