/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a platform version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformSummary implements SdkPojo, Serializable, ToCopyableBuilder<PlatformSummary.Builder, PlatformSummary> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(PlatformSummary::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformOwner").getter(getter(PlatformSummary::platformOwner)).setter(setter(Builder::platformOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()).build();

    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformStatus").getter(getter(PlatformSummary::platformStatusAsString))
            .setter(setter(Builder::platformStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()).build();

    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformCategory").getter(getter(PlatformSummary::platformCategory))
            .setter(setter(Builder::platformCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystemName").getter(getter(PlatformSummary::operatingSystemName))
            .setter(setter(Builder::operatingSystemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystemVersion").getter(getter(PlatformSummary::operatingSystemVersion))
            .setter(setter(Builder::operatingSystemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedTierList")
            .getter(getter(PlatformSummary::supportedTierList))
            .setter(setter(Builder::supportedTierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedAddonList")
            .getter(getter(PlatformSummary::supportedAddonList))
            .setter(setter(Builder::supportedAddonList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformLifecycleState").getter(getter(PlatformSummary::platformLifecycleState))
            .setter(setter(Builder::platformLifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformLifecycleState").build())
            .build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(PlatformSummary::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> PLATFORM_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformBranchName").getter(getter(PlatformSummary::platformBranchName))
            .setter(setter(Builder::platformBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchName").build())
            .build();

    private static final SdkField<String> PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlatformBranchLifecycleState")
            .getter(getter(PlatformSummary::platformBranchLifecycleState))
            .setter(setter(Builder::platformBranchLifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchLifecycleState")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD,
            PLATFORM_OWNER_FIELD, PLATFORM_STATUS_FIELD, PLATFORM_CATEGORY_FIELD, OPERATING_SYSTEM_NAME_FIELD,
            OPERATING_SYSTEM_VERSION_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD,
            PLATFORM_LIFECYCLE_STATE_FIELD, PLATFORM_VERSION_FIELD, PLATFORM_BRANCH_NAME_FIELD,
            PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformArn;

    private final String platformOwner;

    private final String platformStatus;

    private final String platformCategory;

    private final String operatingSystemName;

    private final String operatingSystemVersion;

    private final List<String> supportedTierList;

    private final List<String> supportedAddonList;

    private final String platformLifecycleState;

    private final String platformVersion;

    private final String platformBranchName;

    private final String platformBranchLifecycleState;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
        this.platformLifecycleState = builder.platformLifecycleState;
        this.platformVersion = builder.platformVersion;
        this.platformBranchName = builder.platformBranchName;
        this.platformBranchLifecycleState = builder.platformBranchLifecycleState;
    }

    /**
     * <p>
     * The ARN of the platform version.
     * </p>
     * 
     * @return The ARN of the platform version.
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The AWS account ID of the person who created the platform version.
     * </p>
     * 
     * @return The AWS account ID of the person who created the platform version.
     */
    public final String platformOwner() {
        return platformOwner;
    }

    /**
     * <p>
     * The status of the platform version. You can create an environment from the platform version once it is ready.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform version. You can create an environment from the platform version once it is
     *         ready.
     * @see PlatformStatus
     */
    public final PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(platformStatus);
    }

    /**
     * <p>
     * The status of the platform version. You can create an environment from the platform version once it is ready.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform version. You can create an environment from the platform version once it is
     *         ready.
     * @see PlatformStatus
     */
    public final String platformStatusAsString() {
        return platformStatus;
    }

    /**
     * <p>
     * The category of platform version.
     * </p>
     * 
     * @return The category of platform version.
     */
    public final String platformCategory() {
        return platformCategory;
    }

    /**
     * <p>
     * The operating system used by the platform version.
     * </p>
     * 
     * @return The operating system used by the platform version.
     */
    public final String operatingSystemName() {
        return operatingSystemName;
    }

    /**
     * <p>
     * The version of the operating system used by the platform version.
     * </p>
     * 
     * @return The version of the operating system used by the platform version.
     */
    public final String operatingSystemVersion() {
        return operatingSystemVersion;
    }

    /**
     * Returns true if the SupportedTierList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedTierList() {
        return supportedTierList != null && !(supportedTierList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tiers in which the platform version runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedTierList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tiers in which the platform version runs.
     */
    public final List<String> supportedTierList() {
        return supportedTierList;
    }

    /**
     * Returns true if the SupportedAddonList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedAddonList() {
        return supportedAddonList != null && !(supportedAddonList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additions associated with the platform version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedAddonList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The additions associated with the platform version.
     */
    public final List<String> supportedAddonList() {
        return supportedAddonList;
    }

    /**
     * <p>
     * The state of the platform version in its lifecycle.
     * </p>
     * <p>
     * Possible values: <code>recommended</code> | empty
     * </p>
     * <p>
     * If an empty value is returned, the platform version is supported but isn't the recommended one for its branch.
     * </p>
     * 
     * @return The state of the platform version in its lifecycle.</p>
     *         <p>
     *         Possible values: <code>recommended</code> | empty
     *         </p>
     *         <p>
     *         If an empty value is returned, the platform version is supported but isn't the recommended one for its
     *         branch.
     */
    public final String platformLifecycleState() {
        return platformLifecycleState;
    }

    /**
     * <p>
     * The version string of the platform version.
     * </p>
     * 
     * @return The version string of the platform version.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The platform branch to which the platform version belongs.
     * </p>
     * 
     * @return The platform branch to which the platform version belongs.
     */
    public final String platformBranchName() {
        return platformBranchName;
    }

    /**
     * <p>
     * The state of the platform version's branch in its lifecycle.
     * </p>
     * <p>
     * Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code>
     * </p>
     * 
     * @return The state of the platform version's branch in its lifecycle.</p>
     *         <p>
     *         Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
     *         <code>retired</code>
     */
    public final String platformBranchLifecycleState() {
        return platformBranchLifecycleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTierList() ? supportedTierList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedAddonList() ? supportedAddonList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformLifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(platformBranchLifecycleState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary) obj;
        return Objects.equals(platformArn(), other.platformArn()) && Objects.equals(platformOwner(), other.platformOwner())
                && Objects.equals(platformStatusAsString(), other.platformStatusAsString())
                && Objects.equals(platformCategory(), other.platformCategory())
                && Objects.equals(operatingSystemName(), other.operatingSystemName())
                && Objects.equals(operatingSystemVersion(), other.operatingSystemVersion())
                && hasSupportedTierList() == other.hasSupportedTierList()
                && Objects.equals(supportedTierList(), other.supportedTierList())
                && hasSupportedAddonList() == other.hasSupportedAddonList()
                && Objects.equals(supportedAddonList(), other.supportedAddonList())
                && Objects.equals(platformLifecycleState(), other.platformLifecycleState())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(platformBranchName(), other.platformBranchName())
                && Objects.equals(platformBranchLifecycleState(), other.platformBranchLifecycleState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlatformSummary").add("PlatformArn", platformArn()).add("PlatformOwner", platformOwner())
                .add("PlatformStatus", platformStatusAsString()).add("PlatformCategory", platformCategory())
                .add("OperatingSystemName", operatingSystemName()).add("OperatingSystemVersion", operatingSystemVersion())
                .add("SupportedTierList", hasSupportedTierList() ? supportedTierList() : null)
                .add("SupportedAddonList", hasSupportedAddonList() ? supportedAddonList() : null)
                .add("PlatformLifecycleState", platformLifecycleState()).add("PlatformVersion", platformVersion())
                .add("PlatformBranchName", platformBranchName())
                .add("PlatformBranchLifecycleState", platformBranchLifecycleState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "PlatformOwner":
            return Optional.ofNullable(clazz.cast(platformOwner()));
        case "PlatformStatus":
            return Optional.ofNullable(clazz.cast(platformStatusAsString()));
        case "PlatformCategory":
            return Optional.ofNullable(clazz.cast(platformCategory()));
        case "OperatingSystemName":
            return Optional.ofNullable(clazz.cast(operatingSystemName()));
        case "OperatingSystemVersion":
            return Optional.ofNullable(clazz.cast(operatingSystemVersion()));
        case "SupportedTierList":
            return Optional.ofNullable(clazz.cast(supportedTierList()));
        case "SupportedAddonList":
            return Optional.ofNullable(clazz.cast(supportedAddonList()));
        case "PlatformLifecycleState":
            return Optional.ofNullable(clazz.cast(platformLifecycleState()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "PlatformBranchName":
            return Optional.ofNullable(clazz.cast(platformBranchName()));
        case "PlatformBranchLifecycleState":
            return Optional.ofNullable(clazz.cast(platformBranchLifecycleState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformSummary, T> g) {
        return obj -> g.apply((PlatformSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformSummary> {
        /**
         * <p>
         * The ARN of the platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The AWS account ID of the person who created the platform version.
         * </p>
         * 
         * @param platformOwner
         *        The AWS account ID of the person who created the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformOwner(String platformOwner);

        /**
         * <p>
         * The status of the platform version. You can create an environment from the platform version once it is ready.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform version. You can create an environment from the platform version once it is
         *        ready.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(String platformStatus);

        /**
         * <p>
         * The status of the platform version. You can create an environment from the platform version once it is ready.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform version. You can create an environment from the platform version once it is
         *        ready.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(PlatformStatus platformStatus);

        /**
         * <p>
         * The category of platform version.
         * </p>
         * 
         * @param platformCategory
         *        The category of platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformCategory(String platformCategory);

        /**
         * <p>
         * The operating system used by the platform version.
         * </p>
         * 
         * @param operatingSystemName
         *        The operating system used by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemName(String operatingSystemName);

        /**
         * <p>
         * The version of the operating system used by the platform version.
         * </p>
         * 
         * @param operatingSystemVersion
         *        The version of the operating system used by the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemVersion(String operatingSystemVersion);

        /**
         * <p>
         * The tiers in which the platform version runs.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers in which the platform version runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(Collection<String> supportedTierList);

        /**
         * <p>
         * The tiers in which the platform version runs.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers in which the platform version runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(String... supportedTierList);

        /**
         * <p>
         * The additions associated with the platform version.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions associated with the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(Collection<String> supportedAddonList);

        /**
         * <p>
         * The additions associated with the platform version.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions associated with the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(String... supportedAddonList);

        /**
         * <p>
         * The state of the platform version in its lifecycle.
         * </p>
         * <p>
         * Possible values: <code>recommended</code> | empty
         * </p>
         * <p>
         * If an empty value is returned, the platform version is supported but isn't the recommended one for its
         * branch.
         * </p>
         * 
         * @param platformLifecycleState
         *        The state of the platform version in its lifecycle.</p>
         *        <p>
         *        Possible values: <code>recommended</code> | empty
         *        </p>
         *        <p>
         *        If an empty value is returned, the platform version is supported but isn't the recommended one for its
         *        branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformLifecycleState(String platformLifecycleState);

        /**
         * <p>
         * The version string of the platform version.
         * </p>
         * 
         * @param platformVersion
         *        The version string of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The platform branch to which the platform version belongs.
         * </p>
         * 
         * @param platformBranchName
         *        The platform branch to which the platform version belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchName(String platformBranchName);

        /**
         * <p>
         * The state of the platform version's branch in its lifecycle.
         * </p>
         * <p>
         * Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code>
         * </p>
         * 
         * @param platformBranchLifecycleState
         *        The state of the platform version's branch in its lifecycle.</p>
         *        <p>
         *        Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         *        <code>retired</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchLifecycleState(String platformBranchLifecycleState);
    }

    static final class BuilderImpl implements Builder {
        private String platformArn;

        private String platformOwner;

        private String platformStatus;

        private String platformCategory;

        private String operatingSystemName;

        private String operatingSystemVersion;

        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();

        private String platformLifecycleState;

        private String platformVersion;

        private String platformBranchName;

        private String platformBranchLifecycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            platformArn(model.platformArn);
            platformOwner(model.platformOwner);
            platformStatus(model.platformStatus);
            platformCategory(model.platformCategory);
            operatingSystemName(model.operatingSystemName);
            operatingSystemVersion(model.operatingSystemVersion);
            supportedTierList(model.supportedTierList);
            supportedAddonList(model.supportedAddonList);
            platformLifecycleState(model.platformLifecycleState);
            platformVersion(model.platformVersion);
            platformBranchName(model.platformBranchName);
            platformBranchLifecycleState(model.platformBranchLifecycleState);
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformStatus() {
            return platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final String getPlatformCategory() {
            return platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getOperatingSystemName() {
            return operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<String> getSupportedTierList() {
            if (supportedTierList instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String... supportedTierList) {
            supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            if (supportedAddonList instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String... supportedAddonList) {
            supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        public final String getPlatformLifecycleState() {
            return platformLifecycleState;
        }

        @Override
        public final Builder platformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
            return this;
        }

        public final void setPlatformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getPlatformBranchName() {
            return platformBranchName;
        }

        @Override
        public final Builder platformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
            return this;
        }

        public final void setPlatformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
        }

        public final String getPlatformBranchLifecycleState() {
            return platformBranchLifecycleState;
        }

        @Override
        public final Builder platformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
            return this;
        }

        public final void setPlatformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
        }

        @Override
        public PlatformSummary build() {
            return new PlatformSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
