/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a list of environment resource descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentResourcesResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeEnvironmentResourcesResponse.Builder, DescribeEnvironmentResourcesResponse> {
    private static final SdkField<EnvironmentResourceDescription> ENVIRONMENT_RESOURCES_FIELD = SdkField
            .<EnvironmentResourceDescription> builder(MarshallingType.SDK_POJO).memberName("EnvironmentResources")
            .getter(getter(DescribeEnvironmentResourcesResponse::environmentResources))
            .setter(setter(Builder::environmentResources)).constructor(EnvironmentResourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_RESOURCES_FIELD));

    private final EnvironmentResourceDescription environmentResources;

    private DescribeEnvironmentResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.environmentResources = builder.environmentResources;
    }

    /**
     * <p>
     * A list of <a>EnvironmentResourceDescription</a>.
     * </p>
     * 
     * @return A list of <a>EnvironmentResourceDescription</a>.
     */
    public final EnvironmentResourceDescription environmentResources() {
        return environmentResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentResourcesResponse)) {
            return false;
        }
        DescribeEnvironmentResourcesResponse other = (DescribeEnvironmentResourcesResponse) obj;
        return Objects.equals(environmentResources(), other.environmentResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentResourcesResponse").add("EnvironmentResources", environmentResources())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentResources":
            return Optional.ofNullable(clazz.cast(environmentResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentResourcesResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentResourcesResponse> {
        /**
         * <p>
         * A list of <a>EnvironmentResourceDescription</a>.
         * </p>
         * 
         * @param environmentResources
         *        A list of <a>EnvironmentResourceDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentResources(EnvironmentResourceDescription environmentResources);

        /**
         * <p>
         * A list of <a>EnvironmentResourceDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentResourceDescription.Builder} avoiding
         * the need to create one manually via {@link EnvironmentResourceDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentResourceDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentResources(EnvironmentResourceDescription)}.
         * 
         * @param environmentResources
         *        a consumer that will call methods on {@link EnvironmentResourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentResources(EnvironmentResourceDescription)
         */
        default Builder environmentResources(Consumer<EnvironmentResourceDescription.Builder> environmentResources) {
            return environmentResources(EnvironmentResourceDescription.builder().applyMutation(environmentResources).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private EnvironmentResourceDescription environmentResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentResourcesResponse model) {
            super(model);
            environmentResources(model.environmentResources);
        }

        public final EnvironmentResourceDescription.Builder getEnvironmentResources() {
            return environmentResources != null ? environmentResources.toBuilder() : null;
        }

        @Override
        public final Builder environmentResources(EnvironmentResourceDescription environmentResources) {
            this.environmentResources = environmentResources;
            return this;
        }

        public final void setEnvironmentResources(EnvironmentResourceDescription.BuilderImpl environmentResources) {
            this.environmentResources = environmentResources != null ? environmentResources.build() : null;
        }

        @Override
        public DescribeEnvironmentResourcesResponse build() {
            return new DescribeEnvironmentResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
