/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result message containing a list of managed actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentManagedActionsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeEnvironmentManagedActionsResponse.Builder, DescribeEnvironmentManagedActionsResponse> {
    private static final SdkField<List<ManagedAction>> MANAGED_ACTIONS_FIELD = SdkField
            .<List<ManagedAction>> builder(MarshallingType.LIST)
            .memberName("ManagedActions")
            .getter(getter(DescribeEnvironmentManagedActionsResponse::managedActions))
            .setter(setter(Builder::managedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_ACTIONS_FIELD));

    private final List<ManagedAction> managedActions;

    private DescribeEnvironmentManagedActionsResponse(BuilderImpl builder) {
        super(builder);
        this.managedActions = builder.managedActions;
    }

    /**
     * Returns true if the ManagedActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasManagedActions() {
        return managedActions != null && !(managedActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of upcoming and in-progress managed actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasManagedActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of upcoming and in-progress managed actions.
     */
    public final List<ManagedAction> managedActions() {
        return managedActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedActions() ? managedActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionsResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionsResponse other = (DescribeEnvironmentManagedActionsResponse) obj;
        return hasManagedActions() == other.hasManagedActions() && Objects.equals(managedActions(), other.managedActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentManagedActionsResponse")
                .add("ManagedActions", hasManagedActions() ? managedActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedActions":
            return Optional.ofNullable(clazz.cast(managedActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentManagedActionsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentManagedActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
        /**
         * <p>
         * A list of upcoming and in-progress managed actions.
         * </p>
         * 
         * @param managedActions
         *        A list of upcoming and in-progress managed actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedActions(Collection<ManagedAction> managedActions);

        /**
         * <p>
         * A list of upcoming and in-progress managed actions.
         * </p>
         * 
         * @param managedActions
         *        A list of upcoming and in-progress managed actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedActions(ManagedAction... managedActions);

        /**
         * <p>
         * A list of upcoming and in-progress managed actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ManagedAction>.Builder} avoiding the need
         * to create one manually via {@link List<ManagedAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #managedActions(List<ManagedAction>)}.
         * 
         * @param managedActions
         *        a consumer that will call methods on {@link List<ManagedAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedActions(List<ManagedAction>)
         */
        Builder managedActions(Consumer<ManagedAction.Builder>... managedActions);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ManagedAction> managedActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionsResponse model) {
            super(model);
            managedActions(model.managedActions);
        }

        public final List<ManagedAction.Builder> getManagedActions() {
            List<ManagedAction.Builder> result = ManagedActionsCopier.copyToBuilder(this.managedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder managedActions(Collection<ManagedAction> managedActions) {
            this.managedActions = ManagedActionsCopier.copy(managedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(ManagedAction... managedActions) {
            managedActions(Arrays.asList(managedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(Consumer<ManagedAction.Builder>... managedActions) {
            managedActions(Stream.of(managedActions).map(c -> ManagedAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setManagedActions(Collection<ManagedAction.BuilderImpl> managedActions) {
            this.managedActions = ManagedActionsCopier.copyFromBuilder(managedActions);
        }

        @Override
        public DescribeEnvironmentManagedActionsResponse build() {
            return new DescribeEnvironmentManagedActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
