/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the settings for a specified configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationOptionsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeConfigurationOptionsResponse.Builder, DescribeConfigurationOptionsResponse> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolutionStackName").getter(getter(DescribeConfigurationOptionsResponse::solutionStackName))
            .setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(DescribeConfigurationOptionsResponse::platformArn))
            .setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<List<ConfigurationOptionDescription>> OPTIONS_FIELD = SdkField
            .<List<ConfigurationOptionDescription>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(DescribeConfigurationOptionsResponse::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD,
            PLATFORM_ARN_FIELD, OPTIONS_FIELD));

    private final String solutionStackName;

    private final String platformArn;

    private final List<ConfigurationOptionDescription> options;

    private DescribeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    /**
     * <p>
     * The name of the solution stack these configuration options belong to.
     * </p>
     * 
     * @return The name of the solution stack these configuration options belong to.
     */
    public final String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The ARN of the platform version.
     * </p>
     * 
     * @return The ARN of the platform version.
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * Returns true if the Options property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>ConfigurationOptionDescription</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>ConfigurationOptionDescription</a>.
     */
    public final List<ConfigurationOptionDescription> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeConfigurationOptionsResponse other = (DescribeConfigurationOptionsResponse) obj;
        return Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformArn(), other.platformArn()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationOptionsResponse").add("SolutionStackName", solutionStackName())
                .add("PlatformArn", platformArn()).add("Options", hasOptions() ? options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationOptionsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
        /**
         * <p>
         * The name of the solution stack these configuration options belong to.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack these configuration options belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The ARN of the platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * A list of <a>ConfigurationOptionDescription</a>.
         * </p>
         * 
         * @param options
         *        A list of <a>ConfigurationOptionDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<ConfigurationOptionDescription> options);

        /**
         * <p>
         * A list of <a>ConfigurationOptionDescription</a>.
         * </p>
         * 
         * @param options
         *        A list of <a>ConfigurationOptionDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(ConfigurationOptionDescription... options);

        /**
         * <p>
         * A list of <a>ConfigurationOptionDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #options(List<ConfigurationOptionDescription>)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link List<ConfigurationOptionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(List<ConfigurationOptionDescription>)
         */
        Builder options(Consumer<ConfigurationOptionDescription.Builder>... options);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private String solutionStackName;

        private String platformArn;

        private List<ConfigurationOptionDescription> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsResponse model) {
            super(model);
            solutionStackName(model.solutionStackName);
            platformArn(model.platformArn);
            options(model.options);
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final List<ConfigurationOptionDescription.Builder> getOptions() {
            List<ConfigurationOptionDescription.Builder> result = ConfigurationOptionDescriptionsListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder options(Collection<ConfigurationOptionDescription> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(ConfigurationOptionDescription... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<ConfigurationOptionDescription.Builder>... options) {
            options(Stream.of(options).map(c -> ConfigurationOptionDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptions(Collection<ConfigurationOptionDescription.BuilderImpl> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public DescribeConfigurationOptionsResponse build() {
            return new DescribeConfigurationOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
