/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed health information about an Amazon EC2 instance in your Elastic Beanstalk environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleInstanceHealth implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleInstanceHealth.Builder, SingleInstanceHealth> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SingleInstanceHealth::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(SingleInstanceHealth::healthStatus)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(SingleInstanceHealth::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<List<String>> CAUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Causes")
            .getter(getter(SingleInstanceHealth::causes))
            .setter(setter(Builder::causes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Causes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAUNCHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchedAt").getter(getter(SingleInstanceHealth::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final SdkField<ApplicationMetrics> APPLICATION_METRICS_FIELD = SdkField
            .<ApplicationMetrics> builder(MarshallingType.SDK_POJO).memberName("ApplicationMetrics")
            .getter(getter(SingleInstanceHealth::applicationMetrics)).setter(setter(Builder::applicationMetrics))
            .constructor(ApplicationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMetrics").build())
            .build();

    private static final SdkField<SystemStatus> SYSTEM_FIELD = SdkField.<SystemStatus> builder(MarshallingType.SDK_POJO)
            .memberName("System").getter(getter(SingleInstanceHealth::system)).setter(setter(Builder::system))
            .constructor(SystemStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("System").build()).build();

    private static final SdkField<Deployment> DEPLOYMENT_FIELD = SdkField.<Deployment> builder(MarshallingType.SDK_POJO)
            .memberName("Deployment").getter(getter(SingleInstanceHealth::deployment)).setter(setter(Builder::deployment))
            .constructor(Deployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployment").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(SingleInstanceHealth::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(SingleInstanceHealth::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            HEALTH_STATUS_FIELD, COLOR_FIELD, CAUSES_FIELD, LAUNCHED_AT_FIELD, APPLICATION_METRICS_FIELD, SYSTEM_FIELD,
            DEPLOYMENT_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String healthStatus;

    private final String color;

    private final List<String> causes;

    private final Instant launchedAt;

    private final ApplicationMetrics applicationMetrics;

    private final SystemStatus system;

    private final Deployment deployment;

    private final String availabilityZone;

    private final String instanceType;

    private SingleInstanceHealth(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.color = builder.color;
        this.causes = builder.causes;
        this.launchedAt = builder.launchedAt;
        this.applicationMetrics = builder.applicationMetrics;
        this.system = builder.system;
        this.deployment = builder.deployment;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Returns the health status of the specified instance. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
     * Statuses</a>.
     * </p>
     * 
     * @return Returns the health status of the specified instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors
     *         and Statuses</a>.
     */
    public final String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * Represents the color indicator that gives you information about the health of the EC2 instance. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
     * Statuses</a>.
     * </p>
     * 
     * @return Represents the color indicator that gives you information about the health of the EC2 instance. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors
     *         and Statuses</a>.
     */
    public final String color() {
        return color;
    }

    /**
     * Returns true if the Causes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCauses() {
        return causes != null && !(causes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the causes, which provide more information about the current health status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCauses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the causes, which provide more information about the current health status.
     */
    public final List<String> causes() {
        return causes;
    }

    /**
     * <p>
     * The time at which the EC2 instance was launched.
     * </p>
     * 
     * @return The time at which the EC2 instance was launched.
     */
    public final Instant launchedAt() {
        return launchedAt;
    }

    /**
     * <p>
     * Request metrics from your application.
     * </p>
     * 
     * @return Request metrics from your application.
     */
    public final ApplicationMetrics applicationMetrics() {
        return applicationMetrics;
    }

    /**
     * <p>
     * Operating system metrics from the instance.
     * </p>
     * 
     * @return Operating system metrics from the instance.
     */
    public final SystemStatus system() {
        return system;
    }

    /**
     * <p>
     * Information about the most recent deployment to an instance.
     * </p>
     * 
     * @return Information about the most recent deployment to an instance.
     */
    public final Deployment deployment() {
        return deployment;
    }

    /**
     * <p>
     * The availability zone in which the instance runs.
     * </p>
     * 
     * @return The availability zone in which the instance runs.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The instance's type.
     * </p>
     * 
     * @return The instance's type.
     */
    public final String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(hasCauses() ? causes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(applicationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(system());
        hashCode = 31 * hashCode + Objects.hashCode(deployment());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleInstanceHealth)) {
            return false;
        }
        SingleInstanceHealth other = (SingleInstanceHealth) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(healthStatus(), other.healthStatus())
                && Objects.equals(color(), other.color()) && hasCauses() == other.hasCauses()
                && Objects.equals(causes(), other.causes()) && Objects.equals(launchedAt(), other.launchedAt())
                && Objects.equals(applicationMetrics(), other.applicationMetrics()) && Objects.equals(system(), other.system())
                && Objects.equals(deployment(), other.deployment())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceType(), other.instanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleInstanceHealth").add("InstanceId", instanceId()).add("HealthStatus", healthStatus())
                .add("Color", color()).add("Causes", hasCauses() ? causes() : null).add("LaunchedAt", launchedAt())
                .add("ApplicationMetrics", applicationMetrics()).add("System", system()).add("Deployment", deployment())
                .add("AvailabilityZone", availabilityZone()).add("InstanceType", instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "Causes":
            return Optional.ofNullable(clazz.cast(causes()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        case "ApplicationMetrics":
            return Optional.ofNullable(clazz.cast(applicationMetrics()));
        case "System":
            return Optional.ofNullable(clazz.cast(system()));
        case "Deployment":
            return Optional.ofNullable(clazz.cast(deployment()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleInstanceHealth, T> g) {
        return obj -> g.apply((SingleInstanceHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleInstanceHealth> {
        /**
         * <p>
         * The ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Returns the health status of the specified instance. For more information, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
         * Statuses</a>.
         * </p>
         * 
         * @param healthStatus
         *        Returns the health status of the specified instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health
         *        Colors and Statuses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * Represents the color indicator that gives you information about the health of the EC2 instance. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
         * Statuses</a>.
         * </p>
         * 
         * @param color
         *        Represents the color indicator that gives you information about the health of the EC2 instance. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health
         *        Colors and Statuses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * Represents the causes, which provide more information about the current health status.
         * </p>
         * 
         * @param causes
         *        Represents the causes, which provide more information about the current health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causes(Collection<String> causes);

        /**
         * <p>
         * Represents the causes, which provide more information about the current health status.
         * </p>
         * 
         * @param causes
         *        Represents the causes, which provide more information about the current health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causes(String... causes);

        /**
         * <p>
         * The time at which the EC2 instance was launched.
         * </p>
         * 
         * @param launchedAt
         *        The time at which the EC2 instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(Instant launchedAt);

        /**
         * <p>
         * Request metrics from your application.
         * </p>
         * 
         * @param applicationMetrics
         *        Request metrics from your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMetrics(ApplicationMetrics applicationMetrics);

        /**
         * <p>
         * Request metrics from your application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationMetrics.Builder} avoiding the need to
         * create one manually via {@link ApplicationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationMetrics(ApplicationMetrics)}.
         * 
         * @param applicationMetrics
         *        a consumer that will call methods on {@link ApplicationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationMetrics(ApplicationMetrics)
         */
        default Builder applicationMetrics(Consumer<ApplicationMetrics.Builder> applicationMetrics) {
            return applicationMetrics(ApplicationMetrics.builder().applyMutation(applicationMetrics).build());
        }

        /**
         * <p>
         * Operating system metrics from the instance.
         * </p>
         * 
         * @param system
         *        Operating system metrics from the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(SystemStatus system);

        /**
         * <p>
         * Operating system metrics from the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link SystemStatus.Builder} avoiding the need to
         * create one manually via {@link SystemStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link SystemStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #system(SystemStatus)}.
         * 
         * @param system
         *        a consumer that will call methods on {@link SystemStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #system(SystemStatus)
         */
        default Builder system(Consumer<SystemStatus.Builder> system) {
            return system(SystemStatus.builder().applyMutation(system).build());
        }

        /**
         * <p>
         * Information about the most recent deployment to an instance.
         * </p>
         * 
         * @param deployment
         *        Information about the most recent deployment to an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployment(Deployment deployment);

        /**
         * <p>
         * Information about the most recent deployment to an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Deployment.Builder} avoiding the need to create
         * one manually via {@link Deployment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Deployment.Builder#build()} is called immediately and its result
         * is passed to {@link #deployment(Deployment)}.
         * 
         * @param deployment
         *        a consumer that will call methods on {@link Deployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployment(Deployment)
         */
        default Builder deployment(Consumer<Deployment.Builder> deployment) {
            return deployment(Deployment.builder().applyMutation(deployment).build());
        }

        /**
         * <p>
         * The availability zone in which the instance runs.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone in which the instance runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The instance's type.
         * </p>
         * 
         * @param instanceType
         *        The instance's type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String healthStatus;

        private String color;

        private List<String> causes = DefaultSdkAutoConstructList.getInstance();

        private Instant launchedAt;

        private ApplicationMetrics applicationMetrics;

        private SystemStatus system;

        private Deployment deployment;

        private String availabilityZone;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleInstanceHealth model) {
            instanceId(model.instanceId);
            healthStatus(model.healthStatus);
            color(model.color);
            causes(model.causes);
            launchedAt(model.launchedAt);
            applicationMetrics(model.applicationMetrics);
            system(model.system);
            deployment(model.deployment);
            availabilityZone(model.availabilityZone);
            instanceType(model.instanceType);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getColor() {
            return color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        public final Collection<String> getCauses() {
            if (causes instanceof SdkAutoConstructList) {
                return null;
            }
            return causes;
        }

        @Override
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder causes(String... causes) {
            causes(Arrays.asList(causes));
            return this;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        public final Instant getLaunchedAt() {
            return launchedAt;
        }

        @Override
        public final Builder launchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final void setLaunchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return applicationMetrics != null ? applicationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        public final SystemStatus.Builder getSystem() {
            return system != null ? system.toBuilder() : null;
        }

        @Override
        public final Builder system(SystemStatus system) {
            this.system = system;
            return this;
        }

        public final void setSystem(SystemStatus.BuilderImpl system) {
            this.system = system != null ? system.build() : null;
        }

        public final Deployment.Builder getDeployment() {
            return deployment != null ? deployment.toBuilder() : null;
        }

        @Override
        public final Builder deployment(Deployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public final void setDeployment(Deployment.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public SingleInstanceHealth build() {
            return new SingleInstanceHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
